/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.util.Log;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.InternalUtils;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UrlCfgUtils {
    private static final String TAG = "UrlCfgUtils";
    static final char QUESTION_MARK = '?';
    static final char AND_MARK = '&';
    static final char EQUAL_MARK = '=';

    public static String configNormalSegments(String url, Map<String, Object> segments) {
        return UrlCfgUtils.configUrl(url, segments);
    }

    private static String configUrl(String url, Map<String, Object> segments) {
        if (segments == null || segments.isEmpty()) {
            return url;
        }
        StringBuilder ret = new StringBuilder(url);
        if (UrlCfgUtils.urlContainQuestionMark(url)) {
            ret.append('&');
        } else {
            ret.append('?');
        }
        Set<Map.Entry<String, Object>> entrys = segments.entrySet();
        Iterator<Map.Entry<String, Object>> it = entrys.iterator();
        try {
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    Log.d((String)TAG, (String)("the value with key [ " + key + " ] is null or empty , ignore it "));
                    continue;
                }
                ret.append(key).append('=').append(URLEncoder.encode(value.toString().trim(), "UTF-8")).append('&');
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception", (Throwable)e);
            return null;
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    static boolean urlContainQuestionMark(String url) {
        int index = url.lastIndexOf(63);
        return index > -1;
    }

    public static String getJsonData(Map<String, Object> segments) {
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        Set<Map.Entry<String, Object>> entrys = segments.entrySet();
        Iterator<Map.Entry<String, Object>> it = entrys.iterator();
        try {
            JSONObject object = new JSONObject();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                Object value = entry.getValue();
                if (value == null) {
                    Log.d((String)TAG, (String)("the value with key [ " + entry.getKey() + " ] is null or empty , ignore it "));
                    continue;
                }
                if (value instanceof String) {
                    String str = (String)value;
                    if (CommonUtils.isStringInvalid(str)) continue;
                    object.put(entry.getKey(), (Object)str.trim());
                    continue;
                }
                if (value instanceof List) {
                    JSONArray array = new JSONArray();
                    for (Object v : (List)value) {
                        array.add(v);
                    }
                    object.put(entry.getKey(), (Object)array);
                    continue;
                }
                if (value instanceof Object) {
                    object.put(entry.getKey(), value);
                    continue;
                }
                throw new Exception("this key: " + entry.getKey() + " is illegal");
            }
            return object.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRandomKey() {
        switch (InternalUtils.getServer()) {
            case 0: {
                return "123456";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "t5B6I@N&JaLVozpX";
            }
        }
        return "";
    }
}

