/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class Prefs {
    private static Prefs INSTANCE = null;
    private SharedPreferences sharedPreference;
    private Context context;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_INT = 0;
    public static final int TYPE_FLOAT = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_LONG = 3;
    public static final int TYPE_BOOLEAN = 4;

    private Prefs(Context context) {
        this.context = context;
        this.sharedPreference = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Prefs getInstance(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<Prefs> clazz = Prefs.class;
        synchronized (Prefs.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Prefs(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void save(int type, String key, Object value) {
        switch (type) {
            case 0: {
                this.sharedPreference.edit().putInt(key, ((Integer)value).intValue()).commit();
                break;
            }
            case 1: {
                this.sharedPreference.edit().putFloat(key, ((Float)value).floatValue()).commit();
                break;
            }
            case 2: {
                this.sharedPreference.edit().putString(key, (String)value).commit();
                break;
            }
            case 3: {
                this.sharedPreference.edit().putLong(key, ((Long)value).longValue()).commit();
                break;
            }
            case 4: {
                this.sharedPreference.edit().putBoolean(key, ((Boolean)value).booleanValue()).commit();
                break;
            }
            default: {
                throw new IllegalArgumentException("check your object type first !!!");
            }
        }
    }

    public Object get(int type, String key, Object defValue) {
        Object ret = null;
        switch (type) {
            case 0: {
                ret = this.sharedPreference.getInt(key, ((Integer)defValue).intValue());
                break;
            }
            case 1: {
                ret = Float.valueOf(this.sharedPreference.getFloat(key, ((Float)defValue).floatValue()));
                break;
            }
            case 2: {
                ret = this.sharedPreference.getString(key, (String)defValue);
                break;
            }
            case 3: {
                ret = this.sharedPreference.getLong(key, ((Long)defValue).longValue());
                break;
            }
            case 4: {
                ret = this.sharedPreference.getBoolean(key, ((Boolean)defValue).booleanValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("check your object type first !!!");
            }
        }
        return ret;
    }
}

