/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.Map;
import java.util.Set;

public class NewPrefs {
    private static final String TAG = NewPrefs.class.getSimpleName();
    private static SharedPreferences sharedPreference;

    private NewPrefs() {
    }

    public static SharedPreferences getInstance() {
        return sharedPreference;
    }

    public static void init(Context context) {
        sharedPreference = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private static void checkIfNull() {
        if (sharedPreference == null) {
            Log.e((String)TAG, (String)"Warning,PreferenceManager init ERROR.");
        }
    }

    public static void addBooleanPreference(String key, boolean b) {
        NewPrefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putBoolean(key, b);
        editor.commit();
    }

    public static void addFloatPreference(String key, float f) {
        NewPrefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putFloat(key, f);
        editor.commit();
    }

    public static void addIntPreference(String key, int i) {
        NewPrefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putInt(key, i);
        editor.commit();
    }

    public static void addLongPreference(String key, long l) {
        NewPrefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putLong(key, l);
        editor.commit();
    }

    public static void addStringPreference(String key, String s) {
        NewPrefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putString(key, s);
        editor.commit();
    }

    public static void addStringSetPreference(String key, Set<String> stringSet) {
        NewPrefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putStringSet(key, stringSet);
        editor.commit();
    }

    public static Object getPreference(String key, Object defaultValue) {
        NewPrefs.checkIfNull();
        Object res = sharedPreference.getAll().get(key);
        return res == null ? defaultValue : res;
    }

    public static boolean getBooleanPreference(String key, boolean defaultValue) {
        NewPrefs.checkIfNull();
        try {
            Object object = sharedPreference.getAll().get(key);
            if (object == null) {
                return defaultValue;
            }
            return (Boolean)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String getStringPreference(String key, String defaultValue) {
        NewPrefs.checkIfNull();
        String res = null;
        try {
            res = (String)sharedPreference.getAll().get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null) {
            return res.toString();
        }
        return defaultValue;
    }

    public static int getIntPreference(String key, int defaultValue) {
        NewPrefs.checkIfNull();
        try {
            Object object = sharedPreference.getAll().get(key);
            if (object == null) {
                return defaultValue;
            }
            return (Integer)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static Map<String, ?> getAllPreference() {
        NewPrefs.checkIfNull();
        return sharedPreference.getAll();
    }
}

