/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.PermissionUtils;
import com.shouzhan.clientcommon.Prefs;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;

public class DeviceHelper {
    private static final String TAG = DeviceHelper.class.getSimpleName();
    private static final String SPECIAL_MAC_ADDRESS = "02:00:00:00:00:00";
    private static final String SPECIAL_DEVICE_ID = "9774d56d682e549c";
    private static final String WIFI = "WIFI";
    public static final String ITEM_DEVICE_ID = "item_device_id";
    private static String sDeviceId = null;
    private static String mImei = null;
    private static final Object devIdLock = new Object();
    private static final String[] BRANDS = new String[]{"huawei", "honor", "meizu", "oppo", "vivo", "xiaomi", "samsung", "sunmi"};

    public static String getSerialNumber() {
        String serial = "";
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serial;
    }

    public static String getDeviceId(Context mContext) {
        if (CommonUtils.isStringInvalid(sDeviceId)) {
            DeviceHelper.retryFinalDevId(mContext);
        }
        return sDeviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retryFinalDevId(Context context) {
        Object object = devIdLock;
        synchronized (object) {
            String savedDeviceId = (String)Prefs.getInstance(context).get(2, ITEM_DEVICE_ID, null);
            if (savedDeviceId == null) {
                String deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                if (CommonUtils.isStringInvalid(deviceId) || SPECIAL_DEVICE_ID.equals(deviceId)) {
                    deviceId = UUID.randomUUID().toString();
                }
                if (CommonUtils.isStringInvalid(deviceId)) {
                    deviceId = DeviceHelper.getDeviceImei(context);
                }
                if (CommonUtils.isStringInvalid(deviceId) && DeviceHelper.getAndroidOSVersion() >= 23) {
                    deviceId = DeviceHelper.getMac();
                }
                if (CommonUtils.isStringInvalid(deviceId) || SPECIAL_MAC_ADDRESS.equals(deviceId)) {
                    deviceId = DeviceHelper.getPublicDeviceMac(context);
                }
                Prefs.getInstance(context).save(2, ITEM_DEVICE_ID, deviceId);
                sDeviceId = deviceId;
            } else {
                sDeviceId = savedDeviceId;
            }
        }
    }

    public static String getMac() {
        String str = "";
        String macSerial = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (macSerial == null || "".equals(macSerial)) {
            try {
                return DeviceHelper.loadFileAsString("/sys/class/net/eth0/address").toUpperCase().substring(0, 17);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return macSerial;
    }

    public static String loadFileAsString(String fileName) throws Exception {
        FileReader reader = new FileReader(fileName);
        String text = DeviceHelper.loadReaderAsString(reader);
        reader.close();
        return text;
    }

    public static String loadReaderAsString(Reader reader) throws Exception {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int readLength = reader.read(buffer);
        while (readLength >= 0) {
            builder.append(buffer, 0, readLength);
            readLength = reader.read(buffer);
        }
        return builder.toString();
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getPublicDeviceMac(Context context) {
        String ret = "";
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = null;
        if (PermissionUtils.checkSelfPermission(context, PermissionUtils.NETWORK_PERMISSIONS[0])) {
            ni = cm.getActiveNetworkInfo();
        }
        if (ni == null) {
            ret = DeviceHelper.getMacEth();
            return ret;
        }
        String netTypeName = ni.getTypeName();
        if (WIFI.equals(netTypeName)) {
            WifiManager wm = (WifiManager)context.getSystemService("wifi");
            if (PermissionUtils.checkSelfPermission(context, PermissionUtils.NETWORK_PERMISSIONS[1])) {
                ret = wm.getConnectionInfo().getMacAddress();
            }
        } else {
            ret = DeviceHelper.getMacEth();
        }
        return ret;
    }

    private static String getMacEth() {
        String macEth = null;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block2: while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> net = intf.getInetAddresses();
                while (net.hasMoreElements()) {
                    InetAddress iaddr = net.nextElement();
                    if (!(iaddr instanceof Inet4Address) || iaddr.isLoopbackAddress()) continue;
                    byte[] data = intf.getHardwareAddress();
                    StringBuilder sb = new StringBuilder();
                    if (data != null && data.length > 1) {
                        sb.append(DeviceHelper.parseByte(data[0])).append(":").append(DeviceHelper.parseByte(data[1])).append(":").append(DeviceHelper.parseByte(data[2])).append(":").append(DeviceHelper.parseByte(data[3])).append(":").append(DeviceHelper.parseByte(data[4])).append(":").append(DeviceHelper.parseByte(data[5]));
                    }
                    macEth = sb.toString();
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return macEth;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceImei(Context context) {
        TelephonyManager tm;
        if (mImei == null && context != null && (tm = (TelephonyManager)context.getSystemService("phone")) != null) {
            try {
                if (PermissionUtils.checkSelfPermission(context, PermissionUtils.READ_PHONE_STATE_PERMISSION[0])) {
                    mImei = tm.getDeviceId();
                }
            }
            catch (Exception e) {
                mImei = "";
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
        return mImei;
    }

    private static String parseByte(byte b) {
        int intValue = b >= 0 ? b : 256 + b;
        return Integer.toHexString(intValue);
    }

    public static int getAndroidOSVersion() {
        int osVersion;
        try {
            osVersion = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (NumberFormatException e) {
            osVersion = 0;
        }
        return osVersion;
    }

    public static String getSdkLevel(String minVersionCode) {
        String sdkLevel = null;
        if (minVersionCode != null) {
            int code = Integer.parseInt(minVersionCode);
            switch (code) {
                case 1: {
                    sdkLevel = "Android 1.0";
                    break;
                }
                case 2: {
                    sdkLevel = "Android 1.1";
                    break;
                }
                case 3: {
                    sdkLevel = "Android 1.5";
                    break;
                }
                case 4: {
                    sdkLevel = "Android 1.6";
                    break;
                }
                case 5: {
                    sdkLevel = "Android 2.0";
                    break;
                }
                case 6: {
                    sdkLevel = "Android 2.0.1";
                    break;
                }
                case 7: {
                    sdkLevel = "Android 2.1";
                    break;
                }
                case 8: {
                    sdkLevel = "Android 2.2";
                    break;
                }
                case 9: {
                    sdkLevel = "Android 2.3";
                    break;
                }
                case 10: {
                    sdkLevel = "Android 2.3.3";
                    break;
                }
                case 11: {
                    sdkLevel = "Android 3.0";
                    break;
                }
                case 12: {
                    sdkLevel = "Android 3.1";
                    break;
                }
                case 13: {
                    sdkLevel = "Android 3.2";
                    break;
                }
                case 14: {
                    sdkLevel = "Android 4.0";
                    break;
                }
                case 15: {
                    sdkLevel = "Android 4.0.3";
                    break;
                }
                case 16: {
                    sdkLevel = "Android 4.1";
                    break;
                }
                case 17: {
                    sdkLevel = "Android 4.2";
                    break;
                }
                case 18: {
                    sdkLevel = "Android 4.3";
                    break;
                }
                case 19: {
                    sdkLevel = "Android 4.4";
                    break;
                }
                case 20: {
                    sdkLevel = "Android 4.4W";
                    break;
                }
                case 21: {
                    sdkLevel = "Android 5.0";
                    break;
                }
                case 22: {
                    sdkLevel = "Android 5.1";
                    break;
                }
                case 23: {
                    sdkLevel = "Android 6.0";
                    break;
                }
                case 24: {
                    sdkLevel = "Android 7.0";
                    break;
                }
                case 25: {
                    sdkLevel = "Android 7.1.1";
                    break;
                }
            }
        }
        return sdkLevel;
    }

    public static String getDeviceBrand() {
        String brand = Build.BRAND.toLowerCase();
        for (String s : BRANDS) {
            if (!brand.contains(s)) continue;
            return s;
        }
        return "other";
    }

    public static String getDeviceModel() {
        String model = "";
        try {
            model = Build.MODEL.toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }
}

