/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import com.annimon.stream.Stream;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;

public class VersionUtil {
    public static final int VERSION_MATCHED = 0;
    public static final int VERSION_OLDER = -1;
    public static final int VERSION_NEWER = 1;
    private static final String DEFAULT_VERSION_NUMBER = "0";

    public static int compareVersions(String current, String target) {
        List currentVer = Splitter.on((String)".").trimResults().splitToList((CharSequence)Strings.nullToEmpty((String)current));
        List targetVer = Splitter.on((String)".").trimResults().splitToList((CharSequence)Strings.nullToEmpty((String)target));
        int max = Math.max(currentVer.size(), targetVer.size());
        for (int i = 0; i != max; ++i) {
            int r;
            String idxTarget;
            String idxCurrent = i < currentVer.size() ? VersionUtil.getStr((String)currentVer.get(i), DEFAULT_VERSION_NUMBER) : DEFAULT_VERSION_NUMBER;
            String string = idxTarget = i < targetVer.size() ? VersionUtil.getStr((String)targetVer.get(i), DEFAULT_VERSION_NUMBER) : DEFAULT_VERSION_NUMBER;
            if (idxCurrent.length() != idxTarget.length()) {
                int maxLen = Math.max(idxCurrent.length(), idxTarget.length());
                idxCurrent = VersionUtil.paddingStringWithCharacter(idxCurrent, maxLen, Character.valueOf('0'));
                idxTarget = VersionUtil.paddingStringWithCharacter(idxTarget, maxLen, Character.valueOf('0'));
            }
            if ((r = idxCurrent.compareToIgnoreCase(idxTarget)) == 0) continue;
            return r > 0 ? 1 : -1;
        }
        return 0;
    }

    public static String getVersion(String version, int digit) {
        if (Strings.isNullOrEmpty((String)version)) {
            return "";
        }
        List versions = Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)version);
        if (digit < 1) {
            digit = 1;
        } else if (digit >= versions.size()) {
            digit = versions.size();
        }
        return Joiner.on((String)".").join(Stream.of((Iterable)versions).limit((long)digit).iterator());
    }

    private static String getStr(String str, String defaultVal) {
        if (Strings.isNullOrEmpty((String)str)) {
            return defaultVal;
        }
        return str;
    }

    private static String paddingStringWithCharacter(String s, int max, Character c) {
        if (s.length() < max) {
            StringBuilder sb = new StringBuilder(max);
            for (int i = 0; i != max - s.length(); ++i) {
                sb.append(c);
            }
            sb.append(s);
            return sb.toString();
        }
        return s;
    }
}

