/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.newlog;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.fshows.android.stark.R;
import com.fshows.android.stark.utils.DateUtil;
import com.fshows.android.stark.utils.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class LogcatActivity
extends AppCompatActivity
implements View.OnClickListener {
    private WebView mWebView = null;
    private Spinner mSpinner = null;
    private EditText mFileDateEt = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(16974065);
        this.setContentView(R.layout.activity_logcat);
        this.initUi();
    }

    private void initUi() {
        this.mWebView = (WebView)this.findViewById(R.id.wv_display_logcat);
        this.mSpinner = (Spinner)this.findViewById(R.id.sp_file_suffix);
        this.mFileDateEt = (EditText)this.findViewById(R.id.et_file_date);
        this.findViewById(R.id.btn_clean_files).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_send_log).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_watch_log).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_show_date).setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.btn_clean_files) {
            this.showDeleteLogDialog();
        } else if (view.getId() == R.id.btn_watch_log) {
            this.findLog();
        } else if (view.getId() == R.id.btn_send_log) {
            this.uploadLogFile();
        } else if (view.getId() == R.id.btn_show_date) {
            this.mFileDateEt.setText((CharSequence)DateUtil.getStringByFormat(new Date(), DateUtil.dateFormatYMD));
        }
    }

    private void showDeleteLogDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u63d0\u793a");
        builder.setMessage((CharSequence)"\u662f\u5426\u5220\u9664\u5f53\u524d\u65e5\u5fd7?");
        builder.setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LogcatActivity.this.deleteLogFiles();
            }
        });
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    private void deleteLogFiles() {
        String fileDate = this.mFileDateEt.getText().toString();
        StringBuilder builder = new StringBuilder(FileUtil.getRootPath((Context)this)).append(File.separator).append("logs").append(File.separator).append(fileDate);
        File logRootDir = new File(builder.toString());
        if (!logRootDir.exists() || !logRootDir.canWrite()) {
            Toast.makeText((Context)this, (CharSequence)"\u6ca1\u6709\u53d1\u73b0\u65e5\u5fd7\u76ee\u5f55", (int)1).show();
            return;
        }
        File[] childs = logRootDir.listFiles();
        if (null == childs) {
            Toast.makeText((Context)this, (CharSequence)"\u6ca1\u6709\u53d1\u73b0\u65e5\u5fd7\u6587\u4ef6", (int)1).show();
            return;
        }
        for (File f : childs) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findLog() {
        String fileDate = this.mFileDateEt.getText().toString();
        StringBuilder builder = new StringBuilder(FileUtil.getRootPath((Context)this)).append(File.separator).append("logs").append(File.separator).append(fileDate);
        File logRootDir = new File(builder.toString());
        if (!logRootDir.exists() || !logRootDir.canWrite()) {
            Toast.makeText((Context)this, (CharSequence)"\u6ca1\u6709\u53d1\u73b0\u65e5\u5fd7\u76ee\u5f55", (int)1).show();
            return;
        }
        String childFileName = fileDate + "_" + this.mSpinner.getSelectedItem().toString() + ".txt";
        File childFile = new File(logRootDir, childFileName);
        if (!childFile.exists()) {
            Toast.makeText((Context)this, (CharSequence)"\u6ca1\u6709\u53d1\u73b0\u65e5\u5fd7\u6587\u4ef6", (int)1).show();
            return;
        }
        String text = "";
        FileInputStream is = null;
        InputStreamReader sReader = null;
        BufferedReader reader = null;
        try {
            String line;
            is = new FileInputStream(childFile);
            sReader = new InputStreamReader((InputStream)is, "utf-8");
            reader = new BufferedReader(sReader);
            StringBuilder builder2 = new StringBuilder();
            builder.append("<html><body>");
            while ((line = reader.readLine()) != null) {
                builder2.append("<p>");
                builder2.append(line);
                builder2.append("</p>");
            }
            builder2.append("</body></html>");
            text = builder2.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != sReader) {
                    sReader.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
        this.mWebView.loadData(text, "text/html", "utf-8");
    }

    private void uploadLogFile() {
    }
}

