/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.httpdns;

import com.alibaba.sdk.android.httpdns.HttpDnsService;
import com.annimon.stream.function.Supplier;
import com.fshows.android.stark.httpdns.AliyunHttpDnsUtil;
import com.fshows.android.stark.httpdns.config.LocalDnsConfig;
import com.fshows.android.stark.httpdns.config.LocalDnsResolveHostItemConfig;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.GsonUtil;
import com.fshows.android.stark.utils.globalconfig.GlobalConfig;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Dns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012j\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/fshows/android/stark/httpdns/GlobalDnsResolver;", "", "()V", "LogTag", "", "SYSTEM_DNS", "Lokhttp3/Dns;", "kotlin.jvm.PlatformType", "getSYSTEM_DNS$annotations", "addressSupplier", "Lcom/annimon/stream/function/Supplier;", "getAddressSupplier", "()Lcom/annimon/stream/function/Supplier;", "setAddressSupplier", "(Lcom/annimon/stream/function/Supplier;)V", "globalConfigChangedHandler", "Lcom/fshows/android/stark/utils/globalconfig/GlobalConfig$ConfigChangedListener;", "localHostNameDns", "Ljava/util/HashMap;", "", "Ljava/net/InetAddress;", "Lkotlin/collections/HashMap;", "initialize", "", "resolveHost", "hostname", "updateLocalDnsResolveHosts", "json", "stark_debug"})
public final class GlobalDnsResolver {
    @NotNull
    public static final GlobalDnsResolver INSTANCE = new GlobalDnsResolver();
    @NotNull
    private static final String LogTag = "Stark.GlobalDnsResolver";
    private static final Dns SYSTEM_DNS = Dns.SYSTEM;
    @NotNull
    private static final GlobalConfig.ConfigChangedListener globalConfigChangedHandler;
    @NotNull
    private static final HashMap<String, List<InetAddress>> localHostNameDns;
    @Nullable
    private static Supplier<String> addressSupplier;

    private GlobalDnsResolver() {
    }

    @JvmStatic
    private static /* synthetic */ void getSYSTEM_DNS$annotations() {
    }

    @Nullable
    public final Supplier<String> getAddressSupplier() {
        return addressSupplier;
    }

    public final void setAddressSupplier(@Nullable Supplier<String> supplier) {
        addressSupplier = supplier;
    }

    private final void initialize() {
        block4: {
            Object object;
            Object object2;
            GlobalDnsResolver globalDnsResolver = this;
            boolean bl = false;
            try {
                JSONObject jSONObject;
                object2 = Result.Companion;
                GlobalDnsResolver $this$initialize_u24lambda_u2d1 = globalDnsResolver;
                boolean bl2 = false;
                object = GlobalConfig.getConfig("localDnsCfg", new JSONObject());
                if (object == null) {
                    jSONObject = null;
                } else {
                    JSONObject jSONObject2 = object;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    JSONObject $this$initialize_u24lambda_u2d1_u24lambda_u2d0 = jSONObject2;
                    boolean bl5 = false;
                    String string = $this$initialize_u24lambda_u2d1_u24lambda_u2d0.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.toString()");
                    $this$initialize_u24lambda_u2d1.updateLocalDnsResolveHosts(string);
                    jSONObject = jSONObject2;
                }
                JSONObject jSONObject3 = jSONObject;
                boolean bl6 = false;
                object2 = Result.constructor-impl(jSONObject3);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl7 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            globalDnsResolver = object2;
            bl = false;
            boolean bl8 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)globalDnsResolver);
            if (throwable == null) break block4;
            Throwable throwable2 = throwable;
            boolean bl9 = false;
            boolean bl10 = false;
            object = throwable2;
            boolean bl11 = false;
            Object it = object;
            boolean bl12 = false;
            FsLogUtil.error(LogTag, "initialize error, ", (Throwable)it, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void updateLocalDnsResolveHosts(String json) {
        block10: {
            boolean bl;
            Object object;
            Supplier<String> supplier = this;
            boolean bl2 = false;
            try {
                Unit unit;
                Object object2;
                object = Result.Companion;
                Supplier<String> $this$updateLocalDnsResolveHosts_u24lambda_u2d8 = supplier;
                boolean bl3 = false;
                Supplier<String> supplier2 = $this$updateLocalDnsResolveHosts_u24lambda_u2d8;
                bl = false;
                try {
                    object2 = Result.Companion;
                    Object $this$updateLocalDnsResolveHosts_u24lambda_u2d8_u24lambda_u2d3 = supplier2;
                    boolean bl4 = false;
                    $this$updateLocalDnsResolveHosts_u24lambda_u2d8_u24lambda_u2d3 = (LocalDnsConfig)GsonUtil.getGson().fromJson(json, LocalDnsConfig.class);
                    bl4 = false;
                    object2 = Result.constructor-impl((Object)$this$updateLocalDnsResolveHosts_u24lambda_u2d8_u24lambda_u2d3);
                }
                catch (Throwable $this$updateLocalDnsResolveHosts_u24lambda_u2d8_u24lambda_u2d3) {
                    Result.Companion bl4 = Result.Companion;
                    boolean bl5 = false;
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$updateLocalDnsResolveHosts_u24lambda_u2d8_u24lambda_u2d3));
                }
                supplier2 = object2;
                bl = false;
                Supplier<String> supplier3 = Result.isFailure-impl((Object)supplier2) ? null : supplier2;
                Supplier<String> cfg = supplier3 == null ? new LocalDnsConfig(false, null, 3, null) : supplier3;
                localHostNameDns.clear();
                if (!cfg.getEnabled()) {
                    return;
                }
                supplier3 = $this$updateLocalDnsResolveHosts_u24lambda_u2d8.getAddressSupplier();
                if (supplier3 == null) {
                    unit = null;
                } else {
                    supplier2 = supplier3;
                    bl = false;
                    boolean bl6 = false;
                    Supplier<String> supplier4 = supplier2;
                    boolean bl7 = false;
                    Iterable $this$forEach$iv = cfg.getResolveHosts();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LocalDnsResolveHostItemConfig it = (LocalDnsResolveHostItemConfig)element$iv;
                        boolean bl8 = false;
                        String address = (String)supplier4.get();
                        if (!Pattern.compile(it.getRegion()).matcher(address).find()) continue;
                        Map $this$forEach$iv2 = it.getResolveList();
                        boolean $i$f$forEach2 = false;
                        Map map = $this$forEach$iv2;
                        boolean bl9 = false;
                        Iterator iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void $this$mapTo$iv$iv;
                            Map.Entry element$iv2;
                            Map.Entry p = element$iv2 = iterator.next();
                            boolean bl10 = false;
                            Map map2 = localHostNameDns;
                            Object k = p.getKey();
                            Iterable $this$map$iv = (Iterable)p.getValue();
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void q;
                                String string = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl11 = false;
                                InetAddress inetAddress = InetAddresses.forString((String)q);
                                collection.add(inetAddress);
                            }
                            List list = (List)destination$iv$iv;
                            boolean bl12 = false;
                            map2.put(k, list);
                        }
                    }
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
                boolean bl13 = false;
                object = Result.constructor-impl(unit2);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl14 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            supplier = object;
            bl2 = false;
            boolean bl15 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)supplier);
            if (throwable == null) break block10;
            Throwable throwable2 = throwable;
            boolean bl16 = false;
            boolean bl17 = false;
            Throwable throwable3 = throwable2;
            bl = false;
            Throwable it = throwable3;
            boolean bl18 = false;
            FsLogUtil.error(LogTag, "updateLocalDnsResolveHosts error, ", it, new Object[0]);
        }
    }

    @JvmStatic
    @NotNull
    public static final List<InetAddress> resolveHost(@NotNull String hostname) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Object object2 = INSTANCE;
        boolean bl = false;
        try {
            boolean bl2;
            Object object3;
            HttpDnsService aliyunHttpDns;
            object = Result.Companion;
            GlobalDnsResolver $this$resolveHost_u24lambda_u2d11 = object2;
            boolean bl3 = false;
            HttpDnsService httpDnsService = aliyunHttpDns = AliyunHttpDnsUtil.INSTANCE.getHttpDnsService();
            if (httpDnsService != null) {
                object3 = httpDnsService;
                boolean bl4 = false;
                bl2 = false;
                HttpDnsService it = object3;
                boolean bl5 = false;
                String ip = it.getIpByHostAsync(hostname);
                if (ip != null) {
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(ip);
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddressArray, (String)"getAllByName(ip)");
                    InetAddress[] inetAddressArray2 = inetAddressArray;
                    List inetAddresses = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(inetAddressArray2, inetAddressArray2.length));
                    FsLogUtil.debug(LogTag, "resolve => " + hostname + ": " + inetAddresses, new Object[0]);
                    return inetAddresses;
                }
            }
            if (localHostNameDns.containsKey(hostname)) {
                boolean bl6;
                List<InetAddress> list = localHostNameDns.get(hostname);
                object3 = list;
                if (object3 == null) {
                    bl6 = false;
                } else {
                    Collection collection = (Collection)object3;
                    bl2 = false;
                    bl6 = !collection.isEmpty();
                }
                if (bl6) {
                    return list;
                }
            }
            Unit unit = Unit.INSTANCE;
            boolean bl7 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl8 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        bl = false;
        boolean bl9 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable3 = throwable2;
            boolean bl12 = false;
            Throwable it = throwable3;
            boolean bl13 = false;
            Object[] objectArray = new Object[]{it.toString()};
            FsLogUtil.error(LogTag, "lookup " + hostname + " failed, ", objectArray);
        }
        object2 = SYSTEM_DNS.lookup(hostname);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SYSTEM_DNS.lookup(hostname)");
        return object2;
    }

    static {
        localHostNameDns = new HashMap();
        globalConfigChangedHandler = new GlobalConfig.ConfigChangedListener(){

            @Override
            public void onChanged(@NotNull JSONObject config) {
                block2: {
                    Object object;
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    1 var2_2 = this;
                    boolean bl = false;
                    try {
                        object2 = Result.Companion;
                        1 $this$onChanged_u24lambda_u2d0 = var2_2;
                        boolean bl2 = false;
                        FsLogUtil.info(GlobalDnsResolver.LogTag, "GlobalConfig Changed...", new Object[0]);
                        object = config.optString("localDnsCfg");
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"config.optString(\"localDnsCfg\")");
                        INSTANCE.updateLocalDnsResolveHosts((String)object);
                        Unit unit = Unit.INSTANCE;
                        boolean bl3 = false;
                        object2 = Result.constructor-impl((Object)unit);
                    }
                    catch (Throwable throwable) {
                        Result.Companion companion = Result.Companion;
                        boolean bl4 = false;
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    var2_2 = object2;
                    bl = false;
                    boolean bl5 = false;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)var2_2);
                    if (throwable == null) break block2;
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    object = throwable2;
                    boolean bl8 = false;
                    Object it = object;
                    boolean bl9 = false;
                    FsLogUtil.error(GlobalDnsResolver.LogTag, "update resolve list failed, ", new Object[0]);
                }
            }
        };
        GlobalConfig.INSTANCE.addConfigChangedListener(globalConfigChangedHandler);
        INSTANCE.initialize();
    }
}

