/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.annimon.stream.function.Supplier;
import com.fshows.android.stark.utils.DeviceHelper;
import com.fshows.android.stark.utils.NavigationStateChangedListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/fshows/android/stark/utils/DeviceCompatibleHelper;", "", "()V", "Xiaomi", "", "checkNavigationBarExist", "", "activity", "Landroid/app/Activity;", "listener", "Lcom/fshows/android/stark/utils/NavigationStateChangedListener;", "defaultStatusBarHeight", "", "context", "Landroid/content/Context;", "getNavigationBarHeight", "getStatusBarExpandPixel", "isXiaomiDevice", "", "isXiaomiFullScreenDisplay", "statusBarHeight", "stark_debug"})
public final class DeviceCompatibleHelper {
    @NotNull
    public static final DeviceCompatibleHelper INSTANCE = new DeviceCompatibleHelper();
    @NotNull
    private static final String Xiaomi = "xiaomi";

    private DeviceCompatibleHelper() {
    }

    @JvmStatic
    public static final boolean isXiaomiDevice() {
        return StringsKt.equals((String)DeviceHelper.getManufacturer(), (String)Xiaomi, (boolean)true);
    }

    @JvmStatic
    public static final boolean isXiaomiFullScreenDisplay(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 17 ? INSTANCE.isXiaomiDevice() && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0 : false;
    }

    @JvmStatic
    public static final int getNavigationBarHeight(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Resources resources = activity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    @JvmStatic
    public static final int statusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = Supplier.Util.safe(() -> DeviceCompatibleHelper.statusBarHeight$lambda-0(context)).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"safe<Int> {\n            \u2026(context)\n        }.get()");
        return ((Number)object).intValue();
    }

    @JvmStatic
    public static final int defaultStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int height = Build.VERSION.SDK_INT >= 23 ? 24 : 25;
        float f = (float)height * context.getResources().getDisplayMetrics().density;
        return (int)Math.floor(f);
    }

    @JvmStatic
    public static final int getStatusBarExpandPixel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int statusBarHeight = DeviceCompatibleHelper.statusBarHeight(context);
        int defaultBarHeight = DeviceCompatibleHelper.defaultStatusBarHeight(context);
        return RangesKt.coerceAtLeast((int)0, (int)(statusBarHeight - defaultBarHeight));
    }

    @JvmStatic
    public static final void checkNavigationBarExist(@NotNull Activity activity, @Nullable NavigationStateChangedListener listener) {
        Activity activity2;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Activity $this$checkNavigationBarExist_u24lambda_u2d2 = activity2 = activity;
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 20) {
            int navBarHeight = DeviceCompatibleHelper.getNavigationBarHeight($this$checkNavigationBarExist_u24lambda_u2d2);
            ViewCompat.setOnApplyWindowInsetsListener((View)$this$checkNavigationBarExist_u24lambda_u2d2.getWindow().getDecorView(), (arg_0, arg_1) -> DeviceCompatibleHelper.checkNavigationBarExist$lambda-2$lambda-1(navBarHeight, listener, arg_0, arg_1));
        }
    }

    private static final Integer statusBarHeight$lambda-0(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        int resourceId = $context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return $context.getResources().getDimensionPixelSize(resourceId);
        }
        return DeviceCompatibleHelper.defaultStatusBarHeight($context);
    }

    private static final WindowInsetsCompat checkNavigationBarExist$lambda-2$lambda-1(int $navBarHeight, NavigationStateChangedListener $listener, View $noName_0, WindowInsetsCompat windowInsets) {
        NavigationStateChangedListener navigationStateChangedListener;
        boolean showNav = false;
        int bottom = 0;
        if (windowInsets != null) {
            bottom = windowInsets.getSystemWindowInsetBottom();
            boolean bl = showNav = bottom == $navBarHeight;
        }
        if ((navigationStateChangedListener = $listener) != null) {
            navigationStateChangedListener.onNavigationStateChanged(showNav, $navBarHeight);
        }
        return windowInsets;
    }
}

