/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.newlog;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.fshows.android.stark.newlog.FsLogAdapter;
import com.fshows.android.stark.utils.DateUtil;
import com.fshows.android.stark.utils.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DiskLogAdapter
implements FsLogAdapter {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String NEW_LINE_REPLACEMENT = " <br> ";
    private static final String SEPARATOR = "/";
    private final Context mContext;
    private final WriteHandler mWriteHandler;

    public DiskLogAdapter(Context context) {
        this.mContext = context.getApplicationContext();
        String rootPath = FileUtil.getRootPath(this.mContext) + File.separator + "logs";
        HandlerThread ht = new HandlerThread("AndroidFileLogger." + rootPath);
        ht.start();
        this.mWriteHandler = new WriteHandler(ht.getLooper(), rootPath);
    }

    @Override
    public boolean isLoggable(int priority, String tag) {
        return true;
    }

    @Override
    public void log(int priority, String tag, String message) {
        Date date = new Date();
        StringBuilder builder = new StringBuilder();
        builder.append(DateUtil.getStringByFormat(date, DateUtil.dateFormatYMDHMS));
        builder.append(SEPARATOR);
        builder.append(this.mContext.getPackageName());
        builder.append(" ");
        builder.append(this.getLogLevel(priority));
        builder.append(SEPARATOR);
        builder.append(this.getFormatTag(tag));
        builder.append(":");
        assert (NEW_LINE != null);
        if (message.contains(NEW_LINE)) {
            message = message.replaceAll(NEW_LINE, NEW_LINE_REPLACEMENT);
        }
        builder.append(message);
        builder.append(NEW_LINE);
        this.mWriteHandler.handleMessage(this.mWriteHandler.obtainMessage(priority, builder.toString()));
    }

    @Override
    public String getFormatTag(String tag) {
        String onceOnlyTag = DiskLogAdapter.class.getSimpleName();
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            onceOnlyTag = onceOnlyTag + "-" + tag;
        }
        return onceOnlyTag;
    }

    private String getLogLevel(int value) {
        switch (value) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
            case 7: {
                return "ASSERT";
            }
        }
        return "UNKNOWN";
    }

    public static class WriteHandler
    extends Handler {
        private final String logFileDir;

        public WriteHandler(@NonNull Looper looper, String logFileDir) {
            super(looper);
            this.logFileDir = logFileDir;
        }

        public void handleMessage(@NonNull Message msg) {
            block4: {
                String content = (String)msg.obj;
                OutputStreamWriter fileWriter = null;
                try {
                    File logFile = this.getLogFile(this.logFileDir, msg.what);
                    fileWriter = new FileWriter(logFile, true);
                    this.writeLog((FileWriter)fileWriter, content);
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    if (fileWriter == null) break block4;
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException e1) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private File getLogFile(@NonNull String folderName, int priority) throws IOException {
            String logFileSuffix;
            File logFile;
            String yyyMMdd = DateUtil.getStringByFormat(new Date(), DateUtil.dateFormatYMD);
            File folder = new File(folderName + File.separator + yyyMMdd);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!(logFile = new File(folder, String.format("%s_%s.txt", yyyMMdd, logFileSuffix = priority == 6 ? "error" : "default"))).exists()) {
                logFile.createNewFile();
            }
            return logFile;
        }

        private void writeLog(@NonNull FileWriter fileWriter, @NonNull String content) throws IOException {
            fileWriter.append(content);
        }
    }
}

