/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AndroidDpConvertMobile {
    private static final String VERSION = "1.00.00";
    protected static final String DIMENS_FILE = "dimens.xml";
    protected static final String SIZES_FILE = "txsizes.xml";
    protected static final String STRINGS_FILE = "strings.xml";
    protected static final String DEFAULT_MODULE_DIR = "app";
    protected final boolean debug;
    protected String moduleDir;

    public AndroidDpConvertMobile(String moduleDir) {
        this(false, moduleDir);
        this.moduleDir = moduleDir;
    }

    public AndroidDpConvertMobile() {
        this(false, DEFAULT_MODULE_DIR);
    }

    public AndroidDpConvertMobile(boolean debug, String moduleDir) {
        this.moduleDir = moduleDir;
        this.debug = debug;
    }

    protected boolean isConvertTextSize() {
        return true;
    }

    protected boolean isConvertDebugString() {
        return false;
    }

    public final void convert() {
        String className = this.getClassTag();
        System.out.printf("start " + className + ": \n", new Object[0]);
        String current = System.getProperty("user.dir");
        System.out.printf("working directory: %s \n", current);
        ArrayList<DimenConverter> list = new ArrayList<DimenConverter>();
        this.fetchConverters(list);
        boolean success = true;
        for (int i = 0; i < list.size() && success; ++i) {
            success = ((DimenConverter)list.get(i)).convert();
        }
        if (success) {
            System.out.printf(className + " complete.\n", new Object[0]);
        } else {
            System.out.printf(className + " failed!!!.\n", new Object[0]);
        }
        System.out.printf(className + " version: " + VERSION, new Object[0]);
    }

    protected String getClassTag() {
        return this.getClass().getSimpleName();
    }

    protected void fetchConverters(List<DimenConverter> list) {
        list.add(new Sw300dpHdpiConverter());
        list.add(new Sw300dpXhdpiConverter());
        list.add(new Sw300dpXxhdpiConverter());
        list.add(new Sw360dpHdpiConverter());
        list.add(new Sw392dpConverter());
        list.add(new Sw400dpConverter());
        list.add(new Sw400dpHdpiConverter());
        list.add(new Sw400dp400dpiConverter());
        list.add(new Sw400dp420dpiConverter());
        list.add(new Sw480dp480dpiConverter());
        list.add(new Sw400dp560dpiConverter());
        list.add(new Sw457dpConverter());
        list.add(new Sw560dp400dpiConverter());
        list.add(new Sw500dpXhdpiConverter());
        list.add(new Sw700dpMdpiConverter());
        list.add(new Sw700dpHdpiConverter());
    }

    static interface DimenConverter {
        public boolean convert();
    }

    protected abstract class DpiBaseConverter
    implements DimenConverter {
        protected DpiBaseConverter() {
        }

        public final String getCurrentDir() {
            return System.getProperty("user.dir");
        }

        public final String split() {
            return System.getProperty("file.separator");
        }

        public final String getResourcesPath() {
            return this.getStudioResourcesDir() + this.split() + "res";
        }

        public final String getStudioResourcesDir() {
            return this.getCurrentDir() + this.split() + AndroidDpConvertMobile.this.moduleDir + this.split() + "src" + this.split() + "main";
        }

        public String getDefaultValuesPath() {
            return this.getResourcesPath() + this.split() + "values";
        }

        public String getConvertValuesPath() {
            return this.getResourcesPath() + this.split() + this.getConvertValuesName();
        }

        @Override
        public final boolean convert() {
            if (!this.performDimenConvert()) {
                System.out.printf(this.noteText() + " convert(), performDimenConvert failed! \n", new Object[0]);
                return false;
            }
            if (AndroidDpConvertMobile.this.isConvertTextSize() && !this.performTxSizeDimenConvert()) {
                System.out.printf(this.noteText() + " convert(), performTxSizeDimenConvert failed! \n", new Object[0]);
                return false;
            }
            if (AndroidDpConvertMobile.this.isConvertDebugString() && !this.performStringConvert()) {
                System.out.printf(this.noteText() + " convert(), performStringConvert failed! \n", new Object[0]);
                return false;
            }
            System.out.printf(this.noteText() + " perform convert complete\n", new Object[0]);
            return true;
        }

        public abstract String noteText();

        public abstract String getConvertValuesName();

        public abstract double convertDimen(double var1);

        public abstract double convertTxSizeDimen(double var1);

        public boolean performDimenConvert() {
            IConverter c = new IConverter(){

                @Override
                public double conversion(String unit, double value) {
                    return DpiBaseConverter.this.convertDimen(value) / 1.04;
                }

                @Override
                public String getUnits() {
                    return "sp|dip|dp|px";
                }
            };
            return this.performDimenConvert(this.getDefaultValuesPath(), this.getConvertValuesPath(), AndroidDpConvertMobile.DIMENS_FILE, c);
        }

        public boolean performTxSizeDimenConvert() {
            IConverter c = new IConverter(){

                @Override
                public double conversion(String unit, double value) {
                    return DpiBaseConverter.this.convertTxSizeDimen(value) / 1.04;
                }

                @Override
                public String getUnits() {
                    return "sp|dip|dp|px";
                }
            };
            return this.performDimenConvert(this.getDefaultValuesPath(), this.getConvertValuesPath(), AndroidDpConvertMobile.SIZES_FILE, c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean performDimenConvert(String defDimenDir, String convertDimenDir, String filename, IConverter converter) {
            File cvFile;
            File defFile = new File(defDimenDir, filename);
            if (!defFile.exists()) {
                throw new IllegalStateException("performDimenConvert. default dimens{" + defFile.getAbsolutePath() + "} file not exists.");
            }
            File dir = new File(convertDimenDir);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!(cvFile = new File(convertDimenDir, filename)).exists()) {
                try {
                    cvFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            cvFile.setWritable(true, false);
            OutputStreamWriter osWriter = null;
            BufferedWriter writer = null;
            InputStreamReader isReader = null;
            BufferedReader reader = null;
            try {
                osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cvFile), "utf-8");
                writer = new BufferedWriter(osWriter);
                isReader = new InputStreamReader((InputStream)new FileInputStream(defFile), "utf-8");
                reader = new BufferedReader(isReader);
                int count = 0;
                String UNITS = converter.getUnits();
                String REGULAR = String.format("\\>[\\s]*[-]?[0-9]+[.]?[0-9]*(%s)[\\s]*\\<", UNITS);
                Pattern p = Pattern.compile(REGULAR);
                String rLine = null;
                String wLine = null;
                while ((rLine = reader.readLine()) != null) {
                    Matcher m = p.matcher(rLine);
                    if (m.find()) {
                        String g = m.group();
                        String unitName = this.getUnitName(g, UNITS.split("[|]"));
                        double value = this.getUnitValue(g);
                        double dimen = converter.conversion(unitName, value);
                        String text = String.format(">%.2f%s<", dimen, unitName);
                        wLine = rLine.replaceAll(REGULAR, text);
                    } else {
                        wLine = rLine;
                    }
                    if (count > 0) {
                        writer.append('\n');
                    }
                    writer.append(wLine);
                    writer.flush();
                    rLine = null;
                    wLine = null;
                    ++count;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != writer) {
                        writer.close();
                        writer = null;
                    }
                    if (null != osWriter) {
                        osWriter.close();
                        osWriter = null;
                    }
                    if (null != reader) {
                        reader.close();
                        reader = null;
                    }
                    if (null != isReader) {
                        isReader.close();
                        isReader = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                cvFile.setReadOnly();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean performStringConvert() {
            File f;
            String d = this.getConvertValuesPath();
            String dpType = this.getConvertValuesName().replace("values-", "");
            if (AndroidDpConvertMobile.this.debug) {
                System.out.printf("d: %s, dptype: %s\n", d, dpType);
            }
            if (!(f = new File(this.getDefaultValuesPath() + this.split() + AndroidDpConvertMobile.STRINGS_FILE)).exists()) {
                System.out.printf("file: {%s} is not exists\n", f.getAbsoluteFile());
                return false;
            }
            File cvFile = new File(this.getConvertValuesPath(), AndroidDpConvertMobile.STRINGS_FILE);
            if (!cvFile.exists()) {
                try {
                    cvFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                System.out.printf("create file: %s\n", f.getAbsoluteFile());
            }
            cvFile.setWritable(true, false);
            InputStreamReader isReader = null;
            BufferedReader reader = null;
            OutputStreamWriter osWriter = null;
            BufferedWriter writer = null;
            try {
                isReader = new InputStreamReader((InputStream)new FileInputStream(f), "utf-8");
                reader = new BufferedReader(isReader);
                osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cvFile, false), "utf-8");
                writer = new BufferedWriter(osWriter);
                int count = 0;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("<string name=\"dimen_adaptive_title\">DensityDemo[default]</string>")) {
                        line = line.replace("default", dpType);
                    }
                    if (count > 0) {
                        writer.write(10);
                    }
                    writer.write(line);
                    writer.flush();
                    ++count;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != reader) {
                        reader.close();
                        reader = null;
                    }
                    if (null != isReader) {
                        isReader.close();
                        isReader = null;
                    }
                    if (null != writer) {
                        writer.close();
                        writer = null;
                    }
                    if (null != osWriter) {
                        osWriter.close();
                        osWriter = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                cvFile.setReadOnly();
            }
            return false;
        }

        private String getUnitName(String value, String[] units) {
            String name = "";
            String regular = "";
            for (int i = 0; i < units.length; ++i) {
                if (i > 0) {
                    regular = regular + "|";
                }
                regular = regular + units[i];
            }
            if (units.length > 0) {
                regular = "(" + regular;
                Pattern p = Pattern.compile(regular = regular + ")");
                Matcher m = p.matcher(value);
                if (m.find()) {
                    name = m.group();
                }
            }
            if (AndroidDpConvertMobile.this.debug) {
                System.out.printf("getUnitName, value: %s, regx: %s, name: %s\n ", value, regular, name);
            }
            return name;
        }

        public double getUnitValue(String text) {
            String REG = "[-]?[0-9]+[.]?[0-9]*";
            Pattern p = Pattern.compile("[-]?[0-9]+[.]?[0-9]*");
            Matcher m = p.matcher(text);
            if (!m.find()) {
                throw new IllegalArgumentException("getUnitValue. must content dimen value. text: " + text);
            }
            return Double.parseDouble(m.group());
        }
    }

    protected static interface IConverter {
        public double conversion(String var1, double var2);

        public String getUnits();
    }

    protected class Sw700dpHdpiConverter
    extends DpiBaseConverter {
        protected Sw700dpHdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw700dp-hdpi";
        }
    }

    protected class Sw700dpMdpiConverter
    extends DpiBaseConverter {
        protected Sw700dpMdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw700dp-mdpi";
        }
    }

    protected class Sw500dpXhdpiConverter
    extends DpiBaseConverter {
        protected Sw500dpXhdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 3.0 / 4.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw500dp-xhdpi";
        }
    }

    protected class Sw480dp480dpiConverter
    extends DpiBaseConverter {
        protected Sw480dp480dpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value / 2.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw480dp-480dpi";
        }
    }

    protected class Sw560dp400dpiConverter
    extends DpiBaseConverter {
        protected Sw560dp400dpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 4.0 / 7.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw560dp-xxxhdpi";
        }
    }

    protected class Sw457dpConverter
    extends DpiBaseConverter {
        protected Sw457dpConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 5.0 / 8.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw457dp";
        }
    }

    protected class Sw400dp560dpiConverter
    extends DpiBaseConverter {
        protected Sw400dp560dpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 4.0 / 7.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw400dp-560dpi";
        }
    }

    protected class Sw400dp420dpiConverter
    extends DpiBaseConverter {
        protected Sw400dp420dpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 4.0 / 7.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw400dp-420dpi";
        }
    }

    protected class Sw400dpHdpiConverter
    extends DpiBaseConverter {
        protected Sw400dpHdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 2.0 / 3.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw400dp-hdpi";
        }
    }

    protected class Sw400dp400dpiConverter
    extends DpiBaseConverter {
        protected Sw400dp400dpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 3.0 / 5.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw400dp-400dpi";
        }
    }

    protected class Sw400dpConverter
    extends DpiBaseConverter {
        protected Sw400dpConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 3.0 / 5.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw400dp";
        }
    }

    protected class Sw392dpConverter
    extends DpiBaseConverter {
        protected Sw392dpConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 6.0 / 11.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw392dp";
        }
    }

    protected class Sw360dpHdpiConverter
    extends DpiBaseConverter {
        protected Sw360dpHdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value / 2.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw360dp-hdpi";
        }
    }

    protected class Sw300dpXxhdpiConverter
    extends DpiBaseConverter {
        protected Sw300dpXxhdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value / 2.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw300dp-xxhdpi";
        }
    }

    protected class Sw300dpXhdpiConverter
    extends DpiBaseConverter {
        protected Sw300dpXhdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value / 2.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw300dp-xhdpi";
        }
    }

    protected class Sw300dpHdpiConverter
    extends DpiBaseConverter {
        protected Sw300dpHdpiConverter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public double convertDimen(double value) {
            return value * 4.0 / 9.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }

        @Override
        public String getConvertValuesName() {
            return "values-sw300dp-hdpi";
        }
    }
}

