/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.newlog;

import android.content.Context;
import com.fshows.android.stark.newlog.DiskLogAdapter;
import com.fshows.android.stark.newlog.FsLog;
import com.fshows.android.stark.newlog.FsLogPrinter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CrashCollector
implements Thread.UncaughtExceptionHandler {
    private static volatile CrashCollector mInstance = null;
    private final Lock mLock = new ReentrantLock();
    private final Condition mCondition = this.mLock.newCondition();
    private Thread.UncaughtExceptionHandler mOldHandler;
    private final FsLog mLogger;

    private CrashCollector(Context context) {
        FsLogPrinter printer = new FsLogPrinter();
        printer.addLogAdapter(new DiskLogAdapter(context.getApplicationContext()));
        this.mLogger = new FsLog(printer);
        try {
            this.mOldHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized CrashCollector getInstance(Context context) {
        if (null == mInstance) {
            mInstance = new CrashCollector(context);
        }
        return mInstance;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (null != ex) {
            new SaveLogThread(ex).start();
            this.mLock.lock();
            try {
                this.mCondition.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mLock.unlock();
        }
        if (null != this.mOldHandler) {
            this.mOldHandler.uncaughtException(thread, ex);
        }
    }

    private class SaveLogThread
    extends Thread {
        private final Throwable ex;

        public SaveLogThread(Throwable ex) {
            this.ex = ex;
        }

        @Override
        public void run() {
            this.saveCrash2sdcard();
            CrashCollector.this.mLock.lock();
            CrashCollector.this.mCondition.signalAll();
            CrashCollector.this.mLock.unlock();
        }

        private void saveCrash2sdcard() {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                this.ex.printStackTrace(pw);
                CrashCollector.this.mLogger.e(sw.getBuffer().toString(), new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

