/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.newlog.AndroidLogAdapter;
import com.fshows.android.stark.newlog.FsLog;
import com.fshows.android.stark.newlog.FsLogPrinter;
import com.fshows.android.stark.newlog.FsPrinter;

public class FsLogUtil {
    private static final FsPrinter PRINTER = new FsLogPrinter();
    private static final FsLog LOGGER;

    public static void trace(String pattern, Object ... arg) {
        LOGGER.v(pattern, arg);
    }

    public static void trace(String tag, String pattern, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.v(pattern, arg);
    }

    public static void debug(String pattern, Object ... arg) {
        LOGGER.d(pattern, arg);
    }

    public static void debug(String tag, String pattern, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.d(pattern, arg);
    }

    public static void info(String pattern, Object ... arg) {
        LOGGER.i(pattern, arg);
    }

    public static void info(String tag, String pattern, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.i(pattern, arg);
    }

    public static void warn(String pattern, Object ... arg) {
        LOGGER.w(pattern, arg);
    }

    public static void warn(String tag, String pattern, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.w(pattern, arg);
    }

    public static void error(String pattern, Object ... arg) {
        LOGGER.e(pattern, arg);
    }

    public static void error(String pattern, Throwable t, Object ... arg) {
        LOGGER.e(pattern, t, arg);
    }

    public static void error(String tag, String pattern, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.e(pattern, arg);
    }

    public static void error(String tag, String pattern, Throwable t, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.e(pattern, t, arg);
    }

    public static void fatal(String pattern, Object ... arg) {
        LOGGER.wtf(pattern, arg);
    }

    public static void fatal(String tag, String pattern, Object ... arg) {
        PRINTER.t(tag);
        LOGGER.wtf(pattern, arg);
    }

    static {
        PRINTER.addLogAdapter(new AndroidLogAdapter(){

            @Override
            public boolean isLoggable(int priority, String tag) {
                return FsFoundationInitializer.isDebug() || priority > 3;
            }
        });
        LOGGER = new FsLog(PRINTER);
    }
}

