/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.lang.reflect.Method;

public class InputMethodManagerUtil {
    public static void openSystemKeyBoard(Context mContext, View view) {
        InputMethodManager imm = (InputMethodManager)mContext.getSystemService("input_method");
        imm.showSoftInput(view, 2);
        imm.toggleSoftInput(2, 1);
    }

    public static void hideSystemKeyBoard(Context context, View v) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    public static void hideSystemSoftKeyboard(Context context, EditText editText) {
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Class<EditText> cls = EditText.class;
                Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
                setShowSoftInputOnFocus.setAccessible(true);
                setShowSoftInputOnFocus.invoke((Object)editText, false);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            editText.setInputType(0);
        }
        InputMethodManagerUtil.hideSystemKeyBoard(context, (View)editText);
    }
}

