/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.util.Log;
import com.annimon.stream.function.Supplier;
import com.fshows.android.stark.FsFoundationInitializer;
import com.google.common.base.Strings;

public class FsLogUtil {
    private static final int STACK_TRACE_INDEX = 5;
    private static final int TRACE = 0;
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 3;
    private static final int ERROR = 4;
    private static final int FATAL = 5;

    private static void log(int level, String tag, int index, String pattern, Object ... args) {
        if (level < 2 && !FsFoundationInitializer.isDebug()) {
            return;
        }
        if (level > 5) {
            level = 5;
        } else if (level < 0) {
            level = 0;
        }
        String message = FsLogUtil.formatEx(index, pattern, args);
        switch (level) {
            case 0: {
                Log.v((String)tag, (String)message);
                break;
            }
            case 2: {
                Log.i((String)tag, (String)message);
                break;
            }
            case 3: {
                Log.w((String)tag, (String)message);
                break;
            }
            case 4: {
                Log.e((String)tag, (String)message);
                break;
            }
            case 5: {
                Log.wtf((String)tag, (String)message);
                break;
            }
            default: {
                Log.d((String)tag, (String)message);
            }
        }
    }

    public static void trace(String tag, String pattern, Object ... arg) {
        FsLogUtil.log(0, tag, 5, pattern, arg);
    }

    public static void debug(String tag, String pattern, Object ... arg) {
        FsLogUtil.log(1, tag, 5, pattern, arg);
    }

    public static void info(String tag, String pattern, Object ... arg) {
        FsLogUtil.log(2, tag, 5, pattern, arg);
    }

    public static void warn(String tag, String pattern, Object ... arg) {
        FsLogUtil.log(3, tag, 5, pattern, arg);
    }

    public static void error(String tag, String pattern, Object ... arg) {
        FsLogUtil.log(4, tag, 5, pattern, arg);
    }

    public static void fatal(String tag, String pattern, Object ... arg) {
        FsLogUtil.log(5, tag, 5, pattern, arg);
    }

    private static String format(String pattern, Object ... args) {
        return (String)Supplier.Util.safe(() -> {
            String pattern1 = pattern.replace("{{}}", "$$BRACE$$").replace("{}", "%s").replace("$$BRACE$$", "{}");
            return Strings.lenientFormat((String)pattern1, (Object[])args);
        }, (Object)"").get();
    }

    private static String formatEx(int index, String pattern, Object ... args) {
        StackTraceElement stackTraceElement;
        if (FsFoundationInitializer.isDebug() && (stackTraceElement = Thread.currentThread().getStackTrace()[index]) != null) {
            return Strings.lenientFormat((String)"[TID:%s] - (%s:%s) ", (Object[])new Object[]{Thread.currentThread().getId(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()}) + FsLogUtil.format(pattern, args);
        }
        return FsLogUtil.format(pattern, args);
    }
}

