/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import com.google.common.base.Strings;
import java.util.regex.Pattern;

public class CommonRegex {
    private static final Pattern ALI_PAY_CODE_PATTERN = Pattern.compile("^(((2[5-9])|(30))\\d{14,22})$");
    private static final Pattern WX_PAY_CODE_PATTERN = Pattern.compile("^1\\d{17}$");
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^1\\d{10}$");

    public static boolean isMatch(String pattern, String content) {
        return Pattern.matches(pattern, content);
    }

    public static boolean isWechatCode(String qrCode) {
        if (Strings.isNullOrEmpty((String)qrCode)) {
            return false;
        }
        return WX_PAY_CODE_PATTERN.matcher(qrCode).matches();
    }

    public static boolean isAliPayCode(String qrCode) {
        if (Strings.isNullOrEmpty((String)qrCode)) {
            return false;
        }
        return ALI_PAY_CODE_PATTERN.matcher(qrCode).matches();
    }

    public static boolean isMobile(String mobile) {
        if (Strings.isNullOrEmpty((String)mobile)) {
            return false;
        }
        return MOBILE_PATTERN.matcher(mobile).matches();
    }
}

