/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.annimon.stream.function.Supplier;
import com.fshows.android.stark.FsFoundationInitializer;
import java.net.URLEncoder;

public class AppHelper {
    public static final String CHANNEL_NAME = "UMENG_CHANNEL";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    static String clientName;
    static Object clientNameLock;
    static String clientPackage;
    static Object clientPackageLock;
    static String clientVersion;
    static Object clientVersionLock;
    static int clientCode;
    static Object clientCodeLock;
    static String channel;
    static Object channelLock;
    static String project;
    static Object projectLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainClientName(Context context) {
        if (clientName == null) {
            Object object = clientNameLock;
            synchronized (object) {
                if (clientName == null) {
                    clientName = AppHelper.getClientName(context);
                }
            }
        }
        return clientName;
    }

    private static String getClientName(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pInfo = pm.getPackageInfo(context.getPackageName(), 0);
            String clientName = pm.getApplicationLabel(pInfo.applicationInfo).toString();
            return URLEncoder.encode(clientName.trim(), "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainClientPackage(Context context) {
        if (clientPackage == null) {
            Object object = clientPackageLock;
            synchronized (object) {
                if (clientPackage == null) {
                    clientPackage = context.getPackageName();
                }
            }
        }
        return clientPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainClientVersionName(Context context) {
        if (clientVersion == null) {
            Object object = clientVersionLock;
            synchronized (object) {
                if (clientVersion == null) {
                    clientVersion = AppHelper.getClientVersionName(context);
                }
            }
        }
        return clientVersion;
    }

    private static String getClientVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)AppHelper.obtainClientPackage((Context)context), (int)0).versionName;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int obtainClientVersionCode(Context context) {
        if (clientCode == -1) {
            Object object = clientCodeLock;
            synchronized (object) {
                if (clientCode == -1) {
                    clientCode = AppHelper.getClientVersionCode(context);
                }
            }
        }
        return clientCode;
    }

    private static int getClientVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)AppHelper.obtainClientPackage((Context)context), (int)0).versionCode;
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainChannel(Context context) {
        if (channel == null) {
            Object object = channelLock;
            synchronized (object) {
                if (channel == null) {
                    channel = AppHelper.getChannel(context);
                }
            }
        }
        return channel;
    }

    private static String getChannel(Context context) {
        return AppHelper.getMetaData(context, CHANNEL_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainProjectName(Context context) {
        if (project == null) {
            Object object = projectLock;
            synchronized (object) {
                if (project == null) {
                    project = AppHelper.getProjectName(context);
                }
            }
        }
        return project;
    }

    private static String getProjectName(Context context) {
        return AppHelper.getMetaData(context, PROJECT_NAME);
    }

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static String getMetaData(Context context, String metaDataKey) {
        return (String)Supplier.Util.safe(() -> {
            Bundle metaData = context.getPackageManager().getPackageInfo((String)AppHelper.getPackageName((Context)context), (int)128).applicationInfo.metaData;
            String value = "";
            if (metaData != null && metaData.containsKey(metaDataKey)) {
                value = String.valueOf(metaData.get(metaDataKey));
            }
            return value;
        }, (Object)"").get();
    }

    public static String getMetaData(String metaDataKey) {
        return AppHelper.getMetaData(FsFoundationInitializer.getApplicationContext(), metaDataKey);
    }

    static {
        clientNameLock = new Object();
        clientPackageLock = new Object();
        clientVersionLock = new Object();
        clientCode = -1;
        clientCodeLock = new Object();
        channelLock = new Object();
        projectLock = new Object();
    }
}

