/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.utils;

import com.fshows.android.stark.utils.FsLogUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import net.lingala.zip4j.core.NativeStorage;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class SovZipUtil {
    private static final String TAG = "SovZipUtil";

    public static void unzip(File zipFile, String dest, String password) throws ZipException {
        long start = System.currentTimeMillis();
        ZipFile zFile = new ZipFile(new NativeStorage(zipFile));
        if (!zFile.isValidZipFile()) {
            throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f");
        }
        File destDir = new File(dest);
        if (destDir.isDirectory() && !destDir.exists()) {
            destDir.mkdirs();
        }
        if (zFile.isEncrypted() && !Strings.isNullOrEmpty((String)password)) {
            zFile.setPassword(password.toCharArray());
        }
        zFile.extractAll(dest);
        FsLogUtil.debug((String)TAG, (String)"unzip spend {}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
    }

    public static void unzip(String zip, String dest, String password) throws ZipException {
        File zipFile = new File(zip);
        SovZipUtil.unzip(zipFile, dest, password);
    }

    public static void unzip(String zip, String dest) throws ZipException {
        SovZipUtil.unzip(new File(zip), dest, null);
    }

    public static void unzip(File zipFile, String dest) throws ZipException {
        SovZipUtil.unzip(zipFile, dest, null);
    }

    public static String zip(String src, String dest, boolean isCreateDir, String passwd) {
        File srcFile = new File(src);
        dest = SovZipUtil.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!Strings.isNullOrEmpty((String)passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = Lists.newArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return dest;
                }
                zipFile.addFolder(new NativeStorage(srcFile), parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        String substring = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
        if (Strings.isNullOrEmpty((String)destParam)) {
            destParam = srcFile.isDirectory() ? srcFile.getParent() + File.separator + srcFile.getName() + ".zip" : srcFile.getParent() + File.separator + substring + ".zip";
        } else {
            SovZipUtil.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = srcFile.isDirectory() ? srcFile.getName() : substring;
                destParam = destParam + fileName + ".zip";
            }
        }
        return destParam;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }
}

