/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.utils;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import com.annimon.stream.Optional;
import com.fshows.android.stark.utils.FsLogUtil;
import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import java.io.File;

@Deprecated
public class FileProviderUtil {
    private static final String TAG = "FileProviderUtil";

    public static Uri getUriFromFile(Context context, String authority, File file) {
        Uri uri = null;
        try {
            uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)file) : Uri.fromFile((File)file);
        }
        catch (Exception e) {
            FsLogUtil.error((String)TAG, (String)"getUriFromFile failed, {}", (Object[])new Object[]{e.getMessage()});
        }
        return uri;
    }

    public static Uri getUriFromFilePath(Context context, String authority, String path) {
        return FileProviderUtil.getUriFromFile(context, authority, new File(path));
    }

    public static void grantPermissions(Intent intent, boolean grantReadPermission, boolean grantWritePermission) {
        if (Build.VERSION.SDK_INT >= 24) {
            if (grantReadPermission) {
                intent.addFlags(1);
            }
            if (grantWritePermission) {
                intent.addFlags(2);
            }
        }
    }

    public static void convertUriForMIUI(Context context, Intent intent, Uri uri) {
        if (uri.toString().contains("com.miui.gallery.open")) {
            Uri temp = FileProviderUtil.getImageContentUri(context, new File(FileProviderUtil.getRealFilePathFromUri(context, uri)));
            intent.setDataAndType(temp, "image/*");
        }
    }

    @Beta
    private static String getRealFilePathFromUri(Context context, Uri uri) {
        Cursor cursor;
        if (Optional.ofNullable((Object)uri).isEmpty()) {
            return null;
        }
        String scheme = uri.getScheme();
        String filePath = null;
        if (Strings.isNullOrEmpty((String)scheme)) {
            filePath = uri.getPath();
        } else if ("file".equals(scheme)) {
            filePath = uri.getPath();
        } else if ("content".equals(scheme) && (cursor = context.getContentResolver().query(uri, null, null, null, null)) != null) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                filePath = cursor.getString(index);
            }
            cursor.close();
        }
        return filePath;
    }

    private static Uri getImageContentUri(Context context, File imageFile) {
        Uri result;
        String filePath = imageFile.getAbsolutePath();
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/images/media");
            result = Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
        } else if (imageFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            result = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        } else {
            result = null;
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }
}

