/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.modules.hotpatch.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.annimon.stream.Optional;
import com.annimon.stream.Stream;
import com.fshows.android.sovereign.modules.hotpatch.BundlePatchConfig;
import com.fshows.android.sovereign.modules.hotpatch.bean.UpdateManifestModel;
import com.fshows.android.stark.exception.FsException;
import com.fshows.android.stark.utils.FsLogUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.adapter.CallAdapter;
import com.lzy.okgo.convert.Converter;
import com.lzy.okgo.convert.FileConvert;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okrx2.adapter.ObservableBody;
import io.reactivex.Observable;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Iterator;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SovRequestHelper {
    private static final String TAG = "SovRequestHelper";
    private BundlePatchConfig bundlePatchConfig;

    public SovRequestHelper(BundlePatchConfig bundlePatchConfig) {
        this.bundlePatchConfig = (BundlePatchConfig)Optional.ofNullable((Object)bundlePatchConfig).orElseGet(BundlePatchConfig::getDefaultConfig);
    }

    private String getUpdateManifestUrl() {
        String apiHost = this.bundlePatchConfig.getApiHost();
        String codeName = this.bundlePatchConfig.getCodeName();
        String version = this.bundlePatchConfig.getVersion();
        StringBuilder sb = new StringBuilder();
        Iterator data = Stream.of((Object[])new String[]{apiHost, codeName, version, "android_portal_manifest.json"}).filter(p -> !Strings.isNullOrEmpty((String)p)).iterator();
        Joiner.on((String)"/").skipNulls().appendTo(sb, data);
        return sb.toString();
    }

    public Observable<File> downloadFile(String url, String folder, String fileName) {
        FileConvert converter = new FileConvert(folder, fileName);
        return (Observable)((GetRequest)OkGo.get((String)url).converter((Converter)converter)).adapt((CallAdapter)new ObservableBody());
    }

    public Observable<UpdateManifestModel> requestUpdateManifest() {
        String url = this.getUpdateManifestUrl();
        FsLogUtil.debug((String)TAG, (String)"UpdateManifest URL: {}", (Object[])new Object[]{url});
        return (Observable)((GetRequest)((GetRequest)OkGo.get((String)url).params("v", System.currentTimeMillis(), new boolean[]{true})).converter(new JsonConverter<UpdateManifestModel>(UpdateManifestModel.class))).adapt((CallAdapter)new ObservableBody());
    }

    public static class JsonConverter<T>
    implements Converter<T> {
        private Class<T> clazz;
        private Type type;

        JsonConverter(Class<T> clazz) {
            this.clazz = clazz;
        }

        JsonConverter(Type type) {
            this.type = type;
        }

        public T convertResponse(Response response) throws Throwable {
            ResponseBody body = response.body();
            if (body == null) {
                throw new FsException("\u63a5\u53e3\u6570\u636e\u8fd4\u56de\u5f02\u5e38");
            }
            String bodyContent = body.string();
            FsLogUtil.debug((String)SovRequestHelper.TAG, (String)"response -> {}", (Object[])new Object[]{bodyContent});
            Object entity = null;
            try {
                if (this.clazz != null) {
                    entity = JSON.parseObject((String)bodyContent, this.clazz);
                } else if (this.type != null) {
                    entity = JSON.parseObject((String)bodyContent, (Type)this.type, (Feature[])new Feature[0]);
                }
            }
            catch (Exception e) {
                throw new FsException("JSON\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u539f\u59cbcontent: {}", new Object[]{bodyContent});
            }
            return (T)entity;
        }
    }
}

