/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.modules.hotpatch.bundle;

import com.alibaba.fastjson.JSON;
import com.fshows.android.sovereign.modules.hotpatch.bean.ResourceBundleManifestModel;
import com.fshows.android.sovereign.modules.hotpatch.bundle.IResourceBundle;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.MD5Util;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;

public class AbsResourceBundle
implements IResourceBundle {
    private static final String TAG = "AbsResourceBundle";
    private ResourceBundleManifestModel resourceBundleManifestModel = null;
    private File bundleLocation = null;

    protected AbsResourceBundle(File bundleLocation) {
        if (bundleLocation.isDirectory() && bundleLocation.exists()) {
            this.bundleLocation = bundleLocation;
            this.init();
        } else {
            bundleLocation.mkdirs();
        }
    }

    private void init() {
        File file = new File(this.bundleLocation, this.getBundleManifestFileName());
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            this.resourceBundleManifestModel = (ResourceBundleManifestModel)JSON.parseObject((String)sb.toString(), ResourceBundleManifestModel.class);
        }
        catch (Exception e) {
            FsLogUtil.error((String)TAG, (String)"validate bundle failed, {}", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    public File getBundleLocation() {
        return this.bundleLocation;
    }

    @Override
    public String getBundleManifestChecksum() {
        File bundle = new File(this.getBundleLocation(), this.getBundleManifestFileName());
        return Strings.nullToEmpty((String)MD5Util.getFileMD5((File)bundle));
    }

    @Override
    public boolean validateBundle() {
        if (this.resourceBundleManifestModel == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        for (Map.Entry<String, String> entry : this.resourceBundleManifestModel.checksum.entrySet()) {
            File f = new File(this.getBundleLocation(), entry.getKey());
            if (f.isFile() && f.exists()) {
                String md5 = MD5Util.getFileMD5((File)f);
                if (!Strings.isNullOrEmpty((String)md5) && md5.equalsIgnoreCase(entry.getValue())) continue;
                FsLogUtil.warn((String)TAG, (String)"mismatch checksum {}: {}", (Object[])new Object[]{md5, f});
                return false;
            }
            FsLogUtil.warn((String)TAG, (String)"file is not file or not exist {}", (Object[])new Object[]{f});
            return false;
        }
        FsLogUtil.info((String)TAG, (String)"validate bundle OK. {}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        return true;
    }

    @Override
    public String getBundleEntry() {
        if (this.resourceBundleManifestModel != null && !Strings.isNullOrEmpty((String)this.resourceBundleManifestModel.entry)) {
            return this.resourceBundleManifestModel.entry;
        }
        switch (this.getBundleType().toLowerCase()) {
            default: 
        }
        String entry = "index.html";
        return entry;
    }

    @Override
    public ResourceBundleManifestModel getResourceBundleManifestModel() {
        return this.resourceBundleManifestModel;
    }

    @Override
    public boolean isBundleManifestExisted() {
        return this.resourceBundleManifestModel != null;
    }

    @Override
    public void reload() {
        this.init();
    }
}

