/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.modules.hotpatch;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.annimon.stream.Optional;
import com.annimon.stream.function.Supplier;
import com.fshows.android.foundation.gears.FsPatcher;
import com.fshows.android.sovereign.modules.hotpatch.BundlePatchConfig;
import com.fshows.android.sovereign.modules.hotpatch.IResourceBundleStateChangeCallback;
import com.fshows.android.sovereign.modules.hotpatch.bean.ResourceBundleManifestModel;
import com.fshows.android.sovereign.modules.hotpatch.bean.UpdateManifestModel;
import com.fshows.android.sovereign.modules.hotpatch.bundle.AbsBundleArchive;
import com.fshows.android.sovereign.modules.hotpatch.bundle.IResourceBundle;
import com.fshows.android.sovereign.modules.hotpatch.bundle.impl.H5BundleArchive;
import com.fshows.android.sovereign.modules.hotpatch.bundle.impl.H5ResourceBundle;
import com.fshows.android.sovereign.modules.hotpatch.http.SovRequestHelper;
import com.fshows.android.sovereign.utils.SovSharedPreferenceUtil;
import com.fshows.android.sovereign.utils.SovZipUtil;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.FsXandarConfiguration;
import com.fshows.android.stark.exception.FsException;
import com.fshows.android.stark.utils.FileUtil;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.MD5Util;
import com.fshows.android.stark.utils.UiHandlerUtil;
import com.fshows.android.stark.utils.VersionUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.lingala.zip4j.exception.ZipException;

public class ResourceBundleUpdater
implements Closeable {
    private static final String TAG = "ResourceBundleUpdater";
    private Context context;
    private BundlePatchConfig bundlePatchConfig;
    private UpdateManifestModel updateManifestModel;
    private IResourceBundle resourceBundle;
    private static final String SP_KEY_PORTAL_BENCHMARK = "portal-benchmark";
    private static final String SP_KEY_PORTAL_BENCHMARK_CHECKSUM = "portal-benchmark-checksum";
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private IResourceBundleStateChangeCallback resourceBundleCallback;
    private AtomicReference<String> bundleManifestChecksum = new AtomicReference();
    private AtomicLong lastUpgradeCheckTime = new AtomicLong(Long.MIN_VALUE);
    private SovRequestHelper sovRequestHelper;

    public ResourceBundleUpdater(Context context) {
        this.context = context;
        this.bundlePatchConfig = BundlePatchConfig.getDefaultConfig();
        this.sovRequestHelper = new SovRequestHelper(this.bundlePatchConfig);
    }

    public ResourceBundleUpdater(Context context, BundlePatchConfig config) {
        this.context = context;
        this.bundlePatchConfig = FsFoundationInitializer.isDebug() ? config : BundlePatchConfig.getDefaultConfig();
        this.sovRequestHelper = new SovRequestHelper(config);
    }

    public void setResourceBundleCallback(IResourceBundleStateChangeCallback callback) {
        this.resourceBundleCallback = callback;
    }

    public void setBundlePatchConfig(BundlePatchConfig config) {
        if (FsFoundationInitializer.isDebug()) {
            this.bundlePatchConfig = config;
        }
    }

    private void raiseBundleStateChangedEvent(boolean isUpdated) {
        String lastChecksum;
        FsLogUtil.info((String)TAG, (String)"raiseBundleStateChangedEvent: {}", (Object[])new Object[]{isUpdated});
        String prevChecksum = this.bundleManifestChecksum.get();
        if (this.resourceBundle != null && this.resourceBundle.isBundleManifestExisted() && !Strings.isNullOrEmpty((String)(lastChecksum = this.resourceBundle.getBundleManifestChecksum())) && !lastChecksum.equalsIgnoreCase(prevChecksum)) {
            FsLogUtil.debug((String)TAG, (String)"{} vs {}", (Object[])new Object[]{prevChecksum, lastChecksum});
            if (this.resourceBundleCallback != null) {
                UiHandlerUtil.runOnUiThread(() -> {
                    if (isUpdated) {
                        this.resourceBundleCallback.onBundleUpdated(this.resourceBundle.getBundleEntryFile());
                    } else {
                        this.resourceBundleCallback.onBundleInitialized(this.resourceBundle.getBundleEntryFile());
                    }
                });
            }
            this.bundleManifestChecksum.set(lastChecksum);
        }
    }

    private void raiseBundlePreUpdateEvent() {
        FsLogUtil.info((String)TAG, (String)"raiseBundlePreUpdateEvent", (Object[])new Object[0]);
        Optional.ofNullable((Object)this.resourceBundleCallback).executeIfPresent(p -> UiHandlerUtil.runOnUiThread(p::onBundlePreUpdate));
    }

    private boolean wfCheckAssetsBundle() {
        boolean ret = true;
        try {
            FsLogUtil.info((String)TAG, (String)"wfCheckAssetsBundle..", (Object[])new Object[0]);
            this.initLocation();
            this.resourceBundle.reload();
            byte[] data = FileUtil.assetsFileToBytes((Context)this.context, (File)new File("portal.manifest"));
            ResourceBundleManifestModel assetManifest = (ResourceBundleManifestModel)JSON.parseObject((byte[])data, ResourceBundleManifestModel.class, (Feature[])new Feature[0]);
            if (this.resourceBundle.isBundleManifestExisted()) {
                if (assetManifest != null) {
                    if (VersionUtil.compareVersions((String)this.resourceBundle.getResourceBundleManifestModel().version, (String)assetManifest.version) == -1) {
                        FsLogUtil.info((String)TAG, (String)"Resource bundle version:{} is older than assets bundleVersion:{}..", (Object[])new Object[]{this.resourceBundle.getResourceBundleManifestModel().version, assetManifest.version});
                        this.initBundle();
                    } else {
                        FsLogUtil.info((String)TAG, (String)"Resource bundle version:{}", (Object[])new Object[]{this.resourceBundle.getResourceBundleManifestModel().version});
                    }
                }
            } else {
                FsLogUtil.info((String)TAG, (String)"Resource bundle is not existed, init resource bundle", (Object[])new Object[0]);
                this.initBundle();
            }
        }
        catch (Exception e) {
            FsLogUtil.warn((String)TAG, (String)"wfCheckAssetsBundle FAILED, {}", (Object[])new Object[]{e.toString()});
            ret = false;
        }
        return ret;
    }

    private void initLocation() {
        try {
            File portalLoc = this.getPortalLocation();
            File cacheLoc = this.getPortalCacheLocation();
            FsLogUtil.debug((String)TAG, (String)"portal location:{}", (Object[])new Object[]{portalLoc});
            FsLogUtil.debug((String)TAG, (String)"cache location:{}", (Object[])new Object[]{cacheLoc});
            this.resourceBundle = (IResourceBundle)Optional.ofNullable((Object)this.resourceBundle).orElseGet(() -> new H5ResourceBundle(portalLoc));
        }
        catch (Exception e) {
            FsLogUtil.error((String)TAG, (String)"init folders failed: {}", (Object[])new Object[]{e, this.toString()});
        }
    }

    public synchronized void upgradeBundle() {
        long configuredCheckInterval;
        long now = System.currentTimeMillis();
        long interval = now - this.lastUpgradeCheckTime.get();
        if (interval >= (configuredCheckInterval = TimeUnit.SECONDS.toMicros(FsXandarConfiguration.instance.getUpgradeCheckInterval()))) {
            FsLogUtil.info((String)TAG, (String)"check interval: {} < {}, skip", (Object[])new Object[]{interval, configuredCheckInterval});
            return;
        }
        this.lastUpgradeCheckTime.set(now);
        this.compositeDisposable.clear();
        this.initLocation();
        Disposable disposable = Observable.fromCallable(this::wfCheckAssetsBundle).subscribeOn(Schedulers.io()).flatMap(obj -> this.wfCheckUpdate()).subscribeOn(Schedulers.io()).flatMap(needUpdate -> {
            if (needUpdate.booleanValue()) {
                FsLogUtil.debug((String)TAG, (String)"Bundle package need update, execute wfUpdate()", (Object[])new Object[0]);
                Optional.ofNullable((Object)this.resourceBundleCallback).executeIfPresent(p -> UiHandlerUtil.runOnUiThread(() -> p.onBundleNeedUpdate(this.updateManifestModel)));
                return this.wfUpdate().flatMap(file -> Observable.just((Object)this.resourceBundle.getBundleEntryFile()));
            }
            FsLogUtil.debug((String)TAG, (String)"Bundle package no need update", (Object[])new Object[0]);
            return Observable.just((Object)this.resourceBundle.getBundleEntryFile());
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).doFinally(() -> {
            FsLogUtil.info((String)TAG, (String)"hotPatch check done.", (Object[])new Object[0]);
            Optional.ofNullable((Object)this.resourceBundleCallback).executeIfPresent(p -> UiHandlerUtil.runOnUiThread(p::onBundleCheckFinished));
        }).subscribe(file -> this.raiseBundleStateChangedEvent(true), throwable -> {
            Optional.ofNullable((Object)this.resourceBundleCallback).executeIfPresent(p -> UiHandlerUtil.runOnUiThread(() -> p.onBundleUpdateFailed(this.updateManifestModel, (Throwable)throwable)));
            FsLogUtil.error((String)TAG, (String)"upgrade bundle error:{}", (Object[])new Object[]{throwable.toString()});
        });
        this.compositeDisposable.add(disposable);
    }

    private Observable<File> wfUpdate() throws FsException {
        return this.wfDownload().doOnSubscribe(d -> this.raiseBundlePreUpdateEvent()).flatMap(file -> {
            FsLogUtil.debug((String)TAG, (String)"unzip archive:{} TO => {}", (Object[])new Object[]{file.toString(), this.getPortalLocation().toString()});
            new H5BundleArchive((File)file).unarchive(this.getPortalLocation());
            SovSharedPreferenceUtil.putString(this.context, SP_KEY_PORTAL_BENCHMARK, file.toString());
            SovSharedPreferenceUtil.putString(this.context, SP_KEY_PORTAL_BENCHMARK_CHECKSUM, Strings.nullToEmpty((String)((UpdateManifestModel)Optional.ofNullable((Object)this.updateManifestModel).orElse((Object)UpdateManifestModel.NIL)).bundleArchiveChecksum));
            this.resourceBundle.reload();
            FsLogUtil.debug((String)TAG, (String)"Bundle Entry => {}", (Object[])new Object[]{this.resourceBundle.getBundleEntry()});
            return Observable.just((Object)file);
        });
    }

    private Observable<Boolean> wfCheckUpdate() {
        FsLogUtil.debug((String)TAG, (String)"workflow => CheckUpdate...", (Object[])new Object[0]);
        if (!this.resourceBundle.isBundleManifestExisted()) {
            try {
                this.initBundle();
                FsLogUtil.debug((String)TAG, (String)"reload resource Bundle!", (Object[])new Object[0]);
                this.resourceBundle.reload();
            }
            catch (Exception e) {
                FsLogUtil.warn((String)TAG, (String)"initBundle failed, {}", (Object[])new Object[]{e.toString()});
            }
        }
        String bundleManifestChecksum = this.resourceBundle.getBundleManifestChecksum();
        FsLogUtil.debug((String)TAG, (String)"Bundle manifest checksum:", (Object[])new Object[]{bundleManifestChecksum});
        FsLogUtil.debug((String)TAG, (String)"request bundle UpdateManifest!!", (Object[])new Object[0]);
        Observable ob = this.sovRequestHelper.requestUpdateManifest().subscribeOn(Schedulers.io()).doOnError(throwable -> FsLogUtil.error((String)TAG, (String)"{}", (Object[])new Object[]{Joiner.on((String)"\n").join((Object[])throwable.getStackTrace())})).onErrorReturnItem((Object)UpdateManifestModel.NIL).doOnNext(data -> {
            this.updateManifestModel = data;
        });
        return ob.flatMap(data -> {
            FsLogUtil.debug((String)TAG, (String)"api.getUpdateManifest is successed", (Object[])new Object[0]);
            return Observable.just((Object)this.checkNeedUpdate((UpdateManifestModel)data, bundleManifestChecksum));
        });
    }

    public void clearBundleFolder() {
        File dir = this.getPortalLocation();
        FsLogUtil.debug((String)TAG, (String)"clearBundleFolder: {}", (Object[])new Object[]{dir.toString()});
        FileUtil.deleteDir((File)dir, (boolean)false);
        this.bundleManifestChecksum.set(null);
        FsLogUtil.info((String)TAG, (String)"clearBundleFolder: {} finished.", (Object[])new Object[]{dir.toString()});
    }

    public void clearDownloadCacheFolder() {
        File dir = this.getPortalCacheLocation();
        FsLogUtil.debug((String)TAG, (String)"clearDownloadCacheFolder: {}", (Object[])new Object[]{dir.toString()});
        FileUtil.deleteDir((File)dir, (boolean)false);
        FsLogUtil.info((String)TAG, (String)"clearDownloadCacheFolder: {} finished.", (Object[])new Object[]{dir.toString()});
    }

    private boolean checkNeedUpdate(UpdateManifestModel model, String checksum) {
        FsLogUtil.debug((String)TAG, (String)"checkNeedUpdate..", (Object[])new Object[]{model, checksum});
        model = (UpdateManifestModel)Optional.ofNullable((Object)model).orElse((Object)UpdateManifestModel.NIL);
        String expectedChecksum = model.bundleManifestChecksum;
        boolean ret = false;
        if (Strings.isNullOrEmpty((String)expectedChecksum)) {
            if (!this.resourceBundle.validateBundle()) {
                try {
                    this.initBundle();
                }
                catch (Exception e) {
                    FsLogUtil.warn((String)TAG, (String)"{}", (Object[])new Object[]{e.toString()});
                }
            } else {
                FsLogUtil.info((String)TAG, (String)"bundle is validated..", (Object[])new Object[0]);
            }
            this.raiseBundleStateChangedEvent(false);
        } else {
            boolean bl = ret = Strings.isNullOrEmpty((String)checksum) || !checksum.equalsIgnoreCase(expectedChecksum);
            if (!ret) {
                boolean bl2 = ret = !this.resourceBundle.validateBundle();
                if (!ret) {
                    FsLogUtil.debug((String)TAG, (String)"manifest OK, resource bundle validated! ", (Object[])new Object[0]);
                    this.raiseBundleStateChangedEvent(false);
                }
            } else if (this.resourceBundle.validateBundle()) {
                FsLogUtil.debug((String)TAG, (String)"manifest checksum mismatch, resource bundle validated! ", (Object[])new Object[0]);
                this.raiseBundleStateChangedEvent(false);
            }
        }
        FsLogUtil.info((String)TAG, (String)"checkNeedUpdate = {}", (Object[])new Object[]{ret});
        return ret;
    }

    private Observable<File> wfDownload() throws FsException {
        FsLogUtil.debug((String)TAG, (String)"workflow => wfDownload..", (Object[])new Object[0]);
        if (this.updateManifestModel == null) {
            throw new FsException("\u66f4\u65b0\u6e05\u5355\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u5c06\u4e0d\u8fdb\u884c\u4e0b\u8f7d\u6587\u4ef6\u64cd\u4f5c");
        }
        File benchmark = (File)Supplier.Util.safe(this::getBenchmark, (Object)new File(this.getPortalCacheLocation(), "portal.zip")).get();
        H5BundleArchive bundleArchive = new H5BundleArchive(benchmark);
        String checksum = bundleArchive.getChecksum();
        if (Strings.isNullOrEmpty((String)checksum)) {
            return this.wfDownloadEntireUrl(bundleArchive, checksum);
        }
        return this.wfDownloadPatch(bundleArchive, checksum).onErrorResumeNext(throwable -> {
            FsLogUtil.warn((String)TAG, (String)"wfDownloadPatch failed: {}", (Object[])new Object[]{throwable.toString()});
            return this.wfDownloadEntireUrl(bundleArchive, checksum);
        });
    }

    private Observable<File> wfDownloadEntireUrl(H5BundleArchive bundleArchive, String checksum) {
        FsLogUtil.debug((String)TAG, (String)"workflow => wfDownloadEntireUrl", (Object[])new Object[0]);
        String entireBundleUrl = ResourceBundleUpdater.getEntireBundleUrl(this.updateManifestModel);
        if (Strings.isNullOrEmpty((String)checksum)) {
            FsLogUtil.info((String)TAG, (String)"spark is not existed, download entire:{}", (Object[])new Object[]{entireBundleUrl});
        } else {
            FsLogUtil.info((String)TAG, (String)"download entire:{}", (Object[])new Object[]{entireBundleUrl});
        }
        String archiveLocation = bundleArchive.getArchiveLocation().toString();
        String archiveFileName = bundleArchive.getArchiveFileName();
        FsLogUtil.debug((String)TAG, (String)"archive location:{}, fileName:{}", (Object[])new Object[]{archiveLocation, archiveFileName});
        Observable ob = this.sovRequestHelper.downloadFile(entireBundleUrl, archiveLocation, archiveFileName).subscribeOn(Schedulers.io());
        return ob.flatMap(file -> {
            if (file != null) {
                String md5 = MD5Util.getFileMD5((File)file);
                FsLogUtil.debug((String)TAG, (String)"md5 ACTUAL:{} EXPECTED:{}", (Object[])new Object[]{md5, this.updateManifestModel.bundleArchiveChecksum});
                if (md5.equalsIgnoreCase(this.updateManifestModel.bundleArchiveChecksum)) {
                    return Observable.just((Object)file);
                }
            }
            return Observable.just((Object)FileUtil.INVALID_FILE);
        });
    }

    private Observable<File> wfDownloadPatch(H5BundleArchive bundleArchive, String checksum) {
        FsLogUtil.debug((String)TAG, (String)"workflow => wfDownloadPatch..", (Object[])new Object[0]);
        String patchUrl = ResourceBundleUpdater.getPatchUrl(this.updateManifestModel, checksum);
        FsLogUtil.info((String)TAG, (String)"spark is existed, download patch:{}", (Object[])new Object[]{patchUrl});
        String patchFolder = bundleArchive.getArchiveLocation().toString();
        String patchFileName = checksum + ".patch";
        Observable ob = this.sovRequestHelper.downloadFile(patchUrl, patchFolder, patchFileName).subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
        return ob.flatMap(patchFile -> {
            File f = this.patchFile(bundleArchive, (File)patchFile);
            String md5 = MD5Util.getFileMD5((File)f);
            FsLogUtil.debug((String)TAG, (String)"md5 ACTUAL:{} EXPECTED:{}", (Object[])new Object[]{md5, this.updateManifestModel.bundleArchiveChecksum});
            if (md5.equalsIgnoreCase(this.updateManifestModel.bundleArchiveChecksum)) {
                return Observable.just((Object)f);
            }
            throw new FsException("patch failed");
        }).subscribeOn(Schedulers.io());
    }

    private File patchFile(AbsBundleArchive bundleArchive, File patchFile) {
        File f = new File(this.getPortalCacheLocation(), "portal-patched.zip");
        long beginTime = System.currentTimeMillis();
        int ret = FsPatcher.patch((File)bundleArchive.getArchiveFile(), (File)patchFile, (File)f);
        FsLogUtil.debug((String)TAG, (String)"patch time => {} ms", (Object[])new Object[]{System.currentTimeMillis() - beginTime});
        FsLogUtil.info((String)TAG, (String)"starting patch => {} result:{}", (Object[])new Object[]{f.toString(), ret});
        if (ret == 0 && MD5Util.getFileMD5((File)f).equalsIgnoreCase(this.updateManifestModel.bundleArchiveChecksum)) {
            bundleArchive.getArchiveFile().delete();
            patchFile.delete();
            return f;
        }
        return FileUtil.INVALID_FILE;
    }

    private static String getEntireBundleUrl(UpdateManifestModel model) {
        if (model == null || Strings.isNullOrEmpty((String)model.entireBundleURL)) {
            return "";
        }
        return model.entireBundleURL;
    }

    private static String getPatchUrl(UpdateManifestModel model, String checksum) {
        if (model == null || Strings.isNullOrEmpty((String)model.patchRootURL)) {
            return "";
        }
        String patchUrl = Joiner.on((String)"/").join((Object)model.patchRootURL, (Object)(checksum + ".patch"), new Object[0]);
        FsLogUtil.debug((String)TAG, (String)"patch URL=> {}", (Object[])new Object[]{patchUrl});
        return patchUrl;
    }

    private void initBundle() throws FsException {
        try {
            FsLogUtil.info((String)TAG, (String)"init Resource Bundle..", (Object[])new Object[0]);
            File f = this.getBenchmark();
            FsLogUtil.debug((String)TAG, (String)"file has copied: {}", (Object[])new Object[]{f.toString()});
            FsLogUtil.debug((String)TAG, (String)"unpack bundle archive to: {}", (Object[])new Object[]{this.getPortalLocation().toString()});
            SovZipUtil.unzip(f, this.getPortalLocation().toString());
            FsLogUtil.info((String)TAG, (String)"reset bundle.. done!", (Object[])new Object[0]);
            this.resourceBundle.reload();
            this.raiseBundleStateChangedEvent(false);
        }
        catch (ZipException e) {
            throw new FsException((Exception)((Object)e));
        }
    }

    private File getBenchmark() throws FsException {
        String benchmark = SovSharedPreferenceUtil.getString(this.context, SP_KEY_PORTAL_BENCHMARK, "");
        String benchmarkChecksum = SovSharedPreferenceUtil.getString(this.context, SP_KEY_PORTAL_BENCHMARK_CHECKSUM, "");
        File fBenchmark = new File(benchmark);
        String benchmarkChecksumActual = MD5Util.getFileMD5((File)fBenchmark);
        if (!Strings.isNullOrEmpty((String)benchmarkChecksumActual) && benchmarkChecksumActual.equalsIgnoreCase(benchmarkChecksum)) {
            return fBenchmark;
        }
        File f = FileUtil.copyFileFromAssets((Context)this.context, (String)"portal.zip", (String)this.getPortalCacheLocation().toString());
        FsLogUtil.debug((String)TAG, (String)"assets file has copied to: {}", (Object[])new Object[]{f.toString()});
        String checksum = MD5Util.getFileMD5((File)f);
        SovSharedPreferenceUtil.putString(this.context, SP_KEY_PORTAL_BENCHMARK_CHECKSUM, checksum);
        SovSharedPreferenceUtil.putString(this.context, SP_KEY_PORTAL_BENCHMARK, f.toString());
        return f;
    }

    private File getPortalLocation() {
        return this.context.getApplicationContext().getDir("portal", 0);
    }

    private File getPortalCacheLocation() {
        File cache = this.context.getApplicationContext().getCacheDir();
        File portalCache = new File(cache, "cache_portal");
        if (!portalCache.exists()) {
            portalCache.mkdirs();
        } else if (portalCache.isFile()) {
            portalCache.delete();
            portalCache.mkdirs();
        }
        return portalCache;
    }

    @Override
    public void close() {
        this.compositeDisposable.dispose();
    }
}

