/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.session;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.AwcnConfig;
import anet.channel.Config;
import anet.channel.DataFrameCb;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.IAuth;
import anet.channel.RequestCb;
import anet.channel.Session;
import anet.channel.SessionInfo;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.bytes.ByteArray;
import anet.channel.bytes.a;
import anet.channel.entity.b;
import anet.channel.heartbeat.HeartbeatManager;
import anet.channel.heartbeat.IHeartbeat;
import anet.channel.request.Cancelable;
import anet.channel.request.Request;
import anet.channel.request.c;
import anet.channel.security.ISecurity;
import anet.channel.session.h;
import anet.channel.session.i;
import anet.channel.session.j;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.statist.RequestStatistic;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.ConnEvent;
import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.StrategyCenter;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import anet.channel.util.HttpHelper;
import anet.channel.util.Utils;
import anet.channel.util.d;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.android.spdy.RequestPriority;
import org.android.spdy.SessionCb;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdyByteArray;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;
import org.json.JSONException;
import org.json.JSONObject;

public class TnetSpdySession
extends Session
implements SessionCb {
    protected SpdyAgent w;
    protected SpdySession x;
    protected volatile boolean y = false;
    protected long z;
    protected long A = 0L;
    private int H = 0;
    protected int B = -1;
    protected DataFrameCb C = null;
    protected IHeartbeat D = null;
    protected IAuth E = null;
    protected String F = null;
    protected ISecurity G = null;

    public TnetSpdySession(Context context, anet.channel.entity.a a2) {
        super(context, a2);
    }

    public void initConfig(Config config) {
        if (config != null) {
            this.F = config.getAppkey();
            this.G = config.getSecurity();
        }
    }

    public void initSessionInfo(SessionInfo sessionInfo) {
        if (sessionInfo != null) {
            this.C = sessionInfo.dataFrameCb;
            this.E = sessionInfo.auth;
            if (sessionInfo.isKeepAlive) {
                this.q.isKL = 1L;
                this.t = true;
                this.D = sessionInfo.heartbeat;
                if (this.D == null) {
                    this.D = HeartbeatManager.getDefaultHeartbeat();
                }
            }
        }
        if (AwcnConfig.isIdleSessionCloseEnable() && this.D == null) {
            this.D = new anet.channel.heartbeat.b();
        }
    }

    public void setTnetPublicKey(int n2) {
        this.B = n2;
    }

    @Override
    public Cancelable request(Request request, RequestCb requestCb) {
        c c2 = anet.channel.request.c.NULL;
        RequestStatistic requestStatistic = request != null ? request.a : new RequestStatistic(this.d, null);
        requestStatistic.setConnType(this.j);
        if (requestStatistic.start == 0L) {
            requestStatistic.start = requestStatistic.reqStart = System.currentTimeMillis();
        }
        requestStatistic.setIPAndPort(this.f, this.g);
        requestStatistic.ipRefer = this.k.getIpSource();
        requestStatistic.ipType = this.k.getIpType();
        requestStatistic.unit = this.l;
        if (request == null || requestCb == null) {
            if (requestCb != null) {
                requestCb.onFinish(-102, ErrorConstant.getErrMsg(-102), requestStatistic);
            }
            return c2;
        }
        try {
            if (this.x != null && (this.n == 0 || this.n == 4)) {
                Object object;
                if (this.m) {
                    request.setDnsOptimize(this.e, this.g);
                }
                request.setUrlScheme(this.j.isSSL());
                Object object2 = request.getUrl();
                if (ALog.isPrintLog(2)) {
                    ALog.i("awcn.TnetSpdySession", "", request.getSeq(), "request URL", ((URL)object2).toString());
                    ALog.i("awcn.TnetSpdySession", "", request.getSeq(), "request Method", request.getMethod());
                    ALog.i("awcn.TnetSpdySession", "", request.getSeq(), "request headers", request.getHeaders());
                }
                object2 = TextUtils.isEmpty((CharSequence)this.h) || this.i <= 0 ? new SpdyRequest((URL)object2, request.getMethod(), RequestPriority.DEFAULT_PRIORITY, -1, request.getConnectTimeout()) : new SpdyRequest((URL)object2, ((URL)object2).getHost(), ((URL)object2).getPort(), this.h, this.i, request.getMethod(), RequestPriority.DEFAULT_PRIORITY, -1, request.getConnectTimeout(), 0);
                ((SpdyRequest)object2).setRequestRdTimeoutMs(request.getReadTimeout());
                Object object3 = request.getHeaders();
                if (!object3.containsKey("Host")) {
                    ((SpdyRequest)object2).addHeaders((Map<String, String>)object3);
                    ((SpdyRequest)object2).addHeader(":host", this.m ? this.e : request.getHost());
                } else {
                    object3 = new HashMap<String, String>(request.getHeaders());
                    object = (String)object3.remove("Host");
                    object3.put((String)":host", (String)(this.m ? this.e : object));
                    ((SpdyRequest)object2).addHeaders((Map<String, String>)object3);
                }
                object = request.getBodyBytes();
                object3 = new SpdyDataProvider((byte[])object);
                request.a.sendStart = System.currentTimeMillis();
                request.a.processTime = request.a.sendStart - request.a.start;
                int n2 = this.x.submitRequest((SpdyRequest)object2, (SpdyDataProvider)object3, this, new a(request, requestCb));
                if (ALog.isPrintLog(1)) {
                    ALog.d("awcn.TnetSpdySession", "", request.getSeq(), "streamId", n2);
                }
                c2 = new c(this.x, n2, request.getSeq());
                ++this.q.requestCount;
                ++this.q.stdRCount;
                this.z = System.currentTimeMillis();
                if (this.D != null) {
                    this.D.reSchedule();
                }
                if (this.j.isQuic()) {
                    request.a.putExtra("QuicConnectionID", this.x.getQuicConnectionID());
                }
            } else {
                requestCb.onFinish(-301, ErrorConstant.getErrMsg(-301), request.a);
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            SpdyErrorException spdyErrorException2 = spdyErrorException;
            if (spdyErrorException.SpdyErrorGetCode() == -1104 || spdyErrorException2.SpdyErrorGetCode() == -1103) {
                ALog.e("awcn.TnetSpdySession", "Send request on closed session!!!", this.p, new Object[0]);
                this.notifyStatus(6, new b(2));
            }
            requestCb.onFinish(-300, ErrorConstant.formatMsg(-300, String.valueOf(spdyErrorException2.SpdyErrorGetCode())), requestStatistic);
        }
        catch (Exception exception) {
            requestCb.onFinish(-101, ErrorConstant.getErrMsg(-101), requestStatistic);
        }
        return c2;
    }

    @Override
    public void sendCustomFrame(int n2, byte[] byArray, int n3) {
        try {
            if (this.C == null) {
                return;
            }
            ALog.e("awcn.TnetSpdySession", "sendCustomFrame", this.p, "dataId", n2, "type", n3);
            if (this.n == 4 && this.x != null) {
                if (byArray != null && byArray.length > 16384) {
                    this.a(n2, -303, false, null);
                    return;
                }
                this.x.sendCustomControlFrame(n2, n3, 0, byArray == null ? 0 : byArray.length, byArray);
                ++this.q.requestCount;
                ++this.q.cfRCount;
                this.z = System.currentTimeMillis();
                if (this.D != null) {
                    this.D.reSchedule();
                    return;
                }
            } else {
                ALog.e("awcn.TnetSpdySession", "sendCustomFrame", this.p, "sendCustomFrame con invalid mStatus:" + this.n);
                this.a(n2, -301, true, "session invalid");
            }
            return;
        }
        catch (SpdyErrorException spdyErrorException) {
            ALog.e("awcn.TnetSpdySession", "sendCustomFrame error", this.p, spdyErrorException, new Object[0]);
            this.a(n2, -300, true, "SpdyErrorException: " + spdyErrorException.toString());
            return;
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "sendCustomFrame error", this.p, exception, new Object[0]);
            this.a(n2, -101, true, exception.toString());
            return;
        }
    }

    private void a(int n2, int n3, boolean bl, String string) {
        if (this.C != null) {
            this.C.onException(n2, n3, bl, string);
        }
    }

    @Override
    public void connect() {
        if (this.n == 1 || this.n == 0 || this.n == 4) {
            return;
        }
        try {
            if (this.w == null) {
                this.c();
            }
            if (anet.channel.util.d.a() && anet.channel.strategy.utils.c.a(this.e)) {
                try {
                    this.f = anet.channel.util.d.a(this.e);
                }
                catch (Exception exception) {}
            }
            Object object = String.valueOf(System.currentTimeMillis());
            ALog.e("awcn.TnetSpdySession", "connect", this.p, "host", this.c, "ip", this.f, "port", this.g, "sessionId", object, "SpdyProtocol,", this.j, "proxyIp,", this.h, "proxyPort,", this.i);
            object = new org.android.spdy.SessionInfo(this.f, this.g, this.c + "_" + this.F, this.h, this.i, object, this, this.j.getTnetConType());
            ((org.android.spdy.SessionInfo)object).setConnectionTimeoutMs((int)((float)this.r * Utils.getNetworkTimeFactor()));
            if (this.j.isPublicKeyAuto() || this.j.isQuic() || this.j.isH2S()) {
                ((org.android.spdy.SessionInfo)object).setCertHost(this.m ? this.e : this.d);
            } else if (this.B >= 0) {
                ((org.android.spdy.SessionInfo)object).setPubKeySeqNum(this.B);
            } else {
                this.B = this.j.getTnetPublicKey(this.G != null ? this.G.isSecOff() : true);
                ((org.android.spdy.SessionInfo)object).setPubKeySeqNum(this.B);
            }
            this.x = this.w.createSession((org.android.spdy.SessionInfo)object);
            if (this.x.getRefCount() > 1) {
                ALog.e("awcn.TnetSpdySession", "get session ref count > 1!!!", this.p, new Object[0]);
                this.notifyStatus(0, new b(1));
                this.b();
                return;
            }
            this.notifyStatus(1, null);
            this.z = System.currentTimeMillis();
            this.q.isProxy = !TextUtils.isEmpty((CharSequence)this.h) ? 1 : 0;
            this.q.isTunnel = "false";
            this.q.isBackground = GlobalAppRuntimeInfo.isAppBackground();
            this.A = 0L;
            return;
        }
        catch (Throwable throwable) {
            this.notifyStatus(2, null);
            ALog.e("awcn.TnetSpdySession", "connect exception ", this.p, throwable, new Object[0]);
            return;
        }
    }

    @Override
    public void close() {
        ALog.e("awcn.TnetSpdySession", "force close!", this.p, "session", this);
        this.notifyStatus(7, null);
        try {
            if (this.D != null) {
                this.D.stop();
                this.D = null;
            }
            if (this.x != null) {
                this.x.closeSession();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    protected void onDisconnect() {
        this.y = false;
    }

    @Override
    protected Runnable getRecvTimeOutRunnable() {
        return new h(this);
    }

    @Override
    public void ping(boolean bl) {
        if (ALog.isPrintLog(1)) {
            ALog.d("awcn.TnetSpdySession", "ping", this.p, "host", this.c, "thread", Thread.currentThread().getName());
        }
        try {
            if (bl) {
                if (this.x != null) {
                    if (this.n == 0 || this.n == 4) {
                        this.handleCallbacks(64, null);
                        this.y = true;
                        ++this.q.ppkgCount;
                        this.x.submitPing();
                        if (ALog.isPrintLog(1)) {
                            ALog.d("awcn.TnetSpdySession", this.c + " submit ping ms:" + (System.currentTimeMillis() - this.z) + " force:" + bl, this.p, new Object[0]);
                        }
                        this.setPingTimeout();
                        this.z = System.currentTimeMillis();
                        if (this.D != null) {
                            this.D.reSchedule();
                            return;
                        }
                    }
                } else {
                    if (this.q != null) {
                        this.q.closeReason = "session null";
                    }
                    ALog.e("awcn.TnetSpdySession", this.c + " session null", this.p, new Object[0]);
                    this.close();
                }
            }
            return;
        }
        catch (SpdyErrorException spdyErrorException) {
            SpdyErrorException spdyErrorException2 = spdyErrorException;
            if (spdyErrorException.SpdyErrorGetCode() == -1104 || spdyErrorException2.SpdyErrorGetCode() == -1103) {
                ALog.e("awcn.TnetSpdySession", "Send request on closed session!!!", this.p, new Object[0]);
                this.notifyStatus(6, new b(2));
            }
            ALog.e("awcn.TnetSpdySession", "ping", this.p, spdyErrorException2, new Object[0]);
            return;
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "ping", this.p, exception, new Object[0]);
            return;
        }
    }

    protected void b() {
        if (this.E != null) {
            this.E.auth(this, new i(this));
            return;
        }
        this.notifyStatus(4, null);
        this.q.ret = 1;
        if (this.D != null) {
            this.D.start(this);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.n == 4;
    }

    private void c() {
        SpdyAgent.enableDebug = false;
        this.w = SpdyAgent.getInstance(this.a, SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION);
        if (this.G != null && !this.G.isSecOff()) {
            this.w.setAccsSslCallback(new j(this));
        }
        if (!AwcnConfig.isTnetHeaderCacheEnable()) {
            try {
                this.w.getClass().getDeclaredMethod("disableHeaderCache", new Class[0]).invoke((Object)this.w, new Object[0]);
                ALog.i("awcn.TnetSpdySession", "tnet disableHeaderCache", null, new Object[0]);
                return;
            }
            catch (Exception exception) {
                ALog.e("awcn.TnetSpdySession", "tnet disableHeaderCache", null, exception, new Object[0]);
            }
        }
    }

    @Override
    public void spdySessionConnectCB(SpdySession spdySession, SuperviseConnectInfo superviseConnectInfo) {
        this.q.connectionTime = superviseConnectInfo.connectTime;
        this.q.sslTime = superviseConnectInfo.handshakeTime;
        this.q.sslCalTime = superviseConnectInfo.doHandshakeTime;
        this.q.netType = NetworkStatusHelper.getNetworkSubType();
        this.A = System.currentTimeMillis();
        this.notifyStatus(0, new b(1));
        this.b();
        ALog.e("awcn.TnetSpdySession", "spdySessionConnectCB connect", this.p, "connectTime", superviseConnectInfo.connectTime, "sslTime:", superviseConnectInfo.handshakeTime);
    }

    @Override
    public void spdyPingRecvCallback(SpdySession spdySession, long l2, Object object) {
        if (ALog.isPrintLog(2)) {
            ALog.i("awcn.TnetSpdySession", "ping receive", this.p, "Host", this.c, "id", l2);
        }
        if (l2 < 0L) {
            return;
        }
        this.y = false;
        this.H = 0;
        if (this.D != null) {
            this.D.reSchedule();
        }
        this.handleCallbacks(128, null);
    }

    @Override
    public void bioPingRecvCallback(SpdySession spdySession, int n2) {
    }

    @Override
    public void spdyCustomControlFrameRecvCallback(SpdySession object, Object object2, int n2, int n3, int n4, int n5, byte[] byArray) {
        ALog.e("awcn.TnetSpdySession", "[spdyCustomControlFrameRecvCallback]", this.p, "len", n5, "frameCb", this.C);
        if (ALog.isPrintLog(1)) {
            object = "";
            if (n5 < 512) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    object = (String)object + Integer.toHexString(0xFF & byArray[i2]) + " ";
                }
                ALog.e("awcn.TnetSpdySession", null, this.p, "str", object);
            }
        }
        if (this.C != null) {
            this.C.onDataReceive(this, byArray, n2, n3);
        } else {
            ALog.e("awcn.TnetSpdySession", "AccsFrameCb is null", this.p, new Object[0]);
            object = new ExceptionStatistic(-105, null, "rt");
            AppMonitor.getInstance().commitStat((StatObject)object);
        }
        ++this.q.inceptCount;
        if (this.D != null) {
            this.D.reSchedule();
        }
    }

    @Override
    public void spdySessionFailedError(SpdySession spdySession, int n2, Object object) {
        try {
            if (spdySession != null) {
                spdySession.cleanUp();
            }
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "[spdySessionFailedError]session clean up failed!", null, exception, new Object[0]);
        }
        this.notifyStatus(2, new b(256, n2, "tnet connect fail"));
        ALog.e("awcn.TnetSpdySession", null, this.p, " errorId:", n2);
        this.q.errorCode = n2;
        this.q.ret = 0;
        this.q.netType = NetworkStatusHelper.getNetworkSubType();
        AppMonitor.getInstance().commitStat(this.q);
        AppMonitor.getInstance().commitAlarm(this.q.getAlarmObject());
    }

    @Override
    public void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
        ALog.e("awcn.TnetSpdySession", "spdySessionCloseCallback", this.p, " errorCode:", n2);
        if (this.D != null) {
            this.D.stop();
            this.D = null;
        }
        try {
            if (spdySession != null) {
                spdySession.cleanUp();
            }
        }
        catch (Exception exception) {
            ALog.e("awcn.TnetSpdySession", "session clean up failed!", null, exception, new Object[0]);
        }
        this.notifyStatus(6, new b(2));
        if (superviseConnectInfo != null) {
            this.q.requestCount = superviseConnectInfo.reused_counter;
            this.q.liveTime = superviseConnectInfo.keepalive_period_second;
            try {
                if (this.j.isQuic()) {
                    this.q.extra = new JSONObject();
                    this.q.extra.put("QuicConnectionID", (Object)this.x.getQuicConnectionID());
                    this.q.extra.put("retransmissionRate", superviseConnectInfo.retransmissionRate);
                    this.q.extra.put("lossRate", superviseConnectInfo.lossRate);
                    this.q.extra.put("tlpCount", superviseConnectInfo.tlpCount);
                    this.q.extra.put("rtoCount", superviseConnectInfo.rtoCount);
                }
            }
            catch (JSONException jSONException) {}
        }
        if (this.q.errorCode == 0L) {
            this.q.errorCode = n2;
        }
        this.q.lastPingInterval = (int)(System.currentTimeMillis() - this.z);
        AppMonitor.getInstance().commitStat(this.q);
        AppMonitor.getInstance().commitAlarm(this.q.getAlarmObject());
    }

    @Override
    public void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
        ALog.e("awcn.TnetSpdySession", "spdyCustomControlFrameFailCallback", this.p, "dataId", n2);
        this.a(n2, n3, true, "tnet error");
    }

    @Override
    public byte[] getSSLMeta(SpdySession object) {
        byte[] byArray = null;
        if (TextUtils.isEmpty((CharSequence)(object = ((SpdySession)object).getDomain()))) {
            ALog.i("awcn.TnetSpdySession", "get sslticket host is null", null, new Object[0]);
            return null;
        }
        try {
            if (this.G != null) {
                byArray = this.G.getBytes(this.a, "accs_ssl_key2_" + (String)object);
            }
        }
        catch (Throwable throwable) {
            ALog.e("awcn.TnetSpdySession", "getSSLMeta", null, throwable, new Object[0]);
        }
        return byArray;
    }

    @Override
    public int putSSLMeta(SpdySession object, byte[] byArray) {
        int n2 = -1;
        if (TextUtils.isEmpty((CharSequence)(object = ((SpdySession)object).getDomain()))) {
            return -1;
        }
        try {
            if (this.G != null) {
                n2 = this.G.saveBytes(this.a, "accs_ssl_key2_" + (String)object, byArray) ? 0 : -1;
            }
        }
        catch (Throwable throwable) {
            ALog.e("awcn.TnetSpdySession", "putSSLMeta", null, throwable, new Object[0]);
        }
        return n2;
    }

    static /* synthetic */ void a(TnetSpdySession tnetSpdySession, int n2, b b2) {
        tnetSpdySession.handleCallbacks(n2, b2);
    }

    static /* synthetic */ String a(TnetSpdySession tnetSpdySession) {
        return tnetSpdySession.d;
    }

    static /* synthetic */ IConnStrategy b(TnetSpdySession tnetSpdySession) {
        return tnetSpdySession.k;
    }

    static /* synthetic */ void b(TnetSpdySession tnetSpdySession, int n2, b b2) {
        tnetSpdySession.notifyStatus(n2, b2);
    }

    static /* synthetic */ void c(TnetSpdySession tnetSpdySession, int n2, b b2) {
        tnetSpdySession.notifyStatus(n2, b2);
    }

    static /* synthetic */ Context c(TnetSpdySession tnetSpdySession) {
        return tnetSpdySession.a;
    }

    private class a
    extends anet.channel.session.a {
        private Request b;
        private RequestCb c;
        private int d = 0;
        private long e = 0L;

        public a(Request request, RequestCb requestCb) {
            this.b = request;
            this.c = requestCb;
        }

        @Override
        public void spdyDataChunkRecvCB(SpdySession object, boolean bl, long l2, SpdyByteArray spdyByteArray, Object object2) {
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.TnetSpdySession", "spdyDataChunkRecvCB", this.b.getSeq(), "len", spdyByteArray.getDataLength(), "fin", bl);
            }
            this.e += (long)spdyByteArray.getDataLength();
            this.b.a.recDataSize += (long)spdyByteArray.getDataLength();
            if (TnetSpdySession.this.D != null) {
                TnetSpdySession.this.D.reSchedule();
            }
            if (this.c != null) {
                object = a.a.a.a(spdyByteArray.getByteArray(), spdyByteArray.getDataLength());
                spdyByteArray.recycle();
                this.c.onDataReceive((ByteArray)object, bl);
            }
            TnetSpdySession.this.handleCallbacks(32, null);
        }

        @Override
        public void spdyStreamCloseCallback(SpdySession object, long l2, int n2, Object object2, SuperviseData superviseData) {
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.TnetSpdySession", "spdyStreamCloseCallback", this.b.getSeq(), "streamId", l2, "errorCode", n2);
            }
            object = "SUCCESS";
            if (n2 != 0) {
                this.d = -304;
                object = ErrorConstant.formatMsg(-304, String.valueOf(n2));
                if (n2 != -2005) {
                    AppMonitor.getInstance().commitStat(new ExceptionStatistic(-300, (String)object, this.b.a, null));
                }
                ALog.e("awcn.TnetSpdySession", "spdyStreamCloseCallback error", this.b.getSeq(), "session", TnetSpdySession.this.p, "status code", n2, "URL", this.b.getHttpUrl().simpleUrlString());
            }
            this.b.a.tnetErrorCode = n2;
            this.a(superviseData, this.d, (String)object);
            if (this.c != null) {
                this.c.onFinish(this.d, (String)object, this.b.a);
            }
            if (n2 == -2004) {
                if (!TnetSpdySession.this.y) {
                    TnetSpdySession.this.ping(true);
                }
                if (++TnetSpdySession.this.H >= 2) {
                    object = new ConnEvent();
                    new ConnEvent().isSuccess = false;
                    StrategyCenter.getInstance().notifyConnEvent(TnetSpdySession.this.d, TnetSpdySession.this.k, (ConnEvent)object);
                    TnetSpdySession.this.close(true);
                }
            }
        }

        private void a(SuperviseData superviseData, int n2, String string) {
            try {
                this.b.a.rspEnd = System.currentTimeMillis();
                if (this.b.a.isDone.get()) {
                    return;
                }
                if (n2 > 0) {
                    this.b.a.ret = 1;
                }
                this.b.a.statusCode = n2;
                this.b.a.msg = string;
                if (superviseData != null) {
                    this.b.a.rspEnd = superviseData.responseEnd;
                    this.b.a.sendBeforeTime = superviseData.sendStart - superviseData.requestStart;
                    this.b.a.sendDataTime = superviseData.sendEnd - this.b.a.sendStart;
                    this.b.a.firstDataTime = superviseData.responseStart - superviseData.sendEnd;
                    this.b.a.recDataTime = superviseData.responseEnd - superviseData.responseStart;
                    this.b.a.sendDataSize = superviseData.bodySize + superviseData.compressSize;
                    this.b.a.recDataSize = this.e + (long)superviseData.recvUncompressSize;
                    this.b.a.reqHeadInflateSize = superviseData.uncompressSize;
                    this.b.a.reqHeadDeflateSize = superviseData.compressSize;
                    this.b.a.reqBodyInflateSize = superviseData.bodySize;
                    this.b.a.reqBodyDeflateSize = superviseData.bodySize;
                    this.b.a.rspHeadDeflateSize = superviseData.recvCompressSize;
                    this.b.a.rspHeadInflateSize = superviseData.recvUncompressSize;
                    this.b.a.rspBodyDeflateSize = superviseData.recvBodySize;
                    this.b.a.rspBodyInflateSize = this.e;
                    if (this.b.a.contentLength == 0L) {
                        this.b.a.contentLength = superviseData.originContentLength;
                    }
                    TnetSpdySession.this.q.recvSizeCount += (long)(superviseData.recvBodySize + superviseData.recvCompressSize);
                    TnetSpdySession.this.q.sendSizeCount += (long)(superviseData.bodySize + superviseData.compressSize);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        @Override
        public void spdyOnStreamResponse(SpdySession spdySession, long l2, Map<String, List<String>> map, Object object) {
            this.b.a.firstDataTime = System.currentTimeMillis() - this.b.a.sendStart;
            this.d = HttpHelper.parseStatusCode(map);
            TnetSpdySession.this.H = 0;
            ALog.i("awcn.TnetSpdySession", "", this.b.getSeq(), "statusCode", this.d);
            ALog.i("awcn.TnetSpdySession", "", this.b.getSeq(), "response headers", map);
            if (this.c != null) {
                this.c.onResponseCode(this.d, HttpHelper.cloneMap(map));
            }
            TnetSpdySession.this.handleCallbacks(16, null);
            this.b.a.contentEncoding = HttpHelper.getSingleHeaderFieldByKey(map, "Content-Encoding");
            this.b.a.contentType = HttpHelper.getSingleHeaderFieldByKey(map, "Content-Type");
            this.b.a.contentLength = HttpHelper.parseContentLength(map);
            this.b.a.serverRT = HttpHelper.parseServerRT(map);
            TnetSpdySession.this.handleResponseCode(this.b, this.d);
            TnetSpdySession.this.handleResponseHeaders(this.b, map);
            if (TnetSpdySession.this.D != null) {
                TnetSpdySession.this.D.reSchedule();
            }
        }
    }
}

