/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util.support;

import java.util.HashMap;
import java.util.Map;

public class NetworkInfo {
    public NetworkSP networkSP;
    public NetworkType networkType;

    public NetworkInfo(NetworkSP networkSP, NetworkType networkType) {
        this.networkSP = networkSP;
        this.networkType = networkType;
    }

    public byte toByte() {
        return (byte)((byte)(this.networkType.code() << 4) | this.networkSP.code());
    }

    public static NetworkInfo fromByte(byte by) {
        return new NetworkInfo(NetworkSP.from(by & 0xF), NetworkType.from(by >> 4));
    }

    public static enum NetworkType {
        UNKNOWN(1),
        WIFI(2),
        G2(3),
        G3(4),
        G4(5);

        private static Map<Integer, NetworkType> map;
        private int code;

        private NetworkType(int n3) {
            this.code = n3;
        }

        public static NetworkType from(int n2) {
            return map.get(n2);
        }

        public final int code() {
            return this.code;
        }

        static {
            map = new HashMap<Integer, NetworkType>();
            for (NetworkType networkType : NetworkType.values()) {
                map.put(networkType.code, networkType);
            }
        }
    }

    public static enum NetworkSP {
        UNKNOWN(1),
        CHINA_MOBILE(2),
        CHINA_UNICOM(3),
        CHINA_TELECOM(4);

        private static Map<Integer, NetworkSP> map;
        private int code;

        private NetworkSP(int n3) {
            this.code = n3;
        }

        public static NetworkSP from(int n2) {
            return map.get(n2);
        }

        public final int code() {
            return this.code;
        }

        static {
            map = new HashMap<Integer, NetworkSP>();
            for (NetworkSP networkSP : NetworkSP.values()) {
                map.put(networkSP.code, networkSP);
            }
        }
    }
}

