/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.status;

import android.content.Context;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Pair;
import anet.channel.status.a;
import anet.channel.status.b;
import anet.channel.thread.ThreadPoolExecutorFactory;
import anet.channel.util.ALog;
import anet.channel.util.h;
import java.util.concurrent.CopyOnWriteArraySet;

public class NetworkStatusHelper {
    private static final String TAG = "awcn.NetworkStatusHelper";
    static CopyOnWriteArraySet<INetworkStatusChangeListener> listeners = new CopyOnWriteArraySet();

    public static synchronized void startListener(Context context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        b.a = context;
        b.a();
        b.c();
    }

    public void stopListener(Context context) {
        b.b();
    }

    public static void addStatusChangeListener(INetworkStatusChangeListener iNetworkStatusChangeListener) {
        listeners.add(iNetworkStatusChangeListener);
    }

    public static void removeStatusChangeListener(INetworkStatusChangeListener iNetworkStatusChangeListener) {
        listeners.remove(iNetworkStatusChangeListener);
    }

    static void notifyStatusChanged(NetworkStatus networkStatus) {
        ThreadPoolExecutorFactory.submitScheduledTask(new a(networkStatus));
    }

    public static NetworkStatus getStatus() {
        return b.c;
    }

    public static String getNetworkSubType() {
        return b.d;
    }

    public static String getApn() {
        return b.e;
    }

    public static String getCarrier() {
        return b.h;
    }

    public static String getSimOp() {
        return b.i;
    }

    public static boolean isRoaming() {
        return b.k;
    }

    public static String getWifiBSSID() {
        return b.g;
    }

    public static String getWifiSSID() {
        return b.f;
    }

    public static String getDnsServerAddress() {
        if (!b.l.isEmpty()) {
            return b.l.get(0).getHostAddress();
        }
        return b.f();
    }

    public static boolean isConnected() {
        if (Build.VERSION.SDK_INT >= 24 ? b.b : b.c != NetworkStatus.NO) {
            return true;
        }
        try {
            NetworkInfo networkInfo = b.e();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isProxy() {
        NetworkStatus networkStatus = b.c;
        String string = b.e;
        return networkStatus == NetworkStatus.WIFI && NetworkStatusHelper.getWifiProxy() != null || networkStatus.isMobile() && (string.contains("wap") || h.a() != null);
    }

    public static String getProxyType() {
        NetworkStatus networkStatus = b.c;
        if (networkStatus == NetworkStatus.WIFI && NetworkStatusHelper.getWifiProxy() != null) {
            return "proxy";
        }
        if (networkStatus.isMobile() && b.e.contains("wap")) {
            return "wap";
        }
        if (networkStatus.isMobile() && h.a() != null) {
            return "auth";
        }
        return "";
    }

    public static Pair<String, Integer> getWifiProxy() {
        if (b.c != NetworkStatus.WIFI) {
            return null;
        }
        return b.j;
    }

    public static void printNetworkDetail() {
        try {
            Pair<String, Integer> pair = NetworkStatusHelper.getStatus();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("\nNetwork detail*******************************\n");
            stringBuilder.append("Status: ").append(pair.getType()).append('\n');
            stringBuilder.append("Subtype: ").append(NetworkStatusHelper.getNetworkSubType()).append('\n');
            if (pair != NetworkStatus.NO) {
                if (pair.isMobile()) {
                    stringBuilder.append("Apn: ").append(NetworkStatusHelper.getApn()).append('\n');
                    stringBuilder.append("Carrier: ").append(NetworkStatusHelper.getCarrier()).append('\n');
                } else {
                    stringBuilder.append("BSSID: ").append(NetworkStatusHelper.getWifiBSSID()).append('\n');
                    stringBuilder.append("SSID: ").append(NetworkStatusHelper.getWifiSSID()).append('\n');
                }
            }
            if (NetworkStatusHelper.isProxy()) {
                stringBuilder.append("Proxy: ").append(NetworkStatusHelper.getProxyType()).append('\n');
                pair = NetworkStatusHelper.getWifiProxy();
                if (pair != null) {
                    stringBuilder.append("ProxyHost: ").append((String)pair.first).append('\n');
                    stringBuilder.append("ProxyPort: ").append(pair.second).append('\n');
                }
            }
            stringBuilder.append("*********************************************");
            ALog.i(TAG, stringBuilder.toString(), null, new Object[0]);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static interface INetworkStatusChangeListener {
        public void onNetworkStatusChanged(NetworkStatus var1);
    }

    public static enum NetworkStatus {
        NONE,
        NO,
        G2,
        G3,
        G4,
        WIFI;


        public final boolean isMobile() {
            return this == G2 || this == G3 || this == G4;
        }

        public final boolean isWifi() {
            return this == WIFI;
        }

        public final String getType() {
            if (this == G2) {
                return "2G";
            }
            if (this == G3) {
                return "3G";
            }
            if (this == G4) {
                return "4G";
            }
            return this.toString();
        }
    }
}

