/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.ams.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SysInfoUtil {
    public static final int DEFAULT_TIMEZONE = 8;
    protected static final String LOG_TAG = SysInfoUtil.class.getName();
    protected static final String UNKNOW = "Unknown";
    private static final String MOBILE_NETWORK = "2G/3G";
    private static final String WIFI = "Wi-Fi";
    private static AmsLogger sLogger = AmsLogger.getLogger(LOG_TAG);

    public static Map<String, String> getSysInfo(Context context, Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        jSONObject = SysInfoUtil.getDeviceInfo(context, jSONObject);
        jSONObject = SysInfoUtil.getLocalInfo(context, jSONObject);
        jSONObject = SysInfoUtil.getSDKInfo(SysInfoUtil.getNetworkInfo(context, jSONObject));
        map.put("deviceInfo", jSONObject.toString());
        return map;
    }

    public static JSONObject getDeviceInfo(Context object, JSONObject jSONObject) {
        String string = Build.MODEL;
        String string2 = "Android";
        String string3 = Build.VERSION.RELEASE;
        object = SysInfoUtil.getResolution(object);
        String string4 = SysInfoUtil.getCPU();
        try {
            jSONObject.put("model", (Object)string);
            jSONObject.put("os", (Object)string2);
            jSONObject.put("osVersion", (Object)string3);
            jSONObject.put("resolution", object);
            jSONObject.put("cpu", (Object)string4);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public static String getResolution(Context object) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)object.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = -1;
            int n3 = 0;
            if ((object.getApplicationInfo().flags & 0x2000) == 0) {
                n2 = SysInfoUtil.reflectMetrics(displayMetrics, "noncompatWidthPixels");
                n3 = SysInfoUtil.reflectMetrics(displayMetrics, "noncompatHeightPixels");
            }
            if (n2 == -1 || n3 == -1) {
                n2 = displayMetrics.widthPixels;
                n3 = displayMetrics.heightPixels;
            }
            object = new StringBuffer();
            ((StringBuffer)object).append(n2);
            ((StringBuffer)object).append("*");
            ((StringBuffer)object).append(n3);
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            sLogger.e("read resolution fail", exception);
            return UNKNOW;
        }
    }

    private static int reflectMetrics(Object object, String object2) {
        try {
            object2 = DisplayMetrics.class.getDeclaredField((String)object2);
            ((Field)object2).setAccessible(true);
            return ((Field)object2).getInt(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    private static String getCPU() {
        String string = null;
        try {
            FileReader fileReader = new FileReader("/proc/cpuinfo");
            try {
                BufferedReader bufferedReader = new BufferedReader(fileReader, 1024);
                string = bufferedReader.readLine();
                bufferedReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
                sLogger.e("Could not read from file /proc/cpuinfo", iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            sLogger.e("Could not open file /proc/cpuinfo", fileNotFoundException);
        }
        if (string != null) {
            int n2 = string.indexOf(58) + 1;
            string = string.substring(n2);
        }
        return string.trim();
    }

    public static String[] getLocalInfo(Context object) {
        String[] stringArray = new String[2];
        try {
            object = SysInfoUtil.getLocale((Context)object);
            if (object != null) {
                stringArray[0] = ((Locale)object).getCountry();
                stringArray[1] = ((Locale)object).getLanguage();
            }
            if (StringUtil.isEmpty(stringArray[0])) {
                stringArray[0] = UNKNOW;
            }
            if (StringUtil.isEmpty(stringArray[1])) {
                stringArray[1] = UNKNOW;
            }
            return stringArray;
        }
        catch (Exception exception) {
            sLogger.e("error in getLocaleInfo", exception);
            return stringArray;
        }
    }

    private static Locale getLocale(Context context) {
        Locale locale = null;
        try {
            Configuration configuration = new Configuration();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            locale = configuration.locale;
        }
        catch (Exception exception) {
            sLogger.e("fail to read user config locale", exception);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static JSONObject getLocalInfo(Context object, JSONObject jSONObject) {
        int n2 = SysInfoUtil.getTimeZone((Context)object);
        object = SysInfoUtil.getLocalInfo((Context)object);
        String string = object[0];
        object = object[1];
        try {
            jSONObject.put("timezone", n2);
            jSONObject.put("country", (Object)string);
            jSONObject.put("language", object);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public static int getTimeZone(Context object) {
        try {
            object = Calendar.getInstance(SysInfoUtil.getLocale((Context)object));
            if (object != null) {
                return ((Calendar)object).getTimeZone().getRawOffset() / 3600000;
            }
        }
        catch (Exception exception) {
            sLogger.e("error in getTimeZone", exception);
        }
        return 8;
    }

    public static JSONObject getNetworkInfo(Context object, JSONObject jSONObject) {
        object = SysInfoUtil.getNetworkAccessMode((Context)object);
        String string = object[0];
        object = object[1];
        try {
            jSONObject.put("networkType", (Object)string);
            jSONObject.put("subNetworkType", object);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOW, UNKNOW};
        try {
            context = (ConnectivityManager)context.getSystemService("connectivity");
            if (context == null) {
                return stringArray;
            }
            NetworkInfo networkInfo = context.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = WIFI;
                return stringArray;
            }
            if ((context = context.getNetworkInfo(0)) != null && context.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = MOBILE_NETWORK;
                stringArray[1] = context.getSubtypeName();
                return stringArray;
            }
        }
        catch (Exception exception) {
            sLogger.e("get network access mode failed", exception);
        }
        return stringArray;
    }

    public static JSONObject getSDKInfo(JSONObject jSONObject) {
        try {
            jSONObject.put("sdkType", (Object)"Android");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public static boolean shouldInit(Context object) {
        boolean bl = false;
        try {
            Object object2 = ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses();
            object = object.getPackageName();
            int n2 = Process.myPid();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object2.next();
                if (runningAppProcessInfo.pid != n2 || !((String)object).equals(runningAppProcessInfo.processName)) continue;
                bl = true;
                break;
            }
        }
        catch (Throwable throwable) {
            sLogger.e("Get sysInfo failed.", throwable);
        }
        return bl;
    }
}

