/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util.sendrequest;

import android.content.Context;
import android.os.AsyncTask;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.ams.common.util.HttpConnectionUtil;
import com.alibaba.sdk.android.push.common.global.VIPErrorEnum;
import com.alibaba.sdk.android.push.common.util.sendrequest.ConnectionException;
import com.alibaba.sdk.android.push.common.util.sendrequest.Response;
import com.alibaba.sdk.android.push.common.util.sendrequest.VipRequestType;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Map;

public abstract class SendRequestTask
extends AsyncTask<Map<String, String>, Void, Response> {
    private static final String TAG = "MPS:SendRequestTask";
    static AmsLogger logger = AmsLogger.getLogger("MPS:SendRequestTask");
    private Context context;
    private String requestUrl;
    private int result;
    public String sendmethod = "POST";
    private int vipRequestType = 0;

    public SendRequestTask(Context context, String string) {
        this.context = context;
        this.requestUrl = string;
    }

    public SendRequestTask() {
    }

    protected Response doInBackground(Map<String, String> ... object) {
        Map<String, String> map = object[0];
        if (map.containsKey(VipRequestType.Key)) {
            this.vipRequestType = Integer.parseInt(map.get(VipRequestType.Key));
            object = new Response(Integer.parseInt(map.get(VipRequestType.Key)));
        } else {
            object = new Response();
        }
        try {
            map = this.sendHttpRequest(this.context, this.requestUrl, map);
            object.rsCode = 200;
            object.rsBody = map;
        }
        catch (ConnectionException connectionException) {
            object.rsCode = Integer.parseInt(connectionException.getReturnCode());
            object.rsBody = connectionException.getMessage();
        }
        return object;
    }

    protected void onPostExecute(Response response) {
        logger.i("HTTP Return code: " + response.rsCode);
    }

    protected abstract Map<String, String> encodingRequestParameters(Context var1, Map<String, String> var2);

    public String sendHttpRequest(Context object, String object2, Map<String, String> object3) throws ConnectionException {
        HttpURLConnection httpURLConnection = null;
        try {
            object3 = this.encodingRequestParameters((Context)object, (Map<String, String>)object3);
            httpURLConnection = HttpConnectionUtil.openConnection((String)object2, object3, this.sendmethod);
            if (httpURLConnection == null) {
                logger.e("failed to access VIP service.");
                throw new ConnectionException(1, String.valueOf(VIPErrorEnum.CONNECTION_FAIL.getErrorCode()), "Connection open failed.");
            }
            if (httpURLConnection.getResponseCode() == 200) {
                int n2;
                object = httpURLConnection.getInputStream();
                object2 = new byte[1024];
                object3 = new ByteArrayOutputStream(1024);
                while (!Thread.interrupted() && (n2 = ((InputStream)object).read((byte[])object2)) != -1) {
                    ((ByteArrayOutputStream)object3).write((byte[])object2, 0, n2);
                }
                String string = new String(((ByteArrayOutputStream)object3).toByteArray(), "utf-8");
                return string;
            }
            try {
                throw new ConnectionException(1, String.valueOf(VIPErrorEnum.CONNECTION_FAIL.getErrorCode()), "Http with unsuccessful response code: " + httpURLConnection.getResponseCode());
            }
            catch (ConnectionException connectionException) {
                throw connectionException;
            }
            catch (Exception exception) {
                logger.e("VIP API failed! error: ", exception);
                throw new ConnectionException(1, String.valueOf(VIPErrorEnum.CONNECTION_FAIL.getErrorCode()), "VIP API failed, error: " + exception);
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String string) {
        this.requestUrl = string;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int n2) {
        this.result = n2;
    }

    public int getVipRequestType() {
        return this.vipRequestType;
    }

    public void setVipRequestType(int n2) {
        this.vipRequestType = n2;
    }
}

