/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.LruCache;
import anet.channel.AccsSessionManager;
import anet.channel.AwcnConfig;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.NoAvailStrategyException;
import anet.channel.Session;
import anet.channel.SessionGetCallback;
import anet.channel.SessionInfo;
import anet.channel.SessionRequest;
import anet.channel.b;
import anet.channel.d;
import anet.channel.entity.ConnType;
import anet.channel.entity.ENV;
import anet.channel.entity.c;
import anet.channel.security.ISecurity;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.ConnProtocol;
import anet.channel.strategy.IStrategyListener;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.l;
import anet.channel.util.ALog;
import anet.channel.util.AppLifecycle;
import anet.channel.util.HttpUrl;
import anet.channel.util.StringUtils;
import anet.channel.util.Utils;
import anet.channel.util.j;
import java.net.ConnectException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;

public class SessionCenter {
    public static final String TAG = "awcn.SessionCenter";
    static Map<Config, SessionCenter> a = new HashMap<Config, SessionCenter>();
    private static boolean j = false;
    Context b;
    String c;
    Config d;
    final d e = new d();
    final LruCache<String, SessionRequest> f = new LruCache(32);
    final b g = new b();
    final AccsSessionManager h;
    final a i = new a(null);

    public static synchronized void init(Context context) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        GlobalAppRuntimeInfo.setContext(context.getApplicationContext());
        if (!j) {
            a.put(Config.DEFAULT_CONFIG, new SessionCenter(Config.DEFAULT_CONFIG));
            AppLifecycle.initialize();
            NetworkStatusHelper.startListener(context);
            StrategyCenter.getInstance().initialize(GlobalAppRuntimeInfo.getContext());
            if (GlobalAppRuntimeInfo.isTargetProcess()) {
                anet.channel.d.a.a();
                anet.channel.f.a.a();
            }
            j = true;
        }
    }

    @Deprecated
    public static synchronized void init(Context context, String string) {
        SessionCenter.init(context, string, GlobalAppRuntimeInfo.getEnv());
    }

    public static synchronized void init(Context context, String string, ENV eNV) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        Config config = Config.getConfig(string, eNV);
        if (config == null) {
            config = new Config.Builder().setAppkey(string).setEnv(eNV).build();
        }
        SessionCenter.init(context, config);
    }

    public static synchronized void init(Context object, Config config) {
        if (object == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        if (config == null) {
            ALog.e(TAG, "paramter config is null!", null, new Object[0]);
            throw new NullPointerException("init failed. config is null");
        }
        SessionCenter.init(object);
        if (!a.containsKey(config)) {
            object = new SessionCenter(config);
            a.put(config, (SessionCenter)object);
        }
    }

    private SessionCenter(Config object) {
        this.b = GlobalAppRuntimeInfo.getContext();
        this.d = object;
        this.c = ((Config)object).getAppkey();
        this.i.a();
        this.h = new AccsSessionManager(this);
        if (!((Config)object).getAppkey().equals("[default]")) {
            ISecurity iSecurity = ((Config)object).getSecurity();
            object = ((Config)object).getAppkey();
            anet.channel.strategy.dispatch.a.a(new anet.channel.c(this, (String)object, iSecurity));
        }
    }

    @Deprecated
    public synchronized void switchEnv(ENV eNV) {
        SessionCenter.switchEnvironment(eNV);
    }

    public static synchronized void switchEnvironment(ENV eNV) {
        try {
            if (GlobalAppRuntimeInfo.getEnv() != eNV) {
                ALog.i(TAG, "switch env", null, new Object[]{"old", GlobalAppRuntimeInfo.getEnv(), "new", eNV});
                GlobalAppRuntimeInfo.setEnv(eNV);
                StrategyCenter.getInstance().switchEnv();
                SpdyAgent.getInstance(GlobalAppRuntimeInfo.getContext(), SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION).switchAccsServer(eNV == ENV.TEST ? 0 : 1);
            }
            Iterator<Map.Entry<Config, SessionCenter>> iterator = a.entrySet().iterator();
            while (iterator.hasNext()) {
                SessionCenter sessionCenter = iterator.next().getValue();
                if (sessionCenter.d.getEnv() == eNV) continue;
                ALog.i(TAG, "remove instance", sessionCenter.c, new Object[]{"ENVIRONMENT", sessionCenter.d.getEnv()});
                sessionCenter.h.forceCloseSession(false);
                sessionCenter.i.b();
                iterator.remove();
            }
            return;
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "switch env error.", null, throwable, new Object[0]);
            return;
        }
    }

    public static synchronized SessionCenter getInstance(String object) {
        if ((object = Config.getConfigByTag((String)object)) == null) {
            throw new RuntimeException("tag not exist!");
        }
        return SessionCenter.getInstance((Config)object);
    }

    public static synchronized SessionCenter getInstance(Config config) {
        Object object;
        if (config == null) {
            throw new NullPointerException("config is null!");
        }
        if (!j && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        if ((object = a.get(config)) == null) {
            object = new SessionCenter(config);
            a.put(config, (SessionCenter)object);
        }
        return object;
    }

    @Deprecated
    public static synchronized SessionCenter getInstance() {
        Object object;
        if (!j && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        object = null;
        for (Map.Entry<Config, SessionCenter> entry : a.entrySet()) {
            object = entry.getValue();
            if (entry.getKey() == Config.DEFAULT_CONFIG) continue;
            return object;
        }
        return object;
    }

    public Session getThrowsException(String string, long l2) throws Exception {
        return this.a(HttpUrl.parse(string), anet.channel.entity.c.c, l2, null);
    }

    @Deprecated
    public Session getThrowsException(String string, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        return this.a(HttpUrl.parse(string), typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2, null);
    }

    public Session getThrowsException(HttpUrl httpUrl, int n2, long l2) throws Exception {
        return this.a(httpUrl, n2, l2, null);
    }

    @Deprecated
    public Session getThrowsException(HttpUrl httpUrl, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        return this.a(httpUrl, typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2, null);
    }

    public Session get(String string, long l2) {
        return this.get(HttpUrl.parse(string), anet.channel.entity.c.c, l2);
    }

    @Deprecated
    public Session get(String string, ConnType.TypeLevel typeLevel, long l2) {
        return this.get(HttpUrl.parse(string), typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2);
    }

    @Deprecated
    public Session get(HttpUrl httpUrl, ConnType.TypeLevel typeLevel, long l2) {
        return this.get(httpUrl, typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2);
    }

    public Session get(HttpUrl httpUrl, int n2, long l2) {
        Session session = null;
        try {
            session = this.a(httpUrl, n2, l2, null);
        }
        catch (InvalidParameterException invalidParameterException) {
            ALog.e(TAG, "[Get]param url is invalid", this.c, invalidParameterException, "url", httpUrl);
        }
        catch (TimeoutException timeoutException) {
            ALog.e(TAG, "[Get]timeout exception", this.c, timeoutException, "url", httpUrl.urlString());
        }
        catch (ConnectException connectException) {
            ALog.e(TAG, "[Get]connect exception", this.c, "errMsg", connectException.getMessage(), "url", httpUrl.urlString());
        }
        catch (NoAvailStrategyException noAvailStrategyException) {
            ALog.i(TAG, "[Get]" + noAvailStrategyException.getMessage(), this.c, null, "url", httpUrl.urlString());
        }
        catch (Exception exception) {
            ALog.e(TAG, "[Get]" + exception.getMessage(), this.c, null, "url", httpUrl.urlString());
        }
        return session;
    }

    public void asyncGet(HttpUrl object, int n2, long l2, SessionGetCallback sessionGetCallback) {
        if (sessionGetCallback == null) {
            throw new NullPointerException("cb is null");
        }
        if (l2 <= 0L) {
            throw new InvalidParameterException("timeout must > 0");
        }
        try {
            object = this.a((HttpUrl)object, n2, l2, sessionGetCallback);
            if (object != null) {
                sessionGetCallback.onSessionGetSuccess((Session)object);
            }
            return;
        }
        catch (Exception exception) {
            sessionGetCallback.onSessionGetFail();
            return;
        }
    }

    public void registerSessionInfo(SessionInfo sessionInfo) {
        this.g.a(sessionInfo);
        if (sessionInfo.isKeepAlive) {
            this.h.checkAndStartSession();
        }
    }

    public void unregisterSessionInfo(String object) {
        if ((object = this.g.a((String)object)) != null && ((SessionInfo)object).isKeepAlive) {
            this.h.checkAndStartSession();
        }
    }

    public void registerPublicKey(String string, int n2) {
        this.g.a(string, n2);
    }

    public static void checkAndStartAccsSession() {
        Iterator<SessionCenter> iterator = a.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().h.checkAndStartSession();
        }
    }

    public void forceRecreateAccsSession() {
        this.h.forceCloseSession(true);
    }

    private SessionRequest a(HttpUrl object) {
        String string = StrategyCenter.getInstance().getCNameByHost(((HttpUrl)object).host());
        string = string == null ? ((HttpUrl)object).host() : string;
        String string2 = ((HttpUrl)object).scheme();
        if (!((HttpUrl)object).isSchemeLocked()) {
            string2 = StrategyCenter.getInstance().getSchemeByHost(string, string2);
        }
        object = StringUtils.concatString(string2, "://", string);
        return this.a((String)object);
    }

    protected Session a(HttpUrl object, int n2, long l2, SessionGetCallback sessionGetCallback) throws Exception {
        if (!j) {
            ALog.e(TAG, "getInternal not inited!", this.c, new Object[0]);
            throw new IllegalStateException("getInternal not inited");
        }
        if (object == null) {
            throw new InvalidParameterException("httpUrl is null");
        }
        ALog.d(TAG, "getInternal", this.c, "u", ((HttpUrl)object).urlString(), "sessionType", n2 == anet.channel.entity.c.a ? "LongLink" : "ShortLink", "timeout", l2);
        SessionRequest sessionRequest = this.a((HttpUrl)object);
        Session session = this.e.a(sessionRequest, n2);
        if (session != null) {
            ALog.d(TAG, "get internal hit cache session", this.c, "session", session);
        } else {
            if (this.d == Config.DEFAULT_CONFIG && n2 != anet.channel.entity.c.b) {
                if (sessionGetCallback != null) {
                    sessionGetCallback.onSessionGetFail();
                }
                return null;
            }
            if (GlobalAppRuntimeInfo.isAppBackground() && n2 == anet.channel.entity.c.a && AwcnConfig.isAccsSessionCreateForbiddenInBg() && (object = this.g.b(((HttpUrl)object).host())) != null && ((SessionInfo)object).isAccs) {
                ALog.w(TAG, "app background, forbid to create accs session", this.c, new Object[0]);
                throw new ConnectException("accs session connecting forbidden in background");
            }
            sessionRequest.a(this.b, n2, anet.channel.util.j.a(this.c), sessionGetCallback, l2);
            if (sessionGetCallback == null && l2 > 0L && (n2 == anet.channel.entity.c.c || sessionRequest.b() == n2)) {
                sessionRequest.a(l2);
                session = this.e.a(sessionRequest, n2);
                if (session == null) {
                    throw new ConnectException("session connecting failed or timeout");
                }
            }
        }
        return session;
    }

    @Deprecated
    public void enterBackground() {
        AppLifecycle.onBackground();
    }

    @Deprecated
    public void enterForeground() {
        AppLifecycle.onForeground();
    }

    private void a(l.d bArray) {
        try {
            bArray = bArray.b;
            for (int i2 = 0; i2 < bArray.length; ++i2) {
                l.b b2 = bArray[i2];
                if (b2.k) {
                    this.b(b2);
                }
                if (b2.e == null) continue;
                this.a(b2);
            }
            return;
        }
        catch (Exception exception) {
            ALog.e(TAG, "checkStrategy failed", this.c, exception, new Object[0]);
            return;
        }
    }

    private void a(l.b b2) {
        for (Session session : this.e.a(this.a(StringUtils.buildKey(b2.c, b2.a)))) {
            if (StringUtils.isStringEqual(session.l, b2.e)) continue;
            ALog.i(TAG, "unit change", session.p, "session unit", session.l, "unit", b2.e);
            session.close(true);
        }
    }

    private void b(l.b object) {
        ALog.i(TAG, "find effectNow", this.c, "host", ((l.b)object).a);
        Object[] objectArray = ((l.b)object).h;
        Object[] objectArray2 = ((l.b)object).f;
        for (Session session : this.e.a(this.a(StringUtils.buildKey(((l.b)object).c, ((l.b)object).a)))) {
            int n2;
            if (session.getConnType().isHttpType()) continue;
            int n3 = 0;
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                if (!session.getIp().equals(objectArray2[n2])) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(TAG, "ip not match", session.p, "session ip", session.getIp(), "ips", Arrays.toString(objectArray2));
                }
                session.close(true);
                continue;
            }
            n2 = 0;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (session.getPort() != objectArray[n3].a || !session.getConnType().equals(ConnType.valueOf(ConnProtocol.valueOf(objectArray[n3])))) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "aisle not match", session.p, "port", session.getPort(), "connType", session.getConnType(), "aisle", Arrays.toString(objectArray));
            }
            session.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionRequest a(String string) {
        SessionRequest sessionRequest;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        LruCache<String, SessionRequest> lruCache = this.f;
        synchronized (lruCache) {
            sessionRequest = (SessionRequest)this.f.get((Object)string);
            if (sessionRequest == null) {
                sessionRequest = new SessionRequest(string, this);
                this.f.put((Object)string, (Object)sessionRequest);
            }
        }
        return sessionRequest;
    }

    private class a
    implements NetworkStatusHelper.INetworkStatusChangeListener,
    IStrategyListener,
    AppLifecycle.AppLifecycleListener {
        boolean a = false;

        private a() {
        }

        void a() {
            AppLifecycle.registerLifecycleListener(this);
            NetworkStatusHelper.addStatusChangeListener(this);
            StrategyCenter.getInstance().registerListener(this);
        }

        void b() {
            StrategyCenter.getInstance().unregisterListener(this);
            AppLifecycle.unregisterLifecycleListener(this);
            NetworkStatusHelper.removeStatusChangeListener(this);
        }

        @Override
        public void onNetworkStatusChanged(NetworkStatusHelper.NetworkStatus object) {
            ALog.e(SessionCenter.TAG, "onNetworkStatusChanged.", SessionCenter.this.c, "networkStatus", object);
            object = SessionCenter.this.e.a();
            if (!object.isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    SessionRequest sessionRequest = (SessionRequest)object.next();
                    ALog.d(SessionCenter.TAG, "network change, try recreate session", SessionCenter.this.c, new Object[0]);
                    sessionRequest.a((String)null);
                }
            }
            SessionCenter.this.h.checkAndStartSession();
        }

        @Override
        public void onStrategyUpdated(l.d d2) {
            SessionCenter.this.a(d2);
            SessionCenter.this.h.checkAndStartSession();
        }

        @Override
        public void forground() {
            ALog.i(SessionCenter.TAG, "[forground]", SessionCenter.this.c, new Object[0]);
            if (SessionCenter.this.b == null) {
                return;
            }
            if (this.a) {
                return;
            }
            this.a = true;
            if (!j) {
                ALog.e(SessionCenter.TAG, "forground not inited!", SessionCenter.this.c, new Object[0]);
                return;
            }
            try {
                try {
                    if (AppLifecycle.lastEnterBackgroundTime != 0L && System.currentTimeMillis() - AppLifecycle.lastEnterBackgroundTime > 60000L) {
                        SessionCenter.this.h.forceCloseSession(true);
                    } else {
                        SessionCenter.this.h.checkAndStartSession();
                    }
                    return;
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    this.a = false;
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        @Override
        public void background() {
            ALog.i(SessionCenter.TAG, "[background]", SessionCenter.this.c, new Object[0]);
            if (!j) {
                ALog.e(SessionCenter.TAG, "background not inited!", SessionCenter.this.c, new Object[0]);
                return;
            }
            try {
                StrategyCenter.getInstance().saveData();
                if ("OPPO".equalsIgnoreCase(Build.BRAND)) {
                    ALog.i(SessionCenter.TAG, "close session for OPPO", SessionCenter.this.c, new Object[0]);
                    SessionCenter.this.h.forceCloseSession(false);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        /* synthetic */ a(anet.channel.c c2) {
            this();
        }
    }
}

