/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.push.common.global.ComponentEnum;
import com.alibaba.sdk.android.push.common.global.a;

public class AppInfoUtil {
    private static final String TAG = "MPS:AppInfoUtil";
    public static final int CHANNEL_SERVICE_PROCESS = 1;
    private static AmsLogger sLogger = AmsLogger.getLogger("MPS:AppInfoUtil");

    public static String getProcessName(Context object, int n2) {
        String string = "";
        try {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses()) {
                try {
                    if (runningAppProcessInfo.pid != n2) continue;
                    string = runningAppProcessInfo.processName;
                }
                catch (Exception exception) {
                    sLogger.e("\u83b7\u53d6\u8fdb\u7a0b\u540d\u5931\u8d25");
                }
            }
        }
        catch (Throwable throwable) {
            sLogger.e("getProcessName:get process name failed.", throwable);
        }
        return string;
    }

    public static boolean isMainProcess(Context object) {
        String string = object.getPackageName();
        boolean bl = false;
        try {
            string = object.getPackageManager().getPackageInfo((String)string, (int)0).applicationInfo.processName;
            object = AppInfoUtil.getProcessName(object, Process.myPid());
            if (!string.equals("") && string.equalsIgnoreCase((String)object)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            sLogger.e("isMainProcess:get process name failed.", throwable);
        }
        return bl;
    }

    public static boolean isChannelProcess(Context object) {
        boolean bl = false;
        try {
            Object object2 = ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses();
            object = object.getPackageName() + a.g();
            int n2 = Process.myPid();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object2.next();
                if (runningAppProcessInfo.pid != n2 || !((String)object).equals(runningAppProcessInfo.processName)) continue;
                bl = true;
                break;
            }
        }
        catch (Throwable throwable) {
            sLogger.e("isChannelProcess:get process name failed.", throwable);
        }
        return bl;
    }

    public static boolean isComponentExists(Context object, String string, String string2) {
        if (object != null) {
            PackageManager packageManager = object.getPackageManager();
            object = object.getPackageName();
            object = new ComponentName((String)object, string);
            boolean bl = true;
            try {
                if (string2.equals("service")) {
                    packageManager.getServiceInfo((ComponentName)object, 4);
                } else if (string2.equals("activity")) {
                    packageManager.getActivityInfo((ComponentName)object, 1);
                } else if (string2.equals("receiver")) {
                    packageManager.getReceiverInfo((ComponentName)object, 2);
                } else {
                    bl = false;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                sLogger.e("component:" + string + " not found!");
                bl = false;
            }
            return bl;
        }
        sLogger.e("Get component info failed: context null");
        return false;
    }

    public static boolean isPermissionGranted(Context context, String string) {
        if (context != null) {
            boolean bl = false;
            try {
                PackageManager packageManager = context.getPackageManager();
                bl = 0 == packageManager.checkPermission(string, context.getPackageName());
            }
            catch (Throwable throwable) {
                sLogger.e("isPermissionGranted:Get permission info failed.", throwable);
            }
            return bl;
        }
        sLogger.e("Get permission info failed: context null");
        return false;
    }

    public static String getAppVersionName(Context context) {
        if (context != null) {
            PackageManager packageManager = context.getPackageManager();
            String string = null;
            try {
                string = packageManager.getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                sLogger.e("version name not found!", nameNotFoundException);
            }
            return string;
        }
        sLogger.e("Get app version name failed: context null");
        return null;
    }

    public static String getChannelServiceData(Context object, int n2) {
        try {
            PackageManager packageManager = object.getPackageManager();
            object = object.getPackageName();
            object = new ComponentName((String)object, ComponentEnum.CHANNEL_SERVICE.getServiceName());
            object = packageManager.getServiceInfo((ComponentName)object, 4);
            switch (n2) {
                case 1: {
                    object = object.processName;
                    break;
                }
                default: {
                    object = null;
                }
            }
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            sLogger.e("Meta data name " + ComponentEnum.CHANNEL_SERVICE.getServiceName() + " not found!");
            return null;
        }
    }
}

