/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.statist;

import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.entity.ConnType;
import anet.channel.statist.Dimension;
import anet.channel.statist.Measure;
import anet.channel.statist.Monitor;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

@Monitor(module="networkPrefer", monitorPoint="network")
public class RequestStatistic
extends StatObject {
    @Dimension
    public volatile String host;
    @Dimension
    public volatile String ip;
    @Dimension
    public volatile int port;
    @Dimension
    public volatile boolean isSSL;
    @Dimension
    public volatile int ipRefer = 0;
    @Dimension
    public volatile int ipType = 1;
    @Dimension
    public volatile boolean isProxy;
    @Dimension
    public volatile String proxyType = "";
    @Dimension
    public volatile String netType = "";
    @Dimension
    public volatile String bssid = null;
    @Dimension
    public volatile String protocolType;
    @Dimension
    public volatile boolean isDNS = false;
    @Dimension
    public volatile int retryTimes;
    @Dimension
    public volatile String bizId;
    @Dimension
    public volatile String f_refer;
    @Dimension
    public volatile int ret;
    @Dimension(name="errorCode")
    public volatile int statusCode = 0;
    @Dimension(name="errorMsg")
    public volatile String msg = "";
    @Dimension
    public volatile String contentEncoding = null;
    @Dimension
    public volatile String contentType = null;
    @Dimension
    public volatile int degraded = 0;
    @Dimension
    public volatile String isBg = "";
    @Dimension
    public volatile StringBuilder errorTrace = null;
    @Dimension(name="URL")
    public volatile String url;
    @Dimension
    public double lng = 90000.0;
    @Dimension
    public double lat = 90000.0;
    @Dimension
    public float accuracy = -1.0f;
    @Dimension
    public int roaming = 0;
    @Dimension
    public String mnc = "0";
    @Dimension
    public String unit;
    @Dimension
    public JSONObject extra = null;
    @Measure
    public volatile long reqHeadInflateSize = 0L;
    @Measure
    public volatile long reqBodyInflateSize = 0L;
    @Measure
    public volatile long reqHeadDeflateSize = 0L;
    @Measure
    public volatile long reqBodyDeflateSize = 0L;
    @Measure
    public volatile long rspHeadDeflateSize = 0L;
    @Measure
    public volatile long rspBodyDeflateSize = 0L;
    @Measure
    public volatile long rspHeadInflateSize = 0L;
    @Measure
    public volatile long rspBodyInflateSize = 0L;
    @Measure
    public volatile long retryCostTime = 0L;
    @Measure
    public volatile long connWaitTime = 0L;
    @Measure
    public volatile long sendBeforeTime = 0L;
    @Measure
    public volatile long processTime = 0L;
    @Measure
    public volatile long sendDataTime = 0L;
    @Measure
    public volatile long firstDataTime = 0L;
    @Measure
    public volatile long recDataTime = 0L;
    @Measure
    public volatile long serverRT = 0L;
    @Measure
    public volatile long cacheTime = 0L;
    @Measure
    public volatile long lastProcessTime = 0L;
    @Measure
    public volatile long callbackTime = 0L;
    @Measure(max=60000.0)
    public volatile long oneWayTime = 0L;
    @Measure
    public volatile long sendDataSize = 0L;
    @Measure
    public volatile long recDataSize = 0L;
    @Deprecated
    public volatile long waitingTime = 0L;
    public final AtomicBoolean isDone = new AtomicBoolean(false);
    public volatile boolean spdyRequestSend = false;
    public volatile long start = 0L;
    public volatile long reqStart = 0L;
    public volatile long sendStart = 0L;
    public volatile long sendEnd = 0L;
    public volatile long rspStart = 0L;
    public volatile long rspEnd = 0L;
    public volatile long contentLength = 0L;
    public volatile int tnetErrorCode = 0;

    public RequestStatistic(String string, String string2) {
        this.host = string;
        this.proxyType = NetworkStatusHelper.getProxyType();
        this.isProxy = !this.proxyType.isEmpty();
        this.netType = NetworkStatusHelper.getNetworkSubType();
        this.bssid = NetworkStatusHelper.getWifiBSSID();
        this.isBg = GlobalAppRuntimeInfo.isAppBackground() ? "bg" : "fg";
        this.roaming = NetworkStatusHelper.isRoaming() ? 1 : 0;
        this.mnc = NetworkStatusHelper.getSimOp();
        this.bizId = string2;
    }

    public void setConnType(ConnType connType) {
        this.isSSL = connType.isSSL();
        this.protocolType = connType.toString();
    }

    public void setIPAndPort(String string, int n2) {
        this.ip = string;
        this.port = n2;
        if (string != null) {
            this.isDNS = true;
        }
        if (this.retryTimes == 0 && string != null) {
            this.putExtra("firstIp", string);
        }
    }

    public void setIpInfo(int n2, int n3) {
        this.ipRefer = n2;
        this.ipType = n3;
    }

    public void appendErrorTrace(String string) {
        if (this.errorTrace == null) {
            this.errorTrace = new StringBuilder();
        }
        if (this.errorTrace.length() != 0) {
            this.errorTrace.append(",");
        }
        this.errorTrace.append(string).append("=").append(System.currentTimeMillis() - this.reqStart);
    }

    public void recordRedirect(int n2, String string) {
        this.url = string;
        this.appendErrorTrace(String.valueOf(n2));
        long l2 = System.currentTimeMillis();
        this.retryCostTime += l2 - this.start;
        this.start = l2;
    }

    public void putExtra(String string, Object object) {
        try {
            if (this.extra == null) {
                this.extra = new JSONObject();
            }
            this.extra.put(string, object);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("[RequestStatistic]ret=").append(this.ret);
        stringBuilder.append(",statusCode=").append(this.statusCode);
        stringBuilder.append(",msg=").append(this.msg);
        stringBuilder.append(",host=").append(this.host);
        stringBuilder.append(",ip=").append(this.ip);
        stringBuilder.append(",port=").append(this.port);
        stringBuilder.append(",protocolType=").append(this.protocolType);
        stringBuilder.append(",retryTime=").append(this.retryTimes);
        stringBuilder.append(",retryCostTime=").append(this.retryCostTime);
        stringBuilder.append(",processTime=").append(this.processTime);
        stringBuilder.append(",connWaitTime=").append(this.connWaitTime);
        stringBuilder.append(",cacheTime=").append(this.cacheTime);
        stringBuilder.append(",sendDataTime=").append(this.sendDataTime);
        stringBuilder.append(",firstDataTime=").append(this.firstDataTime);
        stringBuilder.append(",recDataTime=").append(this.recDataTime);
        stringBuilder.append(",lastProcessTime=").append(this.lastProcessTime);
        stringBuilder.append(",oneWayTime=").append(this.oneWayTime);
        stringBuilder.append(",callbackTime=").append(this.callbackTime);
        stringBuilder.append(",serverRT=").append(this.serverRT);
        stringBuilder.append(",sendSize=").append(this.sendDataSize);
        stringBuilder.append(",recDataSize=").append(this.recDataSize);
        stringBuilder.append(",originalDataSize=").append(this.rspBodyDeflateSize);
        if (this.extra != null) {
            stringBuilder.append(",extra=").append(this.extra.toString());
        }
        stringBuilder.append(",url=").append(this.url);
        return stringBuilder.toString();
    }

    @Override
    public boolean beforeCommit() {
        return this.statusCode != -200;
    }
}

