/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.base;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.base.AccsDataListener;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UTMini;
import com.taobao.accs.utl.b;
import java.util.HashMap;
import java.util.Map;

public abstract class AccsAbstractDataListener
implements AccsDataListener {
    private static final String TAG = "AccsAbstractDataListener";

    @Override
    public void onConnected(TaoBaseService.ConnectInfo connectInfo) {
    }

    @Override
    public void onDisconnected(TaoBaseService.ConnectInfo connectInfo) {
    }

    @Override
    public void onAntiBrush(boolean bl, TaoBaseService.ExtraInfo extraInfo) {
    }

    public static int onReceiveData(Context context, Intent intent, AccsDataListener accsDataListener) {
        if (accsDataListener == null || context == null) {
            ALog.e(TAG, "onReceiveData listener or context null", new Object[0]);
            return 2;
        }
        if (intent != null) {
            String string = "";
            try {
                int n2 = intent.getIntExtra("command", -1);
                int n3 = intent.getIntExtra("errorCode", 0);
                String string2 = intent.getStringExtra("userInfo");
                String string3 = intent.getStringExtra("dataId");
                string = intent.getStringExtra("serviceId");
                if (ALog.isPrintLog(ALog.Level.I)) {
                    ALog.i(TAG, "onReceiveData dataId:" + string3 + " serviceId:" + string + " command:" + n2, new Object[0]);
                }
                if (n2 > 0) {
                    UTMini.getInstance().commitEvent(66001, "MsgToBuss5", "commandId=" + n2, "serviceId=" + string + " dataId=" + string3, 221);
                    b.a("accs", "to_buss", "3commandId=" + n2 + "serviceId=" + string, 0.0);
                    switch (n2) {
                        case 5: {
                            accsDataListener.onBind(string, n3, AccsAbstractDataListener.getExtraInfo(intent));
                            break;
                        }
                        case 6: {
                            accsDataListener.onUnbind(string, n3, AccsAbstractDataListener.getExtraInfo(intent));
                            break;
                        }
                        case 101: {
                            byte[] byArray = intent.getByteArrayExtra("data");
                            n2 = intent.getBooleanExtra("bizAck", false) ? 1 : 0;
                            if (byArray != null) {
                                string3 = intent.getStringExtra("dataId");
                                if (ALog.isPrintLog(ALog.Level.D)) {
                                    ALog.d(TAG, "COMMAND_RECEIVE_DATA onData dataId:" + string3 + " serviceId:" + string, new Object[0]);
                                }
                                TaoBaseService.ExtraInfo extraInfo = AccsAbstractDataListener.getExtraInfo(intent);
                                if (n2 != 0) {
                                    ALog.i(TAG, "try to send biz ack dataId " + string3, new Object[0]);
                                    AccsAbstractDataListener.sendBusinessAck(context, intent, string3, extraInfo.extHeader);
                                }
                                accsDataListener.onData(string, string2, string3, byArray, extraInfo);
                                break;
                            }
                            ALog.e(TAG, "COMMAND_RECEIVE_DATA msg null", new Object[0]);
                            b.a("accs", "send_fail", string, "1", "COMMAND_RECEIVE_DATA msg null");
                            break;
                        }
                        case 100: {
                            string3 = intent.getStringExtra("dataId");
                            if (TextUtils.equals((CharSequence)"res", (CharSequence)intent.getStringExtra("send_type"))) {
                                byte[] byArray = intent.getByteArrayExtra("data");
                                accsDataListener.onResponse(string, string3, n3, byArray, AccsAbstractDataListener.getExtraInfo(intent));
                                break;
                            }
                            accsDataListener.onSendData(string, string3, n3, AccsAbstractDataListener.getExtraInfo(intent));
                            break;
                        }
                        case 104: {
                            boolean bl = intent.getBooleanExtra("anti_brush_ret", false);
                            ALog.e(TAG, "anti brush result:" + bl, new Object[0]);
                            accsDataListener.onAntiBrush(bl, null);
                            break;
                        }
                        case 103: {
                            boolean bl = intent.getBooleanExtra("connect_avail", false);
                            String string4 = intent.getStringExtra("host");
                            string2 = intent.getStringExtra("errorDetail");
                            boolean bl2 = intent.getBooleanExtra("type_inapp", false);
                            boolean bl3 = intent.getBooleanExtra("is_center_host", false);
                            if (!TextUtils.isEmpty((CharSequence)string4)) {
                                if (bl) {
                                    accsDataListener.onConnected(new TaoBaseService.ConnectInfo(string4, bl2, bl3));
                                    break;
                                }
                                accsDataListener.onDisconnected(new TaoBaseService.ConnectInfo(string4, bl2, bl3, n3, string2));
                            } else {
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                b.a("accs", "send_fail", string, "1", "callback error" + exception2.toString());
                ALog.e(TAG, "onReceiveData", exception2, new Object[0]);
            }
        }
        return 2;
    }

    private static Map<TaoBaseService.ExtHeaderType, String> getExtHeader(Intent intent) {
        HashMap<TaoBaseService.ExtHeaderType, String> hashMap = null;
        try {
            if (intent != null) {
                for (TaoBaseService.ExtHeaderType extHeaderType : TaoBaseService.ExtHeaderType.values()) {
                    String string = intent.getStringExtra(extHeaderType.toString());
                    if (TextUtils.isEmpty((CharSequence)string)) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<TaoBaseService.ExtHeaderType, String>();
                    }
                    hashMap.put(extHeaderType, string);
                }
                return hashMap;
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, exception.toString(), new Object[0]);
        }
        return hashMap;
    }

    private static TaoBaseService.ExtraInfo getExtraInfo(Intent intent) {
        Map<TaoBaseService.ExtHeaderType, String> map = AccsAbstractDataListener.getExtHeader(intent);
        String string = intent.getStringExtra("packageName");
        String string2 = intent.getStringExtra("host");
        int n2 = intent.getIntExtra("conn_type", 0);
        TaoBaseService.ExtraInfo extraInfo = new TaoBaseService.ExtraInfo();
        new TaoBaseService.ExtraInfo().connType = n2;
        if (map != null || !TextUtils.isEmpty((CharSequence)string) || !TextUtils.isEmpty((CharSequence)string2)) {
            extraInfo.extHeader = map;
            extraInfo.fromPackage = string;
            extraInfo.fromHost = string2;
        }
        return extraInfo;
    }

    private static void sendBusinessAck(Context object, Intent intent, String string, Map<TaoBaseService.ExtHeaderType, String> map) {
        try {
            ALog.i(TAG, "sendBusinessAck", "dataId", string);
            if (intent != null) {
                String string2 = intent.getStringExtra("host");
                String string3 = intent.getStringExtra("source");
                String string4 = intent.getStringExtra("target");
                String string5 = intent.getStringExtra("appKey");
                String string6 = intent.getStringExtra("configTag");
                short s2 = intent.getShortExtra("flags", (short)0);
                if ((object = ACCSManager.getAccsInstance((Context)object, string5, string6)) != null) {
                    object.sendBusinessAck(string4, string3, string, s2, string2, map);
                    b.a("accs", "bizAckSucc", "", 0.0);
                    return;
                }
                b.a("accs", "bizAckFail", "no acsmgr", 0.0);
            }
            return;
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "sendBusinessAck", throwable, new Object[0]);
            b.a("accs", "bizAckFail", throwable.toString(), 0.0);
            return;
        }
    }
}

