/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.rogers.mix;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.fshows.android.rogers.mix.MixMessageProvider;
import com.fshows.android.rogers.mix.MixPushIntentService;
import com.fshows.android.rogers.mix.MixPushManager;
import com.fshows.android.rogers.mix.MixPushMessage;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class MixPushClient {
    private static final String TAG = MixPushClient.class.getSimpleName();
    private static Map<String, MixPushManager> sPushManagerMap = new LinkedHashMap<String, MixPushManager>();
    private static Map<Integer, Class<? extends MixPushIntentService>> mMixPushIntentServiceMap = Maps.newLinkedHashMap();
    private static String sReceiverPermission = null;

    private MixPushClient() {
    }

    public static void setPushIntentService(int sysType, Class<? extends MixPushIntentService> mixPushIntentServiceClass) {
        mMixPushIntentServiceMap.put(sysType, mixPushIntentServiceClass);
    }

    public static synchronized void addPushManager(Context context, MixPushManager pushAdapter) {
        sReceiverPermission = context.getPackageName() + ".permission.MIXPUSH_RECEIVE";
        sPushManagerMap.put(pushAdapter.getPushName(), pushAdapter);
        pushAdapter.setMessageProvider(new MixMessageProvider(){

            @Override
            public void onReceivePassThroughMessage(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.RECEIVE_THROUGH_MESSAGE");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u6536\u5230\u900f\u4f20\u6d88\u606f ->  "));
                Class sMixPushIntentServiceClass = (Class)mMixPushIntentServiceMap.get(message.getSource());
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }

            @Override
            public void onNotificationMessageClicked(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.NOTIFICATION_CLICKED");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u901a\u77e5\u680f\u6d88\u606f\u70b9\u51fb -> "));
                Class sMixPushIntentServiceClass = (Class)mMixPushIntentServiceMap.get(message.getSource());
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }

            @Override
            public void onNotificationMessageArrived(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.NOTIFICATION_ARRIVED");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u901a\u77e5\u680f\u6d88\u606f -> "));
                Class sMixPushIntentServiceClass = (Class)mMixPushIntentServiceMap.get(message.getSource());
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }

            @Override
            public void onReceiveClientId(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.CLIENT_ID");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u63a8\u9001id ->" + message.getCid()));
                Class sMixPushIntentServiceClass = (Class)mMixPushIntentServiceMap.get(message.getSource());
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }
        });
        pushAdapter.registerPush(context);
    }

    public static void unRegisterPush(Context context) {
    }
}

