/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.fshows.android.parker.R;
import com.fshows.android.parker.recyclerview.IRefreshHeader;

public class YunRefreshHeader
extends LinearLayout
implements IRefreshHeader {
    private Context mContext;
    private LinearLayout mLoadingRl;
    private AnimationDrawable mRefreshDrawable;
    private int mState = 0;
    private int mHeight;

    public YunRefreshHeader(Context context) {
        this(context, null);
    }

    public YunRefreshHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YunRefreshHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.kaws_refresh_header, (ViewGroup)this);
        this.mLoadingRl = (LinearLayout)this.findViewById(R.id.refresh_container_rl);
        ImageView refreshIv = (ImageView)this.findViewById(R.id.refresh_iv);
        this.mRefreshDrawable = (AnimationDrawable)refreshIv.getDrawable();
        this.measure(-2, -2);
        this.mHeight = this.getMeasuredHeight();
        this.setGravity(1);
        this.setVisibleHeight(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }

    @Override
    public void onMove(float delta) {
        Log.e((String)"xss", (String)("onMore: " + delta));
        int height = (int)delta + this.getVisibleHeight();
        this.setVisibleHeight(height);
        if (this.mState <= 1) {
            if (height > this.mHeight) {
                this.setState(1);
            } else {
                this.setState(0);
            }
        }
    }

    @Override
    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        switch (state) {
            case 0: {
                if (this.mRefreshDrawable == null || !this.mRefreshDrawable.isRunning()) break;
                this.mRefreshDrawable.stop();
                break;
            }
            case 1: {
                if (this.mRefreshDrawable == null || this.mRefreshDrawable.isRunning()) break;
                this.mRefreshDrawable.start();
                break;
            }
        }
        this.mState = state;
    }

    @Override
    public boolean releaseAction() {
        boolean isOnRefresh = false;
        if (this.getVisibleHeight() > this.mHeight && this.mState < 2) {
            this.setState(2);
            isOnRefresh = true;
        }
        int height = 0;
        if (this.mState == 2) {
            height = this.mHeight;
        }
        this.smoothScrollTo(height);
        return isOnRefresh;
    }

    @Override
    public void refreshComplete() {
        this.setState(3);
        new Handler().postDelayed(() -> this.reset(), 500L);
    }

    public void reset() {
        this.smoothScrollTo(0);
        this.setState(0);
    }

    private void smoothScrollTo(int destHeight) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getVisibleHeight(), destHeight});
        animator.setDuration(300L).start();
        animator.addUpdateListener(animation -> this.setVisibleHeight((Integer)animation.getAnimatedValue()));
        animator.start();
    }

    @Override
    public void setVisibleHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 0);
        lp.height = height;
        this.mLoadingRl.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public int getVisibleHeight() {
        return this.mLoadingRl.getHeight();
    }

    @Override
    public int getState() {
        return this.mState;
    }
}

