/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.transformers;

import androidx.annotation.ColorInt;
import androidx.annotation.Px;

public class TransformersOptions {
    public final int columnSpan;
    public final int rowSpan;
    public final int scrollBarWidth;
    public final int scrollBarHeight;
    public final int scrollBarTopMargin;
    public final int scrollBarTrackColor;
    public final int scrollBarThumbColor;
    public final float scrollBarRadius;

    private TransformersOptions(Builder builder) {
        this.columnSpan = builder.columnSpan;
        this.rowSpan = builder.rowSpan;
        this.scrollBarWidth = builder.scrollBarWidth;
        this.scrollBarHeight = builder.scrollBarHeight;
        this.scrollBarTopMargin = builder.scrollBarTopMargin;
        this.scrollBarTrackColor = builder.scrollBarTrackColor;
        this.scrollBarThumbColor = builder.scrollBarThumbColor;
        this.scrollBarRadius = builder.scrollBarRadius;
    }

    public static class Builder {
        private int columnSpan;
        private int rowSpan;
        private int scrollBarWidth;
        private int scrollBarHeight;
        private int scrollBarTopMargin;
        private int scrollBarTrackColor;
        private int scrollBarThumbColor;
        private float scrollBarRadius = -1.0f;

        public Builder scrollBarRadius(@Px float radius) {
            this.scrollBarRadius = radius;
            return this;
        }

        public Builder scrollBarTrackColor(@ColorInt int color2) {
            this.scrollBarTrackColor = color2;
            return this;
        }

        public Builder scrollBarThumbColor(@ColorInt int color2) {
            this.scrollBarThumbColor = color2;
            return this;
        }

        public Builder scrollBarTopMargin(@Px int topMargin) {
            this.scrollBarTopMargin = topMargin;
            return this;
        }

        public Builder scrollBarWidth(@Px int width) {
            this.scrollBarWidth = width;
            return this;
        }

        public Builder scrollBarHeight(@Px int height) {
            this.scrollBarHeight = height;
            return this;
        }

        public Builder columnSpan(int columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }

        public Builder rowSpan(int rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }

        public TransformersOptions build() {
            return new TransformersOptions(this);
        }
    }
}

