/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.navigation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.Pools;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.PointerIconCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.fshows.android.parker.R;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.tabs.TabItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

@ViewPager.DecorView
public class FsTabLayout
extends HorizontalScrollView {
    private static final Pools.Pool<Tab> tabPool = new Pools.SynchronizedPool(16);
    private final ArrayList<Tab> tabs;
    private Tab selectedTab;
    private final RectF tabViewContentBounds;
    private final SlidingTabIndicator slidingTabIndicator;
    int tabPaddingStart;
    int tabPaddingTop;
    int tabPaddingEnd;
    int tabPaddingBottom;
    int tabTextAppearance;
    ColorStateList tabTextColors;
    ColorStateList tabIconTint;
    ColorStateList tabRippleColorStateList;
    @Nullable
    Drawable tabSelectedIndicator;
    PorterDuff.Mode tabIconTintMode;
    float tabTextSize;
    float tabTextMultiLineSize;
    final int tabBackgroundResId;
    int tabMaxWidth;
    private final int requestedTabMinWidth;
    private final int requestedTabMaxWidth;
    private final int scrollableTabMinWidth;
    private int contentInsetStart;
    int tabGravity;
    int tabIndicatorAnimationDuration;
    int tabIndicatorGravity;
    int mode;
    boolean inlineLabel;
    boolean tabIndicatorFullWidth;
    boolean unboundedRipple;
    private BaseOnTabSelectedListener selectedListener;
    private final ArrayList<BaseOnTabSelectedListener> selectedListeners;
    private BaseOnTabSelectedListener currentVpSelectedListener;
    private ValueAnimator scrollAnimator;
    ViewPager viewPager;
    private PagerAdapter pagerAdapter;
    private DataSetObserver pagerAdapterObserver;
    private TabLayoutOnPageChangeListener pageChangeListener;
    private AdapterChangeListener adapterChangeListener;
    private boolean setupViewPagerImplicitly;
    private final Pools.Pool<TabView> tabViewPool;
    private float widthPercent = 1.0f;
    private AnimType slidingAnimType = AnimType.GLUE;
    private AnimType clickAnimType = AnimType.GLUE;

    public FsTabLayout(Context context) {
        this(context, null);
    }

    public FsTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.tabStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    public FsTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.tabs = new ArrayList();
        this.tabViewContentBounds = new RectF();
        this.tabMaxWidth = Integer.MAX_VALUE;
        this.selectedListeners = new ArrayList();
        this.tabViewPool = new Pools.SimplePool(12);
        this.setHorizontalScrollBarEnabled(false);
        this.slidingTabIndicator = new SlidingTabIndicator(context);
        super.addView((View)this.slidingTabIndicator, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        TypedArray a = ThemeEnforcement.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.TabLayout, (int)defStyleAttr, (int)R.style.Widget_Design_TabLayout, (int[])new int[]{R.styleable.TabLayout_tabTextAppearance});
        this.slidingTabIndicator.setSelectedIndicatorHeight(a.getDimensionPixelSize(R.styleable.TabLayout_tabIndicatorHeight, -1));
        this.slidingTabIndicator.setSelectedIndicatorColor(a.getColor(R.styleable.TabLayout_tabIndicatorColor, 0));
        this.setSelectedTabIndicator(MaterialResources.getDrawable((Context)context, (TypedArray)a, (int)R.styleable.TabLayout_tabIndicator));
        this.setSelectedTabIndicatorGravity(a.getInt(R.styleable.TabLayout_tabIndicatorGravity, 0));
        this.setTabIndicatorFullWidth(a.getBoolean(R.styleable.TabLayout_tabIndicatorFullWidth, true));
        this.tabPaddingEnd = this.tabPaddingBottom = a.getDimensionPixelSize(R.styleable.TabLayout_tabPadding, 0);
        this.tabPaddingTop = this.tabPaddingBottom;
        this.tabPaddingStart = this.tabPaddingBottom;
        this.tabPaddingStart = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingStart, this.tabPaddingStart);
        this.tabPaddingTop = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingTop, this.tabPaddingTop);
        this.tabPaddingEnd = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingEnd, this.tabPaddingEnd);
        this.tabPaddingBottom = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingBottom, this.tabPaddingBottom);
        this.tabTextAppearance = a.getResourceId(R.styleable.TabLayout_tabTextAppearance, R.style.TextAppearance_Design_Tab);
        TypedArray ta = context.obtainStyledAttributes(this.tabTextAppearance, R.styleable.TextAppearance);
        try {
            this.tabTextSize = ta.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
            this.tabTextColors = MaterialResources.getColorStateList((Context)context, (TypedArray)ta, (int)R.styleable.TextAppearance_android_textColor);
        }
        finally {
            ta.recycle();
        }
        if (a.hasValue(R.styleable.TabLayout_tabTextColor)) {
            this.tabTextColors = MaterialResources.getColorStateList((Context)context, (TypedArray)a, (int)R.styleable.TabLayout_tabTextColor);
        }
        if (a.hasValue(R.styleable.TabLayout_tabSelectedTextColor)) {
            int selected = a.getColor(R.styleable.TabLayout_tabSelectedTextColor, 0);
            this.tabTextColors = FsTabLayout.createColorStateList(this.tabTextColors.getDefaultColor(), selected);
        }
        this.tabIconTint = MaterialResources.getColorStateList((Context)context, (TypedArray)a, (int)R.styleable.TabLayout_tabIconTint);
        this.tabIconTintMode = ViewUtils.parseTintMode((int)a.getInt(R.styleable.TabLayout_tabIconTintMode, -1), null);
        this.tabRippleColorStateList = MaterialResources.getColorStateList((Context)context, (TypedArray)a, (int)R.styleable.TabLayout_tabRippleColor);
        this.tabIndicatorAnimationDuration = a.getInt(R.styleable.TabLayout_tabIndicatorAnimationDuration, 300);
        this.requestedTabMinWidth = a.getDimensionPixelSize(R.styleable.TabLayout_tabMinWidth, -1);
        this.requestedTabMaxWidth = a.getDimensionPixelSize(R.styleable.TabLayout_tabMaxWidth, -1);
        this.tabBackgroundResId = a.getResourceId(R.styleable.TabLayout_tabBackground, 0);
        this.contentInsetStart = a.getDimensionPixelSize(R.styleable.TabLayout_tabContentStart, 0);
        this.mode = a.getInt(R.styleable.TabLayout_tabMode, 1);
        this.tabGravity = a.getInt(R.styleable.TabLayout_tabGravity, 0);
        this.inlineLabel = a.getBoolean(R.styleable.TabLayout_tabInlineLabel, false);
        this.unboundedRipple = a.getBoolean(R.styleable.TabLayout_tabUnboundedRipple, false);
        a.recycle();
        Resources res = this.getResources();
        this.tabTextMultiLineSize = res.getDimensionPixelSize(R.dimen.design_tab_text_size_2line);
        this.scrollableTabMinWidth = res.getDimensionPixelSize(R.dimen.design_tab_scrollable_min_width);
        this.applyModeAndGravity();
    }

    public void setSelectedTabIndicatorColor(@ColorInt int color2) {
        this.slidingTabIndicator.setSelectedIndicatorColor(color2);
    }

    @Deprecated
    public void setSelectedTabIndicatorHeight(int height) {
        this.slidingTabIndicator.setSelectedIndicatorHeight(height);
    }

    public void setScrollPosition(int position, float positionOffset, boolean updateSelectedText) {
        this.setScrollPosition(position, positionOffset, updateSelectedText, true);
    }

    void setScrollPosition(int position, float positionOffset, boolean updateSelectedText, boolean updateIndicatorPosition) {
        int roundedPosition = Math.round((float)position + positionOffset);
        if (roundedPosition >= 0 && roundedPosition < this.slidingTabIndicator.getChildCount()) {
            if (updateIndicatorPosition) {
                this.slidingTabIndicator.setIndicatorPositionFromTabPosition(position, positionOffset);
            }
            if (this.scrollAnimator != null && this.scrollAnimator.isRunning()) {
                this.scrollAnimator.cancel();
            }
            this.scrollTo(this.calculateScrollXForTab(position, positionOffset), 0);
            if (updateSelectedText) {
                this.setSelectedTabView(roundedPosition);
            }
        }
    }

    public void addTab(@NonNull Tab tab) {
        this.addTab(tab, this.tabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, int position) {
        this.addTab(tab, position, this.tabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, boolean setSelected) {
        this.addTab(tab, this.tabs.size(), setSelected);
    }

    public void addTab(@NonNull Tab tab, int position, boolean setSelected) {
        if (tab.parent != this) {
            throw new IllegalArgumentException("Tab belongs to a different GlueTabLayout.");
        }
        this.configureTab(tab, position);
        this.addTabView(tab);
        if (setSelected) {
            tab.select();
        }
    }

    private void addTabFromItemView(@NonNull TabItem item) {
        Tab tab = this.newTab();
        if (item.text != null) {
            tab.setText(item.text);
        }
        if (item.icon != null) {
            tab.setIcon(item.icon);
        }
        if (item.customLayout != 0) {
            tab.setCustomView(item.customLayout);
        }
        if (!TextUtils.isEmpty((CharSequence)item.getContentDescription())) {
            tab.setContentDescription(item.getContentDescription());
        }
        this.addTab(tab);
    }

    @Deprecated
    public void setOnTabSelectedListener(@Nullable BaseOnTabSelectedListener listener) {
        if (this.selectedListener != null) {
            this.removeOnTabSelectedListener(this.selectedListener);
        }
        this.selectedListener = listener;
        if (listener != null) {
            this.addOnTabSelectedListener(listener);
        }
    }

    public void addOnTabSelectedListener(@NonNull BaseOnTabSelectedListener listener) {
        if (!this.selectedListeners.contains(listener)) {
            this.selectedListeners.add(listener);
        }
    }

    public void removeOnTabSelectedListener(@NonNull BaseOnTabSelectedListener listener) {
        this.selectedListeners.remove(listener);
    }

    public void clearOnTabSelectedListeners() {
        this.selectedListeners.clear();
    }

    @NonNull
    public Tab newTab() {
        Tab tab = this.createTabFromPool();
        tab.parent = this;
        tab.view = this.createTabView(tab);
        return tab;
    }

    protected Tab createTabFromPool() {
        Tab tab = (Tab)tabPool.acquire();
        if (tab == null) {
            tab = new Tab();
        }
        return tab;
    }

    protected boolean releaseFromTabPool(Tab tab) {
        return tabPool.release((Object)tab);
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    @Nullable
    public Tab getTabAt(int index) {
        return index >= 0 && index < this.getTabCount() ? this.tabs.get(index) : null;
    }

    public int getSelectedTabPosition() {
        return this.selectedTab != null ? this.selectedTab.getPosition() : -1;
    }

    public void removeTab(Tab tab) {
        if (tab.parent != this) {
            throw new IllegalArgumentException("Tab does not belong to this GlueTabLayout.");
        }
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        int selectedTabPosition = this.selectedTab != null ? this.selectedTab.getPosition() : 0;
        this.removeTabViewAt(position);
        Tab removedTab = this.tabs.remove(position);
        if (removedTab != null) {
            removedTab.reset();
            this.releaseFromTabPool(removedTab);
        }
        int newTabCount = this.tabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.tabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.tabs.isEmpty() ? null : this.tabs.get(Math.max(0, position - 1)));
        }
    }

    public void removeAllTabs() {
        for (int i = this.slidingTabIndicator.getChildCount() - 1; i >= 0; --i) {
            this.removeTabViewAt(i);
        }
        Iterator<Tab> i = this.tabs.iterator();
        while (i.hasNext()) {
            Tab tab = i.next();
            i.remove();
            tab.reset();
            this.releaseFromTabPool(tab);
        }
        this.selectedTab = null;
    }

    public void setTabMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.applyModeAndGravity();
        }
    }

    public int getTabMode() {
        return this.mode;
    }

    public void setTabGravity(int gravity) {
        if (this.tabGravity != gravity) {
            this.tabGravity = gravity;
            this.applyModeAndGravity();
        }
    }

    public int getTabGravity() {
        return this.tabGravity;
    }

    public void setSelectedTabIndicatorGravity(int indicatorGravity) {
        if (this.tabIndicatorGravity != indicatorGravity) {
            this.tabIndicatorGravity = indicatorGravity;
            ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
        }
    }

    public int getTabIndicatorGravity() {
        return this.tabIndicatorGravity;
    }

    public void setTabIndicatorFullWidth(boolean tabIndicatorFullWidth) {
        this.tabIndicatorFullWidth = tabIndicatorFullWidth;
        ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
    }

    public boolean isTabIndicatorFullWidth() {
        return this.tabIndicatorFullWidth;
    }

    public void setInlineLabel(boolean inline) {
        if (this.inlineLabel != inline) {
            this.inlineLabel = inline;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                if (!(child instanceof TabView)) continue;
                ((TabView)child).updateOrientation();
            }
            this.applyModeAndGravity();
        }
    }

    public void setInlineLabelResource(@BoolRes int inlineResourceId) {
        this.setInlineLabel(this.getResources().getBoolean(inlineResourceId));
    }

    public boolean isInlineLabel() {
        return this.inlineLabel;
    }

    public void setUnboundedRipple(boolean unboundedRipple) {
        if (this.unboundedRipple != unboundedRipple) {
            this.unboundedRipple = unboundedRipple;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                if (!(child instanceof TabView)) continue;
                ((TabView)child).updateBackgroundDrawable(this.getContext());
            }
        }
    }

    public void setUnboundedRippleResource(@BoolRes int unboundedRippleResourceId) {
        this.setUnboundedRipple(this.getResources().getBoolean(unboundedRippleResourceId));
    }

    public boolean hasUnboundedRipple() {
        return this.unboundedRipple;
    }

    public void setTabTextColors(@Nullable ColorStateList textColor) {
        if (this.tabTextColors != textColor) {
            this.tabTextColors = textColor;
            this.updateAllTabs();
        }
    }

    @Nullable
    public ColorStateList getTabTextColors() {
        return this.tabTextColors;
    }

    public void setTabTextColors(int normalColor, int selectedColor) {
        this.setTabTextColors(FsTabLayout.createColorStateList(normalColor, selectedColor));
    }

    public void setTabIconTint(@Nullable ColorStateList iconTint) {
        if (this.tabIconTint != iconTint) {
            this.tabIconTint = iconTint;
            this.updateAllTabs();
        }
    }

    public void setTabIconTintResource(@ColorRes int iconTintResourceId) {
        this.setTabIconTint(AppCompatResources.getColorStateList((Context)this.getContext(), (int)iconTintResourceId));
    }

    @Nullable
    public ColorStateList getTabIconTint() {
        return this.tabIconTint;
    }

    @Nullable
    public ColorStateList getTabRippleColor() {
        return this.tabRippleColorStateList;
    }

    public void setTabRippleColor(@Nullable ColorStateList color2) {
        if (this.tabRippleColorStateList != color2) {
            this.tabRippleColorStateList = color2;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                if (!(child instanceof TabView)) continue;
                ((TabView)child).updateBackgroundDrawable(this.getContext());
            }
        }
    }

    public void setTabRippleColorResource(@ColorRes int tabRippleColorResourceId) {
        this.setTabRippleColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)tabRippleColorResourceId));
    }

    @Nullable
    public Drawable getTabSelectedIndicator() {
        return this.tabSelectedIndicator;
    }

    public void setSelectedTabIndicator(@Nullable Drawable tabSelectedIndicator) {
        if (this.tabSelectedIndicator != tabSelectedIndicator) {
            this.tabSelectedIndicator = tabSelectedIndicator;
            ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
        }
    }

    public void setSelectedTabIndicator(@DrawableRes int tabSelectedIndicatorResourceId) {
        if (tabSelectedIndicatorResourceId != 0) {
            this.setSelectedTabIndicator(AppCompatResources.getDrawable((Context)this.getContext(), (int)tabSelectedIndicatorResourceId));
        } else {
            this.setSelectedTabIndicator(null);
        }
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean autoRefresh) {
        this.setupWithViewPager(viewPager, autoRefresh, false);
    }

    private void setupWithViewPager(@Nullable ViewPager viewPager, boolean autoRefresh, boolean implicitSetup) {
        if (this.viewPager != null) {
            if (this.pageChangeListener != null) {
                this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
            }
            if (this.adapterChangeListener != null) {
                this.viewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.adapterChangeListener);
            }
        }
        if (this.currentVpSelectedListener != null) {
            this.removeOnTabSelectedListener(this.currentVpSelectedListener);
            this.currentVpSelectedListener = null;
        }
        if (viewPager != null) {
            this.viewPager = viewPager;
            if (this.pageChangeListener == null) {
                this.pageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            this.pageChangeListener.reset();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
            this.currentVpSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.currentVpSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter, autoRefresh);
            }
            if (this.adapterChangeListener == null) {
                this.adapterChangeListener = new AdapterChangeListener();
            }
            this.adapterChangeListener.setAutoRefresh(autoRefresh);
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.adapterChangeListener);
            this.setScrollPosition(viewPager.getCurrentItem(), 0.0f, true);
        } else {
            this.viewPager = null;
            this.setPagerAdapter(null, false);
        }
        this.setupViewPagerImplicitly = implicitSetup;
    }

    @Deprecated
    public void setTabsFromPagerAdapter(@Nullable PagerAdapter adapter) {
        this.setPagerAdapter(adapter, false);
    }

    public boolean shouldDelayChildPressedState() {
        return this.getTabScrollRange() > 0;
    }

    protected void onAttachedToWindow() {
        ViewParent vp;
        super.onAttachedToWindow();
        if (this.viewPager == null && (vp = this.getParent()) instanceof ViewPager) {
            this.setupWithViewPager((ViewPager)vp, true, true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.setupViewPagerImplicitly) {
            this.setupWithViewPager(null);
            this.setupViewPagerImplicitly = false;
        }
    }

    private int getTabScrollRange() {
        return Math.max(0, this.slidingTabIndicator.getWidth() - this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
    }

    void setPagerAdapter(@Nullable PagerAdapter adapter, boolean addObserver) {
        if (this.pagerAdapter != null && this.pagerAdapterObserver != null) {
            this.pagerAdapter.unregisterDataSetObserver(this.pagerAdapterObserver);
        }
        this.pagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.pagerAdapterObserver == null) {
                this.pagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.pagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    void populateFromPagerAdapter() {
        this.removeAllTabs();
        if (this.pagerAdapter != null) {
            int curItem;
            int adapterCount = this.pagerAdapter.getCount();
            for (curItem = 0; curItem < adapterCount; ++curItem) {
                this.addTab(this.newTab().setText(this.pagerAdapter.getPageTitle(curItem)), false);
            }
            if (this.viewPager != null && adapterCount > 0 && (curItem = this.viewPager.getCurrentItem()) != this.getSelectedTabPosition() && curItem < this.getTabCount()) {
                this.selectTab(this.getTabAt(curItem));
            }
        }
    }

    private void updateAllTabs() {
        int z = this.tabs.size();
        for (int i = 0; i < z; ++i) {
            this.tabs.get(i).updateView();
        }
    }

    private TabView createTabView(@NonNull Tab tab) {
        TabView tabView;
        TabView tabView2 = tabView = this.tabViewPool != null ? (TabView)((Object)this.tabViewPool.acquire()) : null;
        if (tabView == null) {
            tabView = new TabView(this.getContext());
        }
        tabView.setTab(tab);
        tabView.setFocusable(true);
        tabView.setMinimumWidth(this.getTabMinWidth());
        if (TextUtils.isEmpty((CharSequence)tab.contentDesc)) {
            tabView.setContentDescription(tab.text);
        } else {
            tabView.setContentDescription(tab.contentDesc);
        }
        return tabView;
    }

    private void configureTab(Tab tab, int position) {
        tab.setPosition(position);
        this.tabs.add(position, tab);
        int count = this.tabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.tabs.get(i).setPosition(i);
        }
    }

    private void addTabView(Tab tab) {
        TabView tabView = tab.view;
        this.slidingTabIndicator.addView((View)tabView, tab.getPosition(), (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
    }

    public void addView(View child) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index) {
        this.addViewInternal(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    private void addViewInternal(View child) {
        if (!(child instanceof TabItem)) {
            throw new IllegalArgumentException("Only TabItem instances can be added to GlueTabLayout");
        }
        this.addTabFromItemView((TabItem)child);
    }

    private LinearLayout.LayoutParams createLayoutParamsForTabs() {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -1);
        this.updateTabViewLayoutParams(lp);
        return lp;
    }

    private void updateTabViewLayoutParams(LinearLayout.LayoutParams lp) {
        if (this.mode == 1 && this.tabGravity == 0) {
            lp.width = 0;
            lp.weight = 1.0f;
        } else {
            lp.width = -2;
            lp.weight = 0.0f;
        }
    }

    @Dimension(unit=1)
    int dpToPx(@Dimension(unit=0) int dps) {
        return Math.round(this.getResources().getDisplayMetrics().density * (float)dps);
    }

    protected void onDraw(Canvas canvas) {
        for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
            View tabView = this.slidingTabIndicator.getChildAt(i);
            if (!(tabView instanceof TabView)) continue;
            ((TabView)tabView).drawBackground(canvas);
        }
        super.onDraw(canvas);
    }

    @SuppressLint(value={"WrongConstant"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int idealHeight = this.dpToPx(this.getDefaultHeight()) + this.getPaddingTop() + this.getPaddingBottom();
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(idealHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)0x40000000);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)idealHeight, (int)0x40000000);
            }
        }
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            this.tabMaxWidth = this.requestedTabMaxWidth > 0 ? this.requestedTabMaxWidth : specWidth - this.dpToPx(56);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() == 1) {
            View child = this.getChildAt(0);
            boolean remeasure = false;
            switch (this.mode) {
                case 0: {
                    remeasure = child.getMeasuredWidth() < this.getMeasuredWidth();
                    break;
                }
                case 1: {
                    boolean bl = remeasure = child.getMeasuredWidth() != this.getMeasuredWidth();
                }
            }
            if (remeasure) {
                int childHeightMeasureSpec = FsTabLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)child.getLayoutParams().height);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private void removeTabViewAt(int position) {
        TabView view = (TabView)this.slidingTabIndicator.getChildAt(position);
        this.slidingTabIndicator.removeViewAt(position);
        if (view != null) {
            view.reset();
            this.tabViewPool.release((Object)view);
        }
        this.requestLayout();
    }

    private void animateToTab(int newPosition) {
        if (newPosition != -1) {
            if (this.getWindowToken() != null && ViewCompat.isLaidOut((View)this) && !this.slidingTabIndicator.childrenNeedLayout()) {
                int targetScrollX;
                int startScrollX = this.getScrollX();
                if (startScrollX != (targetScrollX = this.calculateScrollXForTab(newPosition, 0.0f))) {
                    this.ensureScrollAnimator();
                    this.scrollAnimator.setIntValues(new int[]{startScrollX, targetScrollX});
                    this.scrollAnimator.start();
                }
                this.slidingTabIndicator.animateIndicatorToPosition(newPosition, this.tabIndicatorAnimationDuration);
            } else {
                this.setScrollPosition(newPosition, 0.0f, true);
            }
        }
    }

    private void ensureScrollAnimator() {
        if (this.scrollAnimator == null) {
            this.scrollAnimator = new ValueAnimator();
            this.scrollAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.scrollAnimator.setDuration((long)this.tabIndicatorAnimationDuration);
            this.scrollAnimator.addUpdateListener(animator -> this.scrollTo((Integer)animator.getAnimatedValue(), 0));
        }
    }

    void setScrollAnimatorListener(Animator.AnimatorListener listener) {
        this.ensureScrollAnimator();
        this.scrollAnimator.addListener(listener);
    }

    private void setSelectedTabView(int position) {
        int tabCount = this.slidingTabIndicator.getChildCount();
        if (position < tabCount) {
            for (int i = 0; i < tabCount; ++i) {
                View child = this.slidingTabIndicator.getChildAt(i);
                child.setSelected(i == position);
                child.setActivated(i == position);
            }
        }
    }

    void selectTab(Tab tab) {
        this.selectTab(tab, true);
    }

    void selectTab(Tab tab, boolean updateIndicator) {
        Tab currentTab = this.selectedTab;
        if (currentTab == tab) {
            if (currentTab != null) {
                this.dispatchTabReselected(tab);
                this.animateToTab(tab.getPosition());
            }
        } else {
            int newPosition;
            int n = newPosition = tab != null ? tab.getPosition() : -1;
            if (updateIndicator) {
                if ((currentTab == null || currentTab.getPosition() == -1) && newPosition != -1) {
                    this.setScrollPosition(newPosition, 0.0f, true);
                } else {
                    this.animateToTab(newPosition);
                }
                if (newPosition != -1) {
                    this.setSelectedTabView(newPosition);
                }
            }
            this.selectedTab = tab;
            if (currentTab != null) {
                this.dispatchTabUnselected(currentTab);
            }
            if (tab != null) {
                this.dispatchTabSelected(tab);
            }
        }
    }

    private void dispatchTabSelected(@NonNull Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabSelected(tab);
        }
    }

    private void dispatchTabUnselected(@NonNull Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabUnselected(tab);
        }
    }

    private void dispatchTabReselected(@NonNull Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabReselected(tab);
        }
    }

    private int calculateScrollXForTab(int position, float positionOffset) {
        if (this.mode == 0) {
            View selectedChild = this.slidingTabIndicator.getChildAt(position);
            View nextChild = position + 1 < this.slidingTabIndicator.getChildCount() ? this.slidingTabIndicator.getChildAt(position + 1) : null;
            int selectedWidth = selectedChild != null ? selectedChild.getWidth() : 0;
            int nextWidth = nextChild != null ? nextChild.getWidth() : 0;
            int scrollBase = selectedChild.getLeft() + selectedWidth / 2 - this.getWidth() / 2;
            int scrollOffset = (int)((float)(selectedWidth + nextWidth) * 0.5f * positionOffset);
            return ViewCompat.getLayoutDirection((View)this) == 0 ? scrollBase + scrollOffset : scrollBase - scrollOffset;
        }
        return 0;
    }

    private void applyModeAndGravity() {
        int paddingStart = 0;
        if (this.mode == 0) {
            paddingStart = Math.max(0, this.contentInsetStart - this.tabPaddingStart);
        }
        ViewCompat.setPaddingRelative((View)this.slidingTabIndicator, (int)paddingStart, (int)0, (int)0, (int)0);
        switch (this.mode) {
            case 0: {
                this.slidingTabIndicator.setGravity(0x800003);
                break;
            }
            case 1: {
                this.slidingTabIndicator.setGravity(1);
            }
        }
        this.updateTabViews(true);
    }

    void updateTabViews(boolean requestLayout) {
        for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
            View child = this.slidingTabIndicator.getChildAt(i);
            child.setMinimumWidth(this.getTabMinWidth());
            this.updateTabViewLayoutParams((LinearLayout.LayoutParams)child.getLayoutParams());
            if (!requestLayout) continue;
            child.requestLayout();
        }
    }

    private static ColorStateList createColorStateList(int defaultColor, int selectedColor) {
        int[][] states = new int[2][];
        int[] colors = new int[2];
        int i = 0;
        states[i] = SELECTED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = EMPTY_STATE_SET;
        colors[i] = defaultColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    @Dimension(unit=0)
    private int getDefaultHeight() {
        boolean hasIconAndText = false;
        int count = this.tabs.size();
        for (int i = 0; i < count; ++i) {
            Tab tab = this.tabs.get(i);
            if (tab == null || tab.getIcon() == null || TextUtils.isEmpty((CharSequence)tab.getText())) continue;
            hasIconAndText = true;
            break;
        }
        return hasIconAndText && !this.inlineLabel ? 72 : 48;
    }

    private int getTabMinWidth() {
        if (this.requestedTabMinWidth != -1) {
            return this.requestedTabMinWidth;
        }
        return this.mode == 0 ? this.scrollableTabMinWidth : 0;
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return this.generateDefaultLayoutParams();
    }

    int getTabMaxWidth() {
        return this.tabMaxWidth;
    }

    public void setTabIndicatorWidth(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Please check the parameters you passed in GlueTabLayout.setTabIndicatorWidth(float f)");
        }
        this.widthPercent = f;
    }

    public void setSlidingIndicatorAnimType(AnimType animType) {
        this.slidingAnimType = animType;
    }

    public void setClickIndicatorAnimType(AnimType animType) {
        this.clickAnimType = animType;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Mode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TabGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TabIndicatorGravity {
    }

    public static interface BaseOnTabSelectedListener<T extends Tab> {
        public void onTabSelected(T var1);

        public void onTabUnselected(T var1);

        public void onTabReselected(T var1);
    }

    public static interface OnTabSelectedListener
    extends BaseOnTabSelectedListener<Tab> {
    }

    public static class Tab {
        public static final int INVALID_POSITION = -1;
        private Object tag;
        private Drawable icon;
        private CharSequence text;
        private CharSequence contentDesc;
        private int position = -1;
        private View customView;
        public FsTabLayout parent;
        public TabView view;

        @Nullable
        public Object getTag() {
            return this.tag;
        }

        @NonNull
        public Tab setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        @Nullable
        public View getCustomView() {
            return this.customView;
        }

        @NonNull
        public Tab setCustomView(@Nullable View view) {
            this.customView = view;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setCustomView(@LayoutRes int resId) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.view.getContext());
            return this.setCustomView(inflater.inflate(resId, (ViewGroup)this.view, false));
        }

        @Nullable
        public Drawable getIcon() {
            return this.icon;
        }

        public int getPosition() {
            return this.position;
        }

        void setPosition(int position) {
            this.position = position;
        }

        @Nullable
        public CharSequence getText() {
            return this.text;
        }

        @NonNull
        public Tab setIcon(@Nullable Drawable icon) {
            this.icon = icon;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setIcon(@DrawableRes int resId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a GlueTabLayout");
            }
            return this.setIcon(AppCompatResources.getDrawable((Context)this.parent.getContext(), (int)resId));
        }

        @NonNull
        public Tab setText(@Nullable CharSequence text) {
            if (TextUtils.isEmpty((CharSequence)this.contentDesc) && !TextUtils.isEmpty((CharSequence)text)) {
                this.view.setContentDescription(text);
            }
            this.text = text;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setText(@StringRes int resId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a GlueTabLayout");
            }
            return this.setText(this.parent.getResources().getText(resId));
        }

        public void select() {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a GlueTabLayout");
            }
            this.parent.selectTab(this);
        }

        public boolean isSelected() {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a GlueTabLayout");
            }
            return this.parent.getSelectedTabPosition() == this.position;
        }

        @NonNull
        public Tab setContentDescription(@StringRes int resId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Tab not attached to a GlueTabLayout");
            }
            return this.setContentDescription(this.parent.getResources().getText(resId));
        }

        @NonNull
        public Tab setContentDescription(@Nullable CharSequence contentDesc) {
            this.contentDesc = contentDesc;
            this.updateView();
            return this;
        }

        @Nullable
        public CharSequence getContentDescription() {
            return this.view == null ? null : this.view.getContentDescription();
        }

        void updateView() {
            if (this.view != null) {
                this.view.update();
            }
        }

        void reset() {
            this.parent = null;
            this.view = null;
            this.tag = null;
            this.icon = null;
            this.text = null;
            this.contentDesc = null;
            this.position = -1;
            this.customView = null;
        }
    }

    class TabView
    extends LinearLayout {
        private Tab tab;
        private TextView textView;
        private ImageView iconView;
        private View customView;
        private TextView customTextView;
        private ImageView customIconView;
        @Nullable
        private Drawable baseBackgroundDrawable;
        private int defaultMaxLines;

        @SuppressLint(value={"WrongConstant"})
        public TabView(Context context) {
            super(context);
            this.defaultMaxLines = 2;
            this.updateBackgroundDrawable(context);
            ViewCompat.setPaddingRelative((View)this, (int)FsTabLayout.this.tabPaddingStart, (int)FsTabLayout.this.tabPaddingTop, (int)FsTabLayout.this.tabPaddingEnd, (int)FsTabLayout.this.tabPaddingBottom);
            this.setGravity(17);
            this.setOrientation(FsTabLayout.this.inlineLabel ? 0 : 1);
            this.setClickable(true);
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        }

        @SuppressLint(value={"RestrictedApi"})
        private void updateBackgroundDrawable(Context context) {
            GradientDrawable background;
            if (FsTabLayout.this.tabBackgroundResId != 0) {
                this.baseBackgroundDrawable = AppCompatResources.getDrawable((Context)context, (int)FsTabLayout.this.tabBackgroundResId);
                if (this.baseBackgroundDrawable != null && this.baseBackgroundDrawable.isStateful()) {
                    this.baseBackgroundDrawable.setState(this.getDrawableState());
                }
            } else {
                this.baseBackgroundDrawable = null;
            }
            GradientDrawable contentDrawable = new GradientDrawable();
            contentDrawable.setColor(0);
            if (FsTabLayout.this.tabRippleColorStateList != null) {
                GradientDrawable maskDrawable = new GradientDrawable();
                maskDrawable.setCornerRadius(1.0E-5f);
                maskDrawable.setColor(-1);
                ColorStateList rippleColor = RippleUtils.convertToRippleDrawableColor((ColorStateList)FsTabLayout.this.tabRippleColorStateList);
                if (Build.VERSION.SDK_INT >= 21) {
                    background = new RippleDrawable(rippleColor, (Drawable)(FsTabLayout.this.unboundedRipple ? null : contentDrawable), (Drawable)(FsTabLayout.this.unboundedRipple ? null : maskDrawable));
                } else {
                    Drawable rippleDrawable = DrawableCompat.wrap((Drawable)maskDrawable);
                    DrawableCompat.setTintList((Drawable)rippleDrawable, (ColorStateList)rippleColor);
                    background = new LayerDrawable(new Drawable[]{contentDrawable, rippleDrawable});
                }
            } else {
                background = contentDrawable;
            }
            ViewCompat.setBackground((View)this, (Drawable)((Drawable)background));
            FsTabLayout.this.invalidate();
        }

        private void drawBackground(Canvas canvas) {
            if (this.baseBackgroundDrawable != null) {
                this.baseBackgroundDrawable.setBounds(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
                this.baseBackgroundDrawable.draw(canvas);
            }
        }

        protected void drawableStateChanged() {
            super.drawableStateChanged();
            boolean changed = false;
            int[] state = this.getDrawableState();
            if (this.baseBackgroundDrawable != null && this.baseBackgroundDrawable.isStateful()) {
                changed |= this.baseBackgroundDrawable.setState(state);
            }
            if (changed) {
                this.invalidate();
                FsTabLayout.this.invalidate();
            }
        }

        public boolean performClick() {
            boolean handled = super.performClick();
            if (this.tab != null) {
                if (!handled) {
                    this.playSoundEffect(0);
                }
                this.tab.select();
                return true;
            }
            return handled;
        }

        public void setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (changed && selected && Build.VERSION.SDK_INT < 16) {
                this.sendAccessibilityEvent(4);
            }
            if (this.textView != null) {
                this.textView.setSelected(selected);
            }
            if (this.iconView != null) {
                this.iconView.setSelected(selected);
            }
            if (this.customView != null) {
                this.customView.setSelected(selected);
            }
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
            event.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
            info.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        @SuppressLint(value={"WrongConstant"})
        public void onMeasure(int origWidthMeasureSpec, int origHeightMeasureSpec) {
            int specWidthSize = View.MeasureSpec.getSize((int)origWidthMeasureSpec);
            int specWidthMode = View.MeasureSpec.getMode((int)origWidthMeasureSpec);
            int maxWidth = FsTabLayout.this.getTabMaxWidth();
            int widthMeasureSpec = maxWidth <= 0 || specWidthMode != 0 && specWidthSize <= maxWidth ? origWidthMeasureSpec : View.MeasureSpec.makeMeasureSpec((int)FsTabLayout.this.tabMaxWidth, (int)Integer.MIN_VALUE);
            super.onMeasure(widthMeasureSpec, origHeightMeasureSpec);
            if (this.textView != null) {
                float textSize = FsTabLayout.this.tabTextSize;
                int maxLines = this.defaultMaxLines;
                if (this.iconView != null && this.iconView.getVisibility() == 0) {
                    maxLines = 1;
                } else if (this.textView != null && this.textView.getLineCount() > 1) {
                    textSize = FsTabLayout.this.tabTextMultiLineSize;
                }
                float curTextSize = this.textView.getTextSize();
                int curLineCount = this.textView.getLineCount();
                int curMaxLines = TextViewCompat.getMaxLines((TextView)this.textView);
                if (textSize != curTextSize || curMaxLines >= 0 && maxLines != curMaxLines) {
                    Layout layout2;
                    boolean updateTextView = true;
                    if (FsTabLayout.this.mode == 1 && textSize > curTextSize && curLineCount == 1 && ((layout2 = this.textView.getLayout()) == null || this.approximateLineWidth(layout2, 0, textSize) > (float)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()))) {
                        updateTextView = false;
                    }
                    if (updateTextView) {
                        this.textView.setTextSize(0, textSize);
                        this.textView.setMaxLines(maxLines);
                        super.onMeasure(widthMeasureSpec, origHeightMeasureSpec);
                    }
                }
            }
        }

        void setTab(@Nullable Tab tab) {
            if (tab != this.tab) {
                this.tab = tab;
                this.update();
            }
        }

        void reset() {
            this.setTab(null);
            this.setSelected(false);
        }

        @SuppressLint(value={"ResourceType"})
        final void update() {
            View custom;
            Tab tab = this.tab;
            View view = custom = tab != null ? tab.getCustomView() : null;
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.customView = custom;
                if (this.textView != null) {
                    this.textView.setVisibility(8);
                }
                if (this.iconView != null) {
                    this.iconView.setVisibility(8);
                    this.iconView.setImageDrawable((Drawable)null);
                }
                this.customTextView = (TextView)custom.findViewById(16908308);
                if (this.customTextView != null) {
                    this.defaultMaxLines = TextViewCompat.getMaxLines((TextView)this.customTextView);
                }
                this.customIconView = (ImageView)custom.findViewById(16908294);
            } else {
                if (this.customView != null) {
                    this.removeView(this.customView);
                    this.customView = null;
                }
                this.customTextView = null;
                this.customIconView = null;
            }
            if (this.customView == null) {
                Drawable icon;
                if (this.iconView == null) {
                    ImageView iconView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_icon, (ViewGroup)this, false);
                    this.addView((View)iconView, 0);
                    this.iconView = iconView;
                }
                Drawable drawable2 = icon = tab != null && tab.getIcon() != null ? DrawableCompat.wrap((Drawable)tab.getIcon()).mutate() : null;
                if (icon != null) {
                    DrawableCompat.setTintList((Drawable)icon, (ColorStateList)FsTabLayout.this.tabIconTint);
                    if (FsTabLayout.this.tabIconTintMode != null) {
                        DrawableCompat.setTintMode((Drawable)icon, (PorterDuff.Mode)FsTabLayout.this.tabIconTintMode);
                    }
                }
                if (this.textView == null) {
                    TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_text, (ViewGroup)this, false);
                    this.addView((View)textView);
                    this.textView = textView;
                    this.defaultMaxLines = TextViewCompat.getMaxLines((TextView)this.textView);
                }
                TextViewCompat.setTextAppearance((TextView)this.textView, (int)FsTabLayout.this.tabTextAppearance);
                if (FsTabLayout.this.tabTextColors != null) {
                    this.textView.setTextColor(FsTabLayout.this.tabTextColors);
                }
                this.updateTextAndIcon(this.textView, this.iconView);
            } else if (this.customTextView != null || this.customIconView != null) {
                this.updateTextAndIcon(this.customTextView, this.customIconView);
            }
            if (tab != null && !TextUtils.isEmpty((CharSequence)tab.contentDesc)) {
                this.setContentDescription(tab.contentDesc);
            }
            this.setSelected(tab != null && tab.isSelected());
        }

        @SuppressLint(value={"WrongConstant"})
        final void updateOrientation() {
            this.setOrientation(FsTabLayout.this.inlineLabel ? 0 : 1);
            if (this.customTextView == null && this.customIconView == null) {
                this.updateTextAndIcon(this.textView, this.iconView);
            } else {
                this.updateTextAndIcon(this.customTextView, this.customIconView);
            }
        }

        @SuppressLint(value={"WrongConstant"})
        private void updateTextAndIcon(@Nullable TextView textView, @Nullable ImageView iconView) {
            boolean hasText;
            CharSequence text;
            Drawable icon = this.tab != null && this.tab.getIcon() != null ? DrawableCompat.wrap((Drawable)this.tab.getIcon()).mutate() : null;
            CharSequence charSequence = text = this.tab != null ? this.tab.getText() : null;
            if (iconView != null) {
                if (icon != null) {
                    iconView.setImageDrawable(icon);
                    iconView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    iconView.setVisibility(8);
                    iconView.setImageDrawable((Drawable)null);
                }
            }
            boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
            if (textView != null) {
                if (hasText) {
                    textView.setText(text);
                    textView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    textView.setVisibility(8);
                    textView.setText((CharSequence)null);
                }
            }
            if (iconView != null) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
                int iconMargin = 0;
                if (hasText && iconView.getVisibility() == 0) {
                    iconMargin = FsTabLayout.this.dpToPx(8);
                }
                if (FsTabLayout.this.inlineLabel) {
                    if (iconMargin != MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp)) {
                        MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)lp, (int)iconMargin);
                        lp.bottomMargin = 0;
                        iconView.setLayoutParams((ViewGroup.LayoutParams)lp);
                        iconView.requestLayout();
                    }
                } else if (iconMargin != lp.bottomMargin) {
                    lp.bottomMargin = iconMargin;
                    MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)lp, (int)0);
                    iconView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    iconView.requestLayout();
                }
            }
            CharSequence contentDesc = this.tab != null ? this.tab.contentDesc : null;
            TooltipCompat.setTooltipText((View)this, (CharSequence)(hasText ? null : contentDesc));
        }

        @SuppressLint(value={"WrongConstant"})
        private int getContentWidth() {
            boolean initialized = false;
            int left = 0;
            int right = 0;
            for (View view : new View[]{this.textView, this.iconView, this.customView}) {
                if (view == null || view.getVisibility() != 0) continue;
                left = initialized ? Math.min(left, view.getLeft()) : view.getLeft();
                right = initialized ? Math.max(right, view.getRight()) : view.getRight();
                initialized = true;
            }
            return right - left;
        }

        public Tab getTab() {
            return this.tab;
        }

        private float approximateLineWidth(Layout layout2, int line, float textSize) {
            return layout2.getLineWidth(line) * (textSize / layout2.getPaint().getTextSize());
        }
    }

    private class SlidingTabIndicator
    extends LinearLayout {
        private int selectedIndicatorHeight;
        private final Paint selectedIndicatorPaint;
        private final GradientDrawable defaultSelectionIndicator;
        int selectedPosition;
        float selectionOffset;
        private int layoutDirection;
        private int indicatorLeft;
        private int indicatorRight;
        private ValueAnimator indicatorAnimator;
        int reduceWidth;

        SlidingTabIndicator(Context context) {
            super(context);
            this.selectedPosition = -1;
            this.layoutDirection = -1;
            this.indicatorLeft = -1;
            this.indicatorRight = -1;
            this.reduceWidth = 0;
            this.setWillNotDraw(false);
            this.selectedIndicatorPaint = new Paint();
            this.defaultSelectionIndicator = new GradientDrawable();
        }

        void setSelectedIndicatorColor(int color2) {
            if (this.selectedIndicatorPaint.getColor() != color2) {
                this.selectedIndicatorPaint.setColor(color2);
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setSelectedIndicatorHeight(int height) {
            if (this.selectedIndicatorHeight != height) {
                this.selectedIndicatorHeight = height;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        boolean childrenNeedLayout() {
            int z = this.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = this.getChildAt(i);
                if (child.getWidth() > 0) continue;
                return true;
            }
            return false;
        }

        void setIndicatorPositionFromTabPosition(int position, float positionOffset) {
            if (this.indicatorAnimator != null && this.indicatorAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
            }
            this.selectedPosition = position;
            this.selectionOffset = positionOffset;
            this.updateIndicatorPosition();
        }

        float getIndicatorPosition() {
            return (float)this.selectedPosition + this.selectionOffset;
        }

        public void onRtlPropertiesChanged(int layoutDirection) {
            super.onRtlPropertiesChanged(layoutDirection);
            if (Build.VERSION.SDK_INT < 23 && this.layoutDirection != layoutDirection) {
                this.requestLayout();
                this.layoutDirection = layoutDirection;
            }
        }

        @SuppressLint(value={"WrongConstant"})
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000 && FsTabLayout.this.mode == 1 && FsTabLayout.this.tabGravity == 1) {
                int gutter;
                int count = this.getChildCount();
                int largestTabWidth = 0;
                int z = count;
                for (gutter = 0; gutter < z; ++gutter) {
                    View child = this.getChildAt(gutter);
                    if (child.getVisibility() != 0) continue;
                    largestTabWidth = Math.max(largestTabWidth, child.getMeasuredWidth());
                }
                if (largestTabWidth <= 0) {
                    return;
                }
                gutter = FsTabLayout.this.dpToPx(16);
                boolean remeasure = false;
                if (largestTabWidth * count > this.getMeasuredWidth() - gutter * 2) {
                    FsTabLayout.this.tabGravity = 0;
                    FsTabLayout.this.updateTabViews(false);
                    remeasure = true;
                } else {
                    for (int i = 0; i < count; ++i) {
                        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getChildAt(i).getLayoutParams();
                        if (lp.width == largestTabWidth && lp.weight == 0.0f) continue;
                        lp.width = largestTabWidth;
                        lp.weight = 0.0f;
                        remeasure = true;
                    }
                }
                if (remeasure) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.indicatorAnimator != null && this.indicatorAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
                long duration = this.indicatorAnimator.getDuration();
                this.animateIndicatorToPosition(this.selectedPosition, Math.round((1.0f - this.indicatorAnimator.getAnimatedFraction()) * (float)duration));
            } else {
                this.updateIndicatorPosition();
            }
        }

        private void updateIndicatorPosition() {
            int right;
            int left;
            View selectedTitle = this.getChildAt(this.selectedPosition);
            if (selectedTitle != null && selectedTitle.getWidth() > 0) {
                left = selectedTitle.getLeft();
                right = selectedTitle.getRight();
                if (!FsTabLayout.this.tabIndicatorFullWidth && selectedTitle instanceof TabView) {
                    this.calculateTabViewContentBounds((TabView)selectedTitle, FsTabLayout.this.tabViewContentBounds);
                    left = (int)((FsTabLayout)FsTabLayout.this).tabViewContentBounds.left;
                    right = (int)((FsTabLayout)FsTabLayout.this).tabViewContentBounds.right;
                }
                if (this.selectionOffset > 0.0f && this.selectedPosition < this.getChildCount() - 1) {
                    View nextTitle = this.getChildAt(this.selectedPosition + 1);
                    int nextTitleLeft = nextTitle.getLeft();
                    int nextTitleRight = nextTitle.getRight();
                    if (!FsTabLayout.this.tabIndicatorFullWidth && nextTitle instanceof TabView) {
                        this.calculateTabViewContentBounds((TabView)nextTitle, FsTabLayout.this.tabViewContentBounds);
                        nextTitleLeft = (int)((FsTabLayout)FsTabLayout.this).tabViewContentBounds.left;
                        nextTitleRight = (int)((FsTabLayout)FsTabLayout.this).tabViewContentBounds.right;
                    }
                    switch (FsTabLayout.this.slidingAnimType) {
                        case GLUE: {
                            if ((double)this.selectionOffset < 0.5) {
                                right = (int)(this.selectionOffset * 2.0f * (float)nextTitleRight + (1.0f - this.selectionOffset * 2.0f) * (float)right);
                                break;
                            }
                            right = nextTitleRight;
                            left = (int)(((double)this.selectionOffset - 0.5) * 2.0 * (double)nextTitleLeft + (1.0 - ((double)this.selectionOffset - 0.5) * 2.0) * (double)left);
                            break;
                        }
                        case HALF_GLUE: {
                            int width = nextTitleLeft - left;
                            if ((double)this.selectionOffset < 0.5) {
                                left = (int)(this.selectionOffset * (float)nextTitleLeft - (float)width * 1.0f / 4.0f * this.selectionOffset * 2.0f + (1.0f - this.selectionOffset) * (float)left);
                                right = (int)(this.selectionOffset * (float)nextTitleRight + (float)width * 1.0f / 4.0f * this.selectionOffset * 2.0f + (1.0f - this.selectionOffset) * (float)right);
                                break;
                            }
                            left = (int)(this.selectionOffset * (float)nextTitleLeft - (float)width * 1.0f / 4.0f * (1.0f - this.selectionOffset) * 2.0f + (1.0f - this.selectionOffset) * (float)left);
                            right = (int)(this.selectionOffset * (float)nextTitleRight + (float)width * 1.0f / 4.0f * (1.0f - this.selectionOffset) * 2.0f + (1.0f - this.selectionOffset) * (float)right);
                            break;
                        }
                        default: {
                            left = (int)(this.selectionOffset * (float)nextTitleLeft + (1.0f - this.selectionOffset) * (float)left);
                            right = (int)(this.selectionOffset * (float)nextTitleRight + (1.0f - this.selectionOffset) * (float)right);
                            break;
                        }
                    }
                }
            } else {
                right = -1;
                left = -1;
            }
            this.setIndicatorPosition(left, right);
        }

        void setIndicatorPosition(int left, int right) {
            if (left != this.indicatorLeft || right != this.indicatorRight) {
                this.reduceWidth = (int)((float)(right - left) * (1.0f - FsTabLayout.this.widthPercent) / 2.0f);
                this.indicatorLeft = left + this.reduceWidth;
                this.indicatorRight = right - this.reduceWidth;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void animateIndicatorToPosition(final int position, int duration) {
            View targetView;
            if (this.selectedPosition == position) {
                return;
            }
            if (this.indicatorAnimator != null && this.indicatorAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
            }
            if ((targetView = this.getChildAt(position)) == null) {
                this.updateIndicatorPosition();
            } else {
                int targetLeft = targetView.getLeft();
                int targetRight = targetView.getRight();
                if (!FsTabLayout.this.tabIndicatorFullWidth && targetView instanceof TabView) {
                    this.calculateTabViewContentBounds((TabView)targetView, FsTabLayout.this.tabViewContentBounds);
                    targetLeft = (int)((FsTabLayout)FsTabLayout.this).tabViewContentBounds.left;
                    targetRight = (int)((FsTabLayout)FsTabLayout.this).tabViewContentBounds.right;
                }
                int startLeft = this.indicatorLeft;
                int startRight = this.indicatorRight;
                if (startLeft != targetLeft || startRight != targetRight) {
                    ValueAnimator animator = this.indicatorAnimator = new ValueAnimator();
                    animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                    animator.setDuration((long)duration);
                    animator.setFloatValues(new float[]{0.0f, 1.0f});
                    int finalTargetLeft = targetLeft;
                    int finalTargetRight = targetRight;
                    int width = (finalTargetRight - finalTargetLeft) / 4;
                    animator.addUpdateListener(animator1 -> {
                        float fraction = animator1.getAnimatedFraction();
                        switch (FsTabLayout.this.clickAnimType) {
                            case GLUE: {
                                if ((double)fraction < 0.5) {
                                    if (finalTargetLeft > startLeft) {
                                        this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, fraction * 0.0f) - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, fraction * 2.0f) + (float)this.reduceWidth * (1.0f - fraction)));
                                        break;
                                    }
                                    this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, fraction * 2.0f) - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, fraction * 0.0f) + (float)this.reduceWidth * (1.0f - fraction)));
                                    break;
                                }
                                if (finalTargetLeft > startLeft) {
                                    this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, (fraction - 0.5f) * 2.0f) - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, 1.0f) + (float)this.reduceWidth * (1.0f - fraction)));
                                    break;
                                }
                                this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, 1.0f) - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, (fraction - 0.5f) * 2.0f) + (float)this.reduceWidth * (1.0f - fraction)));
                                break;
                            }
                            case HALF_GLUE: {
                                if ((double)fraction < 0.5) {
                                    this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, fraction) - (float)width * fraction * 2.0f - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, fraction) + (float)width * fraction * 2.0f + (float)this.reduceWidth * (1.0f - fraction)));
                                    break;
                                }
                                this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, fraction) - (float)width * (1.0f - fraction) * 2.0f - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, fraction) + (float)width * (1.0f - fraction) * 2.0f + (float)this.reduceWidth * (1.0f - fraction)));
                                break;
                            }
                            default: {
                                this.setIndicatorPosition((int)((float)this.lerp(startLeft, finalTargetLeft, fraction) - (float)this.reduceWidth * (1.0f - fraction)), (int)((float)this.lerp(startRight, finalTargetRight, fraction) + (float)this.reduceWidth * (1.0f - fraction)));
                            }
                        }
                    });
                    animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animator) {
                            SlidingTabIndicator.this.selectedPosition = position;
                            SlidingTabIndicator.this.selectionOffset = 0.0f;
                        }
                    });
                    animator.start();
                }
            }
        }

        public float lerp(float startValue, float endValue, float fraction) {
            return startValue + fraction * (endValue - startValue);
        }

        public int lerp(int startValue, int endValue, float fraction) {
            return startValue + Math.round(fraction * (float)(endValue - startValue));
        }

        private void calculateTabViewContentBounds(TabView tabView, RectF contentBounds) {
            int tabViewContentWidth = tabView.getContentWidth();
            if (tabViewContentWidth < FsTabLayout.this.dpToPx(24)) {
                tabViewContentWidth = FsTabLayout.this.dpToPx(24);
            }
            int tabViewCenter = (tabView.getLeft() + tabView.getRight()) / 2;
            int contentLeftBounds = tabViewCenter - tabViewContentWidth / 2;
            int contentRightBounds = tabViewCenter + tabViewContentWidth / 2;
            contentBounds.set((float)contentLeftBounds, 0.0f, (float)contentRightBounds, 0.0f);
        }

        public void draw(Canvas canvas) {
            int indicatorHeight = 0;
            if (FsTabLayout.this.tabSelectedIndicator != null) {
                indicatorHeight = FsTabLayout.this.tabSelectedIndicator.getIntrinsicHeight();
            }
            if (this.selectedIndicatorHeight >= 0) {
                indicatorHeight = this.selectedIndicatorHeight;
            }
            int indicatorTop = 0;
            int indicatorBottom = 0;
            switch (FsTabLayout.this.tabIndicatorGravity) {
                case 0: {
                    indicatorTop = this.getHeight() - indicatorHeight;
                    indicatorBottom = this.getHeight();
                    break;
                }
                case 1: {
                    indicatorTop = (this.getHeight() - indicatorHeight) / 2;
                    indicatorBottom = (this.getHeight() + indicatorHeight) / 2;
                    break;
                }
                case 2: {
                    indicatorTop = 0;
                    indicatorBottom = indicatorHeight;
                    break;
                }
                case 3: {
                    indicatorTop = 0;
                    indicatorBottom = this.getHeight();
                }
            }
            if (this.indicatorLeft >= 0 && this.indicatorRight > this.indicatorLeft) {
                Drawable selectedIndicator = DrawableCompat.wrap((Drawable)(FsTabLayout.this.tabSelectedIndicator != null ? FsTabLayout.this.tabSelectedIndicator : this.defaultSelectionIndicator));
                selectedIndicator.setBounds(this.indicatorLeft, indicatorTop, this.indicatorRight, indicatorBottom);
                if (this.selectedIndicatorPaint != null) {
                    if (Build.VERSION.SDK_INT == 21) {
                        selectedIndicator.setColorFilter(this.selectedIndicatorPaint.getColor(), PorterDuff.Mode.SRC_IN);
                    } else {
                        DrawableCompat.setTint((Drawable)selectedIndicator, (int)this.selectedIndicatorPaint.getColor());
                    }
                }
                selectedIndicator.draw(canvas);
            }
            super.draw(canvas);
        }
    }

    public static enum AnimType {
        GLUE,
        HALF_GLUE,
        NONE;

    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<FsTabLayout> tabLayoutRef;
        private int previousScrollState;
        private int scrollState;

        public TabLayoutOnPageChangeListener(FsTabLayout tabLayout) {
            this.tabLayoutRef = new WeakReference<FsTabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            this.previousScrollState = this.scrollState;
            this.scrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            FsTabLayout tabLayout = (FsTabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null) {
                boolean updateText = this.scrollState != 2 || this.previousScrollState == 1;
                boolean updateIndicator = this.scrollState != 2 || this.previousScrollState != 0;
                tabLayout.setScrollPosition(position, positionOffset, updateText, updateIndicator);
            }
        }

        public void onPageSelected(int position) {
            FsTabLayout tabLayout = (FsTabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position && position < tabLayout.getTabCount()) {
                boolean updateIndicator = this.scrollState == 0 || this.scrollState == 2 && this.previousScrollState == 0;
                tabLayout.selectTab(tabLayout.getTabAt(position), updateIndicator);
            }
        }

        void reset() {
            this.scrollState = 0;
            this.previousScrollState = 0;
        }
    }

    public static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager viewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.viewPager = viewPager;
        }

        @Override
        public void onTabSelected(Tab tab) {
            this.viewPager.setCurrentItem(tab.getPosition());
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }

        @Override
        public void onTabReselected(Tab tab) {
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        PagerAdapterObserver() {
        }

        public void onChanged() {
            FsTabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            FsTabLayout.this.populateFromPagerAdapter();
        }
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        private boolean autoRefresh;

        AdapterChangeListener() {
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (FsTabLayout.this.viewPager == viewPager) {
                FsTabLayout.this.setPagerAdapter(newAdapter, this.autoRefresh);
            }
        }

        void setAutoRefresh(boolean autoRefresh) {
            this.autoRefresh = autoRefresh;
        }
    }
}

