/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsvideo.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtils {
    public static void initStateBar(Activity activity, int colorId) {
        int color = ContextCompat.getColor((Context)activity, (int)colorId);
        StatusBarUtils.initStateBarColor(activity, color);
    }

    public static void initStateBarColor(Activity activity, int color) {
        Window window = activity.getWindow();
        View decorView = window.getDecorView();
        ViewGroup rootView = (ViewGroup)decorView.findViewById(0x1020002);
        rootView.setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(color);
        } else {
            ViewGroup viewGroup = (ViewGroup)decorView;
            View statusBarView = new View((Context)activity);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, StatusBarUtils.getStatusBarHeight(activity));
            statusBarView.setBackgroundColor(color);
            viewGroup.addView(statusBarView, lp);
        }
        if (ColorUtils.calculateLuminance((int)color) >= 0.5) {
            decorView.setSystemUiVisibility(8192);
        } else {
            decorView.setSystemUiVisibility(0);
        }
    }

    public static int getStatusBarHeight(Activity activity) {
        int result = 0;
        int resourceId = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = activity.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static void hideStatusLan(Activity context) {
        if (Build.VERSION.SDK_INT >= 19) {
            context.getWindow().addFlags(0x4000000);
            context.getWindow().addFlags(0x8000000);
        }
    }

    public static void setStatusBarBackgroundColor(Activity activity, String colorRef) {
        int color = Color.parseColor((String)colorRef);
        StatusBarUtils.setStatusBarBackgroundColor(activity, color);
    }

    public static void setStatusBarBackgroundColor(Activity activity, int color) {
        boolean darkMode;
        if (Build.VERSION.SDK_INT < 19) {
            Log.i((String)"", (String)"setStatusBarBackgroundColor is ignore");
            return;
        }
        boolean bl = darkMode = ColorUtils.calculateLuminance((int)color) < 0.5;
        if (Build.VERSION.SDK_INT >= 23) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(color);
            View decorView = window.getDecorView();
            if (ColorUtils.calculateLuminance((int)color) >= 0.5) {
                decorView.setSystemUiVisibility(8192);
            } else {
                decorView.setSystemUiVisibility(0);
            }
        } else if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            if (StatusBarUtils.isMIUIStatusBarLightMode(activity, darkMode) || StatusBarUtils.isFlymeStatusBarLightMode(activity, darkMode)) {
                window.setStatusBarColor(color);
            } else {
                window.setStatusBarColor(-16777216);
            }
        } else {
            Log.i((String)"", (String)"setStatusBarBackgroundColor is ignore");
        }
    }

    public static boolean isMIUIStatusBarLightMode(Activity activity, boolean darkMode) {
        boolean result = false;
        Class<?> clazz = activity.getWindow().getClass();
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkMode ? darkModeFlag : 0, darkModeFlag);
            result = true;
        }
        catch (Exception e) {
            Log.e((String)"", (String)e.getMessage());
        }
        return result;
    }

    public static boolean isFlymeStatusBarLightMode(Activity activity, boolean darkMode) {
        boolean result = false;
        try {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = darkMode ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            activity.getWindow().setAttributes(lp);
            result = true;
        }
        catch (Exception e) {
            Log.e((String)"", (String)e.getMessage());
        }
        return result;
    }

    public static void hideNavigation(Activity activity) {
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT > 16 && Build.VERSION.SDK_INT < 19) {
            View v = activity.getWindow().getDecorView();
            v.setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.systemUiVisibility = 2050;
            window.setAttributes(params);
        }
    }

    public static int getNavigationBarHeight(Context context) {
        Resources res;
        int resourceId;
        int result = 0;
        if (StatusBarUtils.hasNavBar(context) && (resourceId = (res = context.getResources()).getIdentifier("navigation_bar_height", "dimen", "android")) > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @TargetApi(value=14)
    public static boolean hasNavBar(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            String sNavBarOverride = StatusBarUtils.getNavBarOverride();
            if ("1".equals(sNavBarOverride)) {
                hasNav = false;
            } else if ("0".equals(sNavBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sNavBarOverride;
    }
}

