/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsvideo;

import com.fshows.fsvideo.FsVideoPlayer;

public class FsVideoPlayerManager {
    private FsVideoPlayer mVideoPlayer;
    private static FsVideoPlayerManager sInstance;

    private FsVideoPlayerManager() {
    }

    public static synchronized FsVideoPlayerManager instance() {
        if (sInstance == null) {
            sInstance = new FsVideoPlayerManager();
        }
        return sInstance;
    }

    public FsVideoPlayer getVideoPlayer() {
        return this.mVideoPlayer;
    }

    public void setVideoPlayer(FsVideoPlayer videoPlayer) {
        if (this.mVideoPlayer != videoPlayer) {
            this.releaseFsVideoPlayer();
            this.mVideoPlayer = videoPlayer;
        }
    }

    public void releaseFsVideoPlayer() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.release();
            this.mVideoPlayer = null;
        }
    }

    public void suspendFsVideoPlayer() {
        if (this.mVideoPlayer != null && (this.mVideoPlayer.getPlayState() == 3 || this.mVideoPlayer.getPlayState() == 5)) {
            this.mVideoPlayer.pause();
        }
    }

    public void resumeFsVideoPlayer() {
        if (this.mVideoPlayer != null && (this.mVideoPlayer.getPlayState() == 4 || this.mVideoPlayer.getPlayState() == 6)) {
            this.mVideoPlayer.reStart();
        }
    }

    public boolean onBackPressd() {
        if (this.mVideoPlayer != null && this.mVideoPlayer.isFullScreen()) {
            return this.mVideoPlayer.exitFullScreen();
        }
        return false;
    }
}

