/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.MyBatisExceptionTranslator;
import org.mybatis.spring.SqlSessionHolder;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class SqlHelper {
    public static SqlSessionFactory FACTORY;

    public static SqlSession sqlSessionBatch(Class<?> clazz) {
        return SqlHelper.sqlSessionFactory(clazz).openSession(ExecutorType.BATCH);
    }

    public static SqlSessionFactory sqlSessionFactory(Class<?> clazz) {
        return GlobalConfigUtils.currentSessionFactory(clazz);
    }

    public static SqlSession sqlSession(Class<?> clazz) {
        return SqlSessionUtils.getSqlSession((SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(clazz));
    }

    public static TableInfo table(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)tableInfo, (String)"Error: Cannot execute table Method, ClassGenericType not found.", (Object[])new Object[0]);
        return tableInfo;
    }

    public static boolean retBool(Integer result) {
        return null != result && result >= 1;
    }

    public static boolean retBool(Long result) {
        return null != result && result >= 1L;
    }

    public static long retCount(Long result) {
        return null == result ? 0L : result;
    }

    public static <E> E getObject(Log log, List<E> list) {
        return SqlHelper.getObject(() -> log, list);
    }

    public static <E> E getObject(Supplier<Log> supplier, List<E> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                Log log = supplier.get();
                log.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean executeBatch(Class<?> entityClass, Log log, Consumer<SqlSession> consumer) {
        SqlSession sqlSession;
        SqlSessionFactory sqlSessionFactory = SqlHelper.sqlSessionFactory(entityClass);
        SqlSessionHolder sqlSessionHolder = (SqlSessionHolder)TransactionSynchronizationManager.getResource((Object)sqlSessionFactory);
        boolean transaction = TransactionSynchronizationManager.isSynchronizationActive();
        if (sqlSessionHolder != null) {
            sqlSession = sqlSessionHolder.getSqlSession();
            sqlSession.commit(!transaction);
        }
        sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);
        if (!transaction) {
            log.warn("SqlSession [" + sqlSession + "] Transaction not enabled");
        }
        try {
            consumer.accept(sqlSession);
            sqlSession.commit(!transaction);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            sqlSession.rollback();
            Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
            if (!(unwrapped instanceof PersistenceException)) throw ExceptionUtils.mpe((Throwable)unwrapped);
            MyBatisExceptionTranslator myBatisExceptionTranslator = new MyBatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
            DataAccessException throwable = myBatisExceptionTranslator.translateExceptionIfPossible((RuntimeException)((PersistenceException)unwrapped));
            if (throwable == null) throw ExceptionUtils.mpe((Throwable)unwrapped);
            throw throwable;
        }
        finally {
            sqlSession.close();
        }
    }

    public static <E> boolean executeBatch(Class<?> entityClass, Log log, Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        Assert.isFalse((batchSize < 1 ? 1 : 0) != 0, (String)"batchSize must not be less than one", (Object[])new Object[0]);
        return !CollectionUtils.isEmpty(list) && SqlHelper.executeBatch(entityClass, log, sqlSession -> {
            int size = list.size();
            int idxLimit = Math.min(batchSize, size);
            int i = 1;
            for (Object element : list) {
                consumer.accept((SqlSession)sqlSession, element);
                if (i == idxLimit) {
                    sqlSession.flushStatements();
                    idxLimit = Math.min(idxLimit + batchSize, size);
                }
                ++i;
            }
        });
    }

    public static <E> boolean saveOrUpdateBatch(Class<?> entityClass, Class<?> mapper, Log log, Collection<E> list, int batchSize, BiPredicate<SqlSession, E> predicate, BiConsumer<SqlSession, E> consumer) {
        String sqlStatement = SqlHelper.getSqlStatement(mapper, SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(entityClass, log, list, batchSize, (sqlSession, entity) -> {
            if (predicate.test((SqlSession)sqlSession, (Object)entity)) {
                sqlSession.insert(sqlStatement, entity);
            } else {
                consumer.accept((SqlSession)sqlSession, (Object)entity);
            }
        });
    }

    public static String getSqlStatement(Class<?> mapper, SqlMethod sqlMethod) {
        return mapper.getName() + "." + sqlMethod.getMethod();
    }

    public static <T, M extends BaseMapper<T>> M getMapper(Class<T> entityClass, SqlSession sqlSession) {
        Assert.notNull(entityClass, (String)"entityClass can't be null!", (Object[])new Object[0]);
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        Class mapperClass = ClassUtils.toClassConfident((String)tableInfo.getCurrentNamespace());
        return (M)((BaseMapper)tableInfo.getConfiguration().getMapper(mapperClass, sqlSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R, M extends BaseMapper<T>> R execute(Class<T> entityClass, SFunction<M, R> sFunction) {
        SqlSession sqlSession = SqlHelper.sqlSession(entityClass);
        try {
            Object object = sFunction.apply(SqlHelper.getMapper(entityClass, sqlSession));
            return (R)object;
        }
        finally {
            SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(entityClass));
        }
    }
}

