/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;

public class KeyGeneratorInterceptor
implements InnerInterceptor {
    private static final Log logger = LogFactory.getLog(KeyGeneratorInterceptor.class);

    @Override
    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) throws SQLException {
        Map param;
        if (ms.getId().contains(".insertBatch") && parameter instanceof Map && (param = (Map)parameter).containsKey("coll")) {
            List collection = (List)param.get("coll");
            this.initPkey(collection);
        }
    }

    public void initPkey(List collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object obj = collection.get(0);
        if (obj == null) {
            return;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(obj.getClass());
        if (tableInfo == null || tableInfo.getKeySequence() == null || tableInfo.getKeyGenerator() == null) {
            return;
        }
        if (tableInfo.getKeyType() == null || !Integer.class.equals((Object)tableInfo.getKeyType()) && !Long.class.equals((Object)tableInfo.getKeyType())) {
            return;
        }
        String selectSql = tableInfo.getKeyGenerator().executeSql(tableInfo.getKeySequence().value());
        Field keyField = tableInfo.getKeyField();
        keyField.setAccessible(true);
        Connection connection = SqlHelper.sqlSession(obj.getClass()).getConnection();
        for (Object po : collection) {
            try {
                keyField.set(po, this.getPkey(selectSql, tableInfo.getKeyType(), connection));
            }
            catch (IllegalAccessException e) {
                logger.error("Error:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getPkey(String sql, Class<T> keyType, Connection connection) {
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        Number pkey = null;
        try {
            countStmt = connection.prepareStatement(sql);
            rs = countStmt.executeQuery();
            if (rs.next()) {
                pkey = keyType.equals(Integer.class) ? (Number)rs.getInt(1) : (Number)rs.getLong(1);
            }
        }
        catch (SQLException e) {
            logger.error("Error:", (Throwable)e);
        }
        finally {
            try {
                rs.close();
                countStmt.close();
            }
            catch (SQLException e) {
                logger.error("Error:", (Throwable)e);
            }
        }
        return (T)pkey;
    }
}

