/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.AbstractJoinWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class JoinInterceptor
implements InnerInterceptor {
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    @Override
    public MappedStatement changeMappedStatement(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Object ew;
        if (parameter != null && parameter instanceof Map && ((Map)parameter).containsKey("ew") && (ew = ((Map)parameter).get("ew")) != null && ew instanceof AbstractJoinWrapper && ms.getResultMaps() != null && !ms.getResultMaps().isEmpty()) {
            return this.newMappedStatement(ms, ((ResultMap)ms.getResultMaps().get(0)).getType());
        }
        return ms;
    }

    public MappedStatement newMappedStatement(MappedStatement ms, Class<?> resultType) {
        MappedStatement statement;
        if (!resultType.isAnnotationPresent(TableName.class)) {
            return ms;
        }
        String id = ms.getId() + "_" + resultType.getName();
        Map<Configuration, MappedStatement> statementMap = MS_CACHE.get(id);
        if (CollectionUtils.isNotEmpty(statementMap) && Objects.nonNull(statement = statementMap.get(ms.getConfiguration()))) {
            return statement;
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        String joinResultMap = TableInfoHelper.getTableInfo(resultType).getResultMapForJoin();
        if (joinResultMap == null) {
            return ms;
        }
        resultMaps.add(ms.getConfiguration().getResultMap(TableInfoHelper.getTableInfo(resultType).getResultMapForJoin()));
        builder.resultMaps(resultMaps);
        MappedStatement mappedStatement = builder.build();
        if (statementMap == null) {
            statementMap = new ConcurrentHashMap<Configuration, MappedStatement>();
            MS_CACHE.put(id, statementMap);
        }
        statementMap.put(ms.getConfiguration(), mappedStatement);
        return mappedStatement;
    }
}

