/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractJoinWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.BaseFuncEnum;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.interfaces.QueryJoinFunc;

public class BasicJoinQueryWrapper<T>
extends AbstractJoinWrapper<T, ModelProperty, BasicJoinQueryWrapper<T>>
implements QueryJoinFunc<BasicJoinQueryWrapper<T>>,
Query<BasicJoinQueryWrapper<T>, T, ModelProperty> {
    private Class<?> mainClass;

    public BasicJoinQueryWrapper(Class<?> mainClass) {
        super(mainClass);
        this.mainClass = mainClass;
        super.initNeed();
    }

    protected BasicJoinQueryWrapper<T> instance() {
        return new BasicJoinQueryWrapper<T>(this.mainClass);
    }

    public BasicJoinQueryWrapper<T> select(ModelProperty ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (ModelProperty column : columns) {
                this.selectColumns.add(AbstractJoinWrapper.SelectColumn.of((Class)column.modelClass, (String)BasicJoinQueryWrapper.getCache(column.getModelClass(), (String)column.getPropertyName()).getColumn()));
            }
        }
        return (BasicJoinQueryWrapper)this.typedThis;
    }

    public final BasicJoinQueryWrapper<T> selectFun(BaseFuncEnum fun, String alias, ModelProperty column) {
        String columnStr = column == null ? "*" : (String)this.aliasMap.get(column.modelClass) + "." + BasicJoinQueryWrapper.getCache(column.getModelClass(), (String)column.getPropertyName()).getColumn();
        String funStr = String.format(fun.getSql(), columnStr);
        this.funSqlSelect.add(new SharedString(funStr + " AS " + alias));
        return (BasicJoinQueryWrapper)this.typedThis;
    }

    protected void initLogicDelete(Class<?> joinClass, String joinType) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(joinClass);
        if (tableInfo.getLogicDeleteFieldInfo() != null) {
            this.joinFroms.append("and ").append(tableInfo.getLogicDeleteFieldInfo().getColumn()).append("=").append(this.parseLogicNotDeleteValue(tableInfo.getLogicDeleteFieldInfo()));
        }
        if (this.aliasMap.size() == 2 && (tableInfo = TableInfoHelper.getTableInfo(this.mainClass)).getLogicDeleteFieldInfo() != null) {
            this.joinFroms.append("and ").append(tableInfo.getLogicDeleteFieldInfo().getColumn()).append("=").append(this.parseLogicNotDeleteValue(tableInfo.getLogicDeleteFieldInfo()));
        }
    }

    public MergeSegments getExpression() {
        if (this.aliasMap.size() == 1 && !this.isAppendMainLogicDelete) {
            this.isAppendMainLogicDelete = true;
            TableInfo tableInfo = TableInfoHelper.getTableInfo(this.mainClass);
            if (tableInfo.getLogicDeleteFieldInfo() != null) {
                this.eq(new ModelProperty(this.mainClass, tableInfo.getLogicDeleteFieldInfo().getProperty()), this.parseLogicNotDeleteValue(tableInfo.getLogicDeleteFieldInfo()));
            }
        }
        return this.expression;
    }

    @Override
    public BasicJoinQueryWrapper<T> join(Class<?> joinClass, String joinType) {
        this.pubJoin(joinClass, null, null, " LEFT JOIN ");
        return this;
    }

    protected String columnToString(ModelProperty column) {
        if (!this.aliasMap.containsKey(column.getModelClass())) {
            throw ExceptionUtils.mpe((String)"not join class: \"%s\".", (Object[])new Object[]{column.getModelClass().getName()});
        }
        return (String)this.aliasMap.get(column.getModelClass()) + "." + BasicJoinQueryWrapper.getCache((Class)column.modelClass, (String)column.getPropertyName()).getColumn();
    }

    public static class ModelProperty {
        private Class<?> modelClass;
        private String propertyName;

        public Class<?> getModelClass() {
            return this.modelClass;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setModelClass(Class<?> modelClass) {
            this.modelClass = modelClass;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelProperty)) {
                return false;
            }
            ModelProperty other = (ModelProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$modelClass = this.getModelClass();
            Class<?> other$modelClass = other.getModelClass();
            if (this$modelClass == null ? other$modelClass != null : !this$modelClass.equals(other$modelClass)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModelProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $modelClass = this.getModelClass();
            result = result * 59 + ($modelClass == null ? 43 : $modelClass.hashCode());
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            return result;
        }

        public String toString() {
            return "BasicJoinQueryWrapper.ModelProperty(modelClass=" + this.getModelClass() + ", propertyName=" + this.getPropertyName() + ")";
        }

        public ModelProperty(Class<?> modelClass, String propertyName) {
            this.modelClass = modelClass;
            this.propertyName = propertyName;
        }
    }
}

