/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.advance.query;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.advance.injector.FuntionTools;
import com.baomidou.mybatisplus.advance.query.DefaultPager;
import com.baomidou.mybatisplus.advance.query.FieldSort;
import com.baomidou.mybatisplus.advance.query.QueryField;
import com.baomidou.mybatisplus.advance.query.anno.SafeField;
import com.baomidou.mybatisplus.advance.query.enums.DirectionEnum;
import com.baomidou.mybatisplus.advance.query.enums.OperatorEnum;
import com.baomidou.mybatisplus.advance.query.enums.RelationEnum;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaJoinQueryWrapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;

@ApiModel(value="\u524d\u7aef\u9ad8\u7ea7\u67e5\u8be2\u5b9e\u4f53")
@Schema(title="\u524d\u7aef\u9ad8\u7ea7\u67e5\u8be2\u5b9e\u4f53")
public class QueryFilter<T> {
    @ApiModelProperty(value="\u5206\u9875\u4fe1\u606f")
    @Schema(title="\u5206\u9875\u4fe1\u606f")
    private DefaultPager<T> pagerInfo;
    @ApiModelProperty(name="sorter", notes="\u6392\u5e8f\u5b57\u6bb5")
    @Schema(title="\u6392\u5e8f\u5b57\u6bb5")
    private List<FieldSort> sorter = new ArrayList<FieldSort>();
    @ApiModelProperty(name="params", notes="\u6269\u5c55\u53c2\u6570")
    @Schema(title="\u6269\u5c55\u53c2\u6570")
    private Map<String, Object> params = new HashMap<String, Object>();
    @ApiModelProperty(name="querys", notes="\u67e5\u8be2\u6761\u4ef6\u96c6\u5408")
    @Schema(title="\u67e5\u8be2\u6761\u4ef6\u96c6\u5408")
    private List<QueryField> querys = new ArrayList<QueryField>();
    @ApiModelProperty(name="groupRelation", notes="\u67e5\u8be2\u6761\u4ef6\u5206\u7ec4\u7684\u5173\u7cfb", example="AND")
    @Schema(title="\u67e5\u8be2\u6761\u4ef6\u5206\u7ec4\u7684\u5173\u7cfb", example="AND")
    private String groupRelation;
    @ApiModelProperty(name="fields", notes="\u9700\u8981\u8fd4\u56de\u524d\u7aef\u7684\u5b57\u6bb5-\u4e0d\u4f20\u5219\u8fd4\u56de\u5168\u90e8", example="[\"name\",\"age\"]")
    @Schema(title="\u9700\u8981\u8fd4\u56de\u524d\u7aef\u7684\u5b57\u6bb5", example="AND")
    private String[] fields;
    @JsonIgnore
    @JSONField(serialize=false)
    private Set<String> safeFieldsSet = new HashSet<String>();

    public QueryFilter() {
        this.groupRelation = RelationEnum.AND.name();
    }

    private Map<String, List<QueryField>> groupQueryField() {
        if (this.querys == null) {
            return new HashMap<String, List<QueryField>>();
        }
        return this.querys.stream().collect(Collectors.groupingBy(QueryField::getGroup));
    }

    public Map<DirectionEnum, List<FieldSort>> groupFieldSort() {
        if (this.sorter == null) {
            return new HashMap<DirectionEnum, List<FieldSort>>();
        }
        return this.sorter.stream().collect(Collectors.groupingBy(FieldSort::getDirection));
    }

    public static <Z> LambdaJoinQueryWrapper<Z> reqParam2Wrapper(Class<Z> currentModelClass, Map<String, String> paramMap) {
        QueryField queryField;
        List fieldNames = QueryFilter.getAllField(currentModelClass).stream().map(Field::getName).collect(Collectors.toList());
        QueryFilter<Z> queryFilter = new QueryFilter<Z>();
        for (String string : fieldNames) {
            if (!paramMap.containsKey(string) || StringUtils.isEmpty((CharSequence)paramMap.get(string))) continue;
            queryField = new QueryField();
            if (paramMap.containsKey(string + "-op")) {
                queryField.setOperator(paramMap.get(string + "-op"));
            } else {
                queryField.setOperator("=");
            }
            queryField.setProperty(string);
            queryField.setValue(paramMap.get(string));
            queryFilter.getQuerys().add(queryField);
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            if (!OperatorEnum.IS_NULL.getOperator().equals(entry.getValue()) && !OperatorEnum.NOT_NULL.getOperator().equals(entry.getValue())) continue;
            queryField = new QueryField();
            queryField.setOperator((String)entry.getValue());
            queryField.setProperty(((String)entry.getKey()).replace("-op", ""));
            queryFilter.getQuerys().add(queryField);
        }
        return queryFilter.asWrapper(currentModelClass, new SFunction[0]);
    }

    public LambdaJoinQueryWrapper<T> asWrapper(Class<T> currentModelClass, SFunction<T, ?> ... safeFields) {
        List<Field> safeFieldList;
        if (safeFields != null) {
            for (SFunction<T, ?> safeField : safeFields) {
                LambdaMeta meta = LambdaUtils.extract(safeField);
                String fieldName = PropertyNamer.methodToProperty((String)meta.getImplMethodName());
                this.safeFieldsSet.add(fieldName);
            }
        }
        if (!(safeFieldList = QueryFilter.getAnnotationField(currentModelClass, SafeField.class)).isEmpty()) {
            this.safeFieldsSet.addAll(safeFieldList.stream().map(Field::getName).collect(Collectors.toList()));
        }
        LambdaJoinQueryWrapper queryWrapper = new LambdaJoinQueryWrapper(currentModelClass);
        Map<String, List<QueryField>> groupQueryField = this.groupQueryField();
        String groupRelation = this.getGroupRelation();
        groupQueryField.forEach((group, list) -> {
            List newListFields = list.stream().filter(queryField -> !this.safeFieldsSet.contains(queryField.getProperty())).filter(queryField -> {
                String value = queryField.getValue() == null ? null : queryField.getValue().toString();
                return value != null && !"".equals(value) && !"[]".equals(value);
            }).collect(Collectors.toList());
            if (newListFields.isEmpty()) {
                return;
            }
            if (RelationEnum.AND.name().equals(groupRelation)) {
                queryWrapper.and(x -> newListFields.forEach(l -> this.convertQueryField((LambdaJoinQueryWrapper<T>)x, (QueryField)l, currentModelClass)));
            } else {
                if (!RelationEnum.OR.name().equals(groupRelation)) {
                    throw ExceptionUtils.mpe((String)"This operator is not supported %s", (Object[])new Object[]{groupRelation});
                }
                queryWrapper.or(x -> newListFields.forEach(l -> this.convertQueryField((LambdaJoinQueryWrapper<T>)x, (QueryField)l, currentModelClass)));
            }
        });
        Map<DirectionEnum, List<FieldSort>> groupFieldSort = this.groupFieldSort();
        groupFieldSort.forEach((d, l) -> {
            if (DirectionEnum.DESC.equals(d)) {
                queryWrapper.orderByDesc(this.convertSortFieldList((List<FieldSort>)l, currentModelClass));
            } else {
                queryWrapper.orderByAsc(this.convertSortFieldList((List<FieldSort>)l, currentModelClass));
            }
        });
        return queryWrapper;
    }

    private List<SFunction<T, ?>> convertSortFieldList(List<FieldSort> list, Class<T> currentModelClass) {
        if (list == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (FieldSort fieldSort : list) {
            result.add(FuntionTools.getSFunction(currentModelClass, fieldSort.getProperty()));
        }
        return result;
    }

    @JSONField(serialize=false)
    public SFunction getField(String fieldName, Class<T> currentModelClass) {
        return FuntionTools.getSFunction(currentModelClass, fieldName);
    }

    private void convertQueryField(LambdaJoinQueryWrapper<T> queryWrapper, QueryField queryField, Class<T> currentModelClass) {
        String relation = queryField.getRelation();
        if (RelationEnum.OR.name().equals(relation)) {
            queryWrapper.or();
        }
        SFunction field = null;
        if (queryField.getTarget() != null) {
            try {
                Class<?> targetClass = Class.forName(queryField.getTarget());
                queryWrapper.innerJoin(targetClass);
                field = this.getField(queryField.getProperty(), targetClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            field = this.getField(queryField.getProperty(), currentModelClass);
        }
        String operator = queryField.getOperator();
        if (queryField.getValue() == null || "".equals(queryField.getValue()) || "null".equals(queryField.getValue() + "")) {
            return;
        }
        switch (OperatorEnum.getByOperator(operator)) {
            case EQ: {
                queryWrapper.eq((Object)field, queryField.getValue());
                break;
            }
            case LT: {
                queryWrapper.lt((Object)field, queryField.getValue());
                break;
            }
            case GT: {
                queryWrapper.gt((Object)field, queryField.getValue());
                break;
            }
            case LE: {
                queryWrapper.le((Object)field, queryField.getValue());
                break;
            }
            case GE: {
                queryWrapper.ge((Object)field, queryField.getValue());
                break;
            }
            case NE: {
                queryWrapper.ne((Object)field, queryField.getValue());
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)field, queryField.getValue());
                break;
            }
            case LIKE_LEFT: {
                queryWrapper.likeLeft((Object)field, queryField.getValue());
                break;
            }
            case LIKE_RIGHT: {
                queryWrapper.likeRight((Object)field, queryField.getValue());
                break;
            }
            case NOT_LIKE: {
                queryWrapper.notLike((Object)field, queryField.getValue());
                break;
            }
            case IS_NULL: {
                queryWrapper.isNull((Object)field);
                break;
            }
            case NOT_NULL: {
                queryWrapper.isNotNull((Object)field);
                break;
            }
            case IN: {
                Object[] values = this.convert2ObjectArray(queryField.getValue());
                if (values == null || values.length <= 0) break;
                queryWrapper.in((Object)field, values);
                break;
            }
            case BETWEEN: {
                Object[] objs = this.convert2ObjectArray(queryField.getValue());
                if (objs == null || objs.length <= 0) break;
                Assert.isTrue((objs.length == 2 ? 1 : 0) != 0, (String)String.format("The length of between must be 2 \uff1a%s", objs), (Object[])new Object[0]);
                queryWrapper.between((Object)field, objs[0], objs[1]);
                break;
            }
            case NOT_BETWEEN: {
                Object[] objsNotBetween = this.convert2ObjectArray(queryField.getValue());
                if (objsNotBetween != null && objsNotBetween.length > 0) {
                    Assert.isTrue((objsNotBetween.length == 2 ? 1 : 0) != 0, (String)String.format("The length of between must be 2 \uff1a%s", objsNotBetween), (Object[])new Object[0]);
                    queryWrapper.notBetween((Object)field, objsNotBetween[0], objsNotBetween[1]);
                }
            }
            case NOT_IN: {
                Object[] notInValues = this.convert2ObjectArray(queryField.getValue());
                if (notInValues == null || notInValues.length <= 0) break;
                queryWrapper.in((Object)field, notInValues);
            }
        }
    }

    private Object[] convert2ObjectArray(Object obj) {
        if (obj == null) {
            return new Object[]{"''"};
        }
        if (!(obj instanceof String)) {
            Object[] objectArray;
            if (obj instanceof List) {
                List objList = (List)obj;
                return objList.toArray();
            }
            if (obj instanceof Object[]) {
                return (Object[])obj;
            }
            if (obj instanceof Object) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = obj;
            } else {
                objectArray = null;
            }
            return objectArray;
        }
        String str = obj.toString();
        Object[] split = str.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = this.handleQuotation((String)split[i]);
        }
        return split;
    }

    private String handleQuotation(String str) {
        String ResultString = str;
        try {
            Pattern regex = Pattern.compile("^'(.*)'$");
            Matcher regexMatcher = regex.matcher(str);
            if (regexMatcher.find()) {
                ResultString = regexMatcher.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return ResultString;
    }

    private static <T extends Annotation> List<Field> getAnnotationField(Class<?> clazz, Class<T> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        List<Field> fields = QueryFilter.getAllField(clazz);
        for (Field field : fields) {
            if (field.getAnnotation(annotationClass) == null) continue;
            result.add(field);
        }
        return result;
    }

    private static List<Field> getAllField(Class clazz) {
        Field[] fields = null;
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != Object.class) {
            try {
                fields = clazz.getDeclaredFields();
                result.addAll(Arrays.asList(fields));
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static <T> QueryFilterBuilder<T> builder() {
        return new QueryFilterBuilder();
    }

    public DefaultPager<T> getPagerInfo() {
        return this.pagerInfo;
    }

    public List<FieldSort> getSorter() {
        return this.sorter;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public List<QueryField> getQuerys() {
        return this.querys;
    }

    public String getGroupRelation() {
        return this.groupRelation;
    }

    public String[] getFields() {
        return this.fields;
    }

    public Set<String> getSafeFieldsSet() {
        return this.safeFieldsSet;
    }

    public void setPagerInfo(DefaultPager<T> pagerInfo) {
        this.pagerInfo = pagerInfo;
    }

    public void setSorter(List<FieldSort> sorter) {
        this.sorter = sorter;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setQuerys(List<QueryField> querys) {
        this.querys = querys;
    }

    public void setGroupRelation(String groupRelation) {
        this.groupRelation = groupRelation;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    @JsonIgnore
    public void setSafeFieldsSet(Set<String> safeFieldsSet) {
        this.safeFieldsSet = safeFieldsSet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryFilter)) {
            return false;
        }
        QueryFilter other = (QueryFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DefaultPager<T> this$pagerInfo = this.getPagerInfo();
        DefaultPager<T> other$pagerInfo = other.getPagerInfo();
        if (this$pagerInfo == null ? other$pagerInfo != null : !((Object)this$pagerInfo).equals(other$pagerInfo)) {
            return false;
        }
        List<FieldSort> this$sorter = this.getSorter();
        List<FieldSort> other$sorter = other.getSorter();
        if (this$sorter == null ? other$sorter != null : !((Object)this$sorter).equals(other$sorter)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        List<QueryField> this$querys = this.getQuerys();
        List<QueryField> other$querys = other.getQuerys();
        if (this$querys == null ? other$querys != null : !((Object)this$querys).equals(other$querys)) {
            return false;
        }
        String this$groupRelation = this.getGroupRelation();
        String other$groupRelation = other.getGroupRelation();
        if (this$groupRelation == null ? other$groupRelation != null : !this$groupRelation.equals(other$groupRelation)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFields(), other.getFields())) {
            return false;
        }
        Set<String> this$safeFieldsSet = this.getSafeFieldsSet();
        Set<String> other$safeFieldsSet = other.getSafeFieldsSet();
        return !(this$safeFieldsSet == null ? other$safeFieldsSet != null : !((Object)this$safeFieldsSet).equals(other$safeFieldsSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultPager<T> $pagerInfo = this.getPagerInfo();
        result = result * 59 + ($pagerInfo == null ? 43 : ((Object)$pagerInfo).hashCode());
        List<FieldSort> $sorter = this.getSorter();
        result = result * 59 + ($sorter == null ? 43 : ((Object)$sorter).hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        List<QueryField> $querys = this.getQuerys();
        result = result * 59 + ($querys == null ? 43 : ((Object)$querys).hashCode());
        String $groupRelation = this.getGroupRelation();
        result = result * 59 + ($groupRelation == null ? 43 : $groupRelation.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        Set<String> $safeFieldsSet = this.getSafeFieldsSet();
        result = result * 59 + ($safeFieldsSet == null ? 43 : ((Object)$safeFieldsSet).hashCode());
        return result;
    }

    public String toString() {
        return "QueryFilter(pagerInfo=" + this.getPagerInfo() + ", sorter=" + this.getSorter() + ", params=" + this.getParams() + ", querys=" + this.getQuerys() + ", groupRelation=" + this.getGroupRelation() + ", fields=" + Arrays.deepToString(this.getFields()) + ", safeFieldsSet=" + this.getSafeFieldsSet() + ")";
    }

    public QueryFilter(DefaultPager<T> pagerInfo, List<FieldSort> sorter, Map<String, Object> params, List<QueryField> querys, String groupRelation, String[] fields, Set<String> safeFieldsSet) {
        this.pagerInfo = pagerInfo;
        this.sorter = sorter;
        this.params = params;
        this.querys = querys;
        this.groupRelation = groupRelation;
        this.fields = fields;
        this.safeFieldsSet = safeFieldsSet;
    }

    public static class QueryFilterBuilder<T> {
        private DefaultPager<T> pagerInfo;
        private List<FieldSort> sorter;
        private Map<String, Object> params;
        private List<QueryField> querys;
        private String groupRelation;
        private String[] fields;
        private Set<String> safeFieldsSet;

        QueryFilterBuilder() {
        }

        public QueryFilterBuilder<T> pagerInfo(DefaultPager<T> pagerInfo) {
            this.pagerInfo = pagerInfo;
            return this;
        }

        public QueryFilterBuilder<T> sorter(List<FieldSort> sorter) {
            this.sorter = sorter;
            return this;
        }

        public QueryFilterBuilder<T> params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public QueryFilterBuilder<T> querys(List<QueryField> querys) {
            this.querys = querys;
            return this;
        }

        public QueryFilterBuilder<T> groupRelation(String groupRelation) {
            this.groupRelation = groupRelation;
            return this;
        }

        public QueryFilterBuilder<T> fields(String[] fields) {
            this.fields = fields;
            return this;
        }

        @JsonIgnore
        public QueryFilterBuilder<T> safeFieldsSet(Set<String> safeFieldsSet) {
            this.safeFieldsSet = safeFieldsSet;
            return this;
        }

        public QueryFilter<T> build() {
            return new QueryFilter<T>(this.pagerInfo, this.sorter, this.params, this.querys, this.groupRelation, this.fields, this.safeFieldsSet);
        }

        public String toString() {
            return "QueryFilter.QueryFilterBuilder(pagerInfo=" + this.pagerInfo + ", sorter=" + this.sorter + ", params=" + this.params + ", querys=" + this.querys + ", groupRelation=" + this.groupRelation + ", fields=" + Arrays.deepToString(this.fields) + ", safeFieldsSet=" + this.safeFieldsSet + ")";
        }
    }
}

