/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.advance.injector.processor;

import com.baomidou.mybatisplus.advance.injector.ASTBuilder;
import com.baomidou.mybatisplus.advance.injector.processor.GenFieldsConstantProcessor;
import com.baomidou.mybatisplus.advance.injector.processor.GenFieldsMethodProcessor;
import com.baomidou.mybatisplus.advance.injector.processor.GenImplModelExtensionMethodProcessor;
import com.baomidou.mybatisplus.advance.injector.processor.GenMapperProcessor;
import com.baomidou.mybatisplus.advance.injector.processor.GenOperatorMethodProcessor;
import com.baomidou.mybatisplus.advance.injector.processor.GenQueryMethodProcessor;
import com.baomidou.mybatisplus.advance.injector.processor.MybatisPlusAPTProcessor;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.auto.service.AutoService;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"com.baomidou.mybatisplus.annotation.TableName"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class MybatisPlusModelInjectorAnnotationProcessor
extends AbstractProcessor {
    private static Set<MybatisPlusAPTProcessor> mybatisPlusAPTProcessors = new LinkedHashSet<MybatisPlusAPTProcessor>();
    private Context context;
    private JavacElements elementUtils;
    private TreeMaker treeMaker;
    private JavacTrees javacTrees;
    private Names names;
    private Trees trees;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.trees = Trees.instance(processingEnv);
        this.context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.elementUtils = (JavacElements)processingEnv.getElementUtils();
        this.treeMaker = TreeMaker.instance(this.context);
        this.javacTrees = JavacTrees.instance(processingEnv);
        super.init(processingEnv);
        this.names = Names.instance(this.context);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(TableName.class);
        for (Element element : set) {
            JCTree tree = this.javacTrees.getTree(element);
            this.treeMaker.pos = tree.pos;
            tree.accept(new TreeTranslator(){

                @Override
                public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
                    super.visitClassDef(jcClassDecl);
                    ASTBuilder aptBuilder = new ASTBuilder(MybatisPlusModelInjectorAnnotationProcessor.this.treeMaker, MybatisPlusModelInjectorAnnotationProcessor.this.elementUtils, MybatisPlusModelInjectorAnnotationProcessor.this.names, jcClassDecl);
                    for (MybatisPlusAPTProcessor mybatisPlusAPTProcessor : mybatisPlusAPTProcessors) {
                        mybatisPlusAPTProcessor.generate(aptBuilder);
                    }
                }
            });
        }
        return true;
    }

    static {
        mybatisPlusAPTProcessors.add(new GenMapperProcessor());
        mybatisPlusAPTProcessors.add(new GenFieldsConstantProcessor());
        mybatisPlusAPTProcessors.add(new GenFieldsMethodProcessor());
        mybatisPlusAPTProcessors.add(new GenOperatorMethodProcessor());
        mybatisPlusAPTProcessors.add(new GenQueryMethodProcessor());
        mybatisPlusAPTProcessors.add(new GenImplModelExtensionMethodProcessor());
    }
}

