/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.advance.injector;

import com.baomidou.mybatisplus.core.conditions.AbstractJoinWrapper;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.BasicJoinQueryWrapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;

public class FuntionTools {
    private static final int FLAG_SERIALIZABLE = 1;
    private static Map<String, SFunction> functionMap = new HashMap<String, SFunction>();

    public static void addAction(List<Action> actions, String operator, Object po, String property, Object value) {
        actions.add(new Action(po.getClass(), property, operator, value, null, null, null));
    }

    public static void addAction(List<Action> actions, String operator, Object po, String property, Object minValue, Object maxValue) {
        actions.add(new Action(po.getClass(), property, operator, null, minValue, maxValue, null));
    }

    public static LambdaQueryWrapper buildQueryWrapper(List<Action> actions, Object po) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        for (Action action : actions) {
            if (action.getModelClass().equals(po.getClass()) && !"select".equals(action.getAction())) {
                SFunction column = FuntionTools.getSFunction(action.getModelClass(), action.getProperty());
                FuntionTools.buildWhere((AbstractWrapper)queryWrapper, action, column);
                continue;
            }
            if (!"select".equals(action.getAction()) || !action.getModelClass().equals(po.getClass())) continue;
            SFunction[] columns = new SFunction[action.getProperties().length];
            int i = 0;
            for (String property : action.getProperties()) {
                columns[i++] = FuntionTools.getSFunction(action.getModelClass(), property);
            }
            queryWrapper.select(columns);
        }
        return queryWrapper;
    }

    public static void buildWhere(AbstractWrapper queryWrapper, Action action, Object column) {
        switch (action.getAction()) {
            case "eq": {
                queryWrapper.eq(column, action.getValue());
                break;
            }
            case "lt": {
                queryWrapper.lt(column, action.getValue());
                break;
            }
            case "gt": {
                queryWrapper.gt(column, action.getValue());
                break;
            }
            case "le": {
                queryWrapper.le(column, action.getValue());
                break;
            }
            case "ge": {
                queryWrapper.ge(column, action.getValue());
                break;
            }
            case "ne": {
                queryWrapper.ne(column, action.getValue());
                break;
            }
            case "like": {
                queryWrapper.like(column, action.getValue());
                break;
            }
            case "likeLeft": {
                queryWrapper.likeLeft(column, action.getValue());
                break;
            }
            case "likeRight": {
                queryWrapper.likeRight(column, action.getValue());
                break;
            }
            case "notLike": {
                queryWrapper.notLike(column, action.getValue());
                break;
            }
            case "isNull": {
                queryWrapper.isNull(column);
                break;
            }
            case "notNull": {
                queryWrapper.isNotNull(column);
                break;
            }
            case "in": {
                queryWrapper.in(column, (Collection)action.getValue());
                break;
            }
            case "notIn": {
                queryWrapper.notIn(column, (Collection)action.getValue());
                break;
            }
            case "orderByAsc": {
                queryWrapper.orderByAsc(column);
                break;
            }
            case "orderByDesc": {
                queryWrapper.orderByDesc(column);
                break;
            }
            case "between": {
                queryWrapper.between(column, action.getMin(), action.getMax());
                break;
            }
            case "notBetween": {
                queryWrapper.notBetween(column, action.getMin(), action.getMax());
            }
        }
    }

    public static BasicJoinQueryWrapper buildJoinWrapper(List<Action> actions, Object po) {
        BasicJoinQueryWrapper queryWrapper = new BasicJoinQueryWrapper(po.getClass());
        for (Action action : actions) {
            if (!action.getAction().contains("join")) continue;
            switch (action.getAction()) {
                case "join": {
                    queryWrapper.innerJoin(action.getModelClass());
                    break;
                }
                case "leftJoin": {
                    queryWrapper.leftJoin(action.getModelClass());
                }
            }
        }
        for (Action action : actions) {
            if (!"select".equals(action.getAction()) && !action.getAction().contains("join")) {
                BasicJoinQueryWrapper.ModelProperty column = new BasicJoinQueryWrapper.ModelProperty(action.getModelClass(), action.getProperty());
                FuntionTools.buildWhere((AbstractWrapper)queryWrapper, action, column);
                continue;
            }
            if (!"select".equals(action.getAction())) continue;
            BasicJoinQueryWrapper.ModelProperty[] columns = new BasicJoinQueryWrapper.ModelProperty[action.getProperties().length];
            int i = 0;
            for (String property : action.getProperties()) {
                columns[i++] = new BasicJoinQueryWrapper.ModelProperty(action.getModelClass(), property);
            }
            queryWrapper.select(columns);
        }
        return queryWrapper;
    }

    public static boolean isJoin(List<Action> actions) {
        return actions.stream().filter(action -> action.getAction().contains("join")).count() > 0L;
    }

    public static <T> T join(Class<T> target, List<Action> actions, String joinType) {
        try {
            T result = target.newInstance();
            Field field = (Field)ReflectionKit.getFieldMap(target).get("actions");
            field.setAccessible(true);
            field.set(result, actions);
            actions.add(new Action(target, null, joinType, null, null, null, null));
            return result;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List list(List<Action> actions, Object po) {
        boolean isJoin = FuntionTools.isJoin(actions);
        BasicJoinQueryWrapper wrapper = isJoin ? FuntionTools.buildJoinWrapper(actions, po) : FuntionTools.buildQueryWrapper(actions, po);
        SqlSession sqlSession = FuntionTools.sqlSession(po.getClass());
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", wrapper);
        try {
            List list = sqlSession.selectList(FuntionTools.sqlStatement(SqlMethod.SELECT_LIST, po.getClass()), (Object)map);
            return list;
        }
        finally {
            FuntionTools.closeSqlSession(sqlSession, po.getClass());
        }
    }

    public static void addSelect(List<Action> actions, Object po, String ... fields) {
        actions.add(new Action(po.getClass(), null, "select", null, null, null, fields));
    }

    public static String getDBField(Class entityClass, String fieldName) {
        ColumnCache columnCache = AbstractJoinWrapper.getCache((Class)entityClass, (String)fieldName);
        if (columnCache != null) {
            return columnCache.getColumn();
        }
        throw ExceptionUtils.mpe((String)"This class %s is not have field %s ", (Object[])new Object[]{entityClass.getName(), fieldName});
    }

    public static Object one(List<Action> actions, Object po) {
        List list = FuntionTools.list(actions, po);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long count(List<Action> actions, Object po) {
        boolean isJoin = FuntionTools.isJoin(actions);
        BasicJoinQueryWrapper wrapper = isJoin ? FuntionTools.buildJoinWrapper(actions, po) : FuntionTools.buildQueryWrapper(actions, po);
        SqlSession sqlSession = FuntionTools.sqlSession(po.getClass());
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", wrapper);
        try {
            Long l = (Long)sqlSession.selectOne(FuntionTools.sqlStatement(SqlMethod.SELECT_COUNT, po.getClass()), (Object)map);
            return l;
        }
        finally {
            FuntionTools.closeSqlSession(sqlSession, po.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer update(List<Action> actions, Object po) {
        LambdaQueryWrapper wrapper = FuntionTools.buildQueryWrapper(actions, po);
        SqlSession sqlSession = FuntionTools.sqlSession(po.getClass());
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", wrapper);
        map.put("et", po);
        try {
            Integer n = sqlSession.update(FuntionTools.sqlStatement(SqlMethod.UPDATE, po.getClass()), (Object)map);
            return n;
        }
        finally {
            FuntionTools.closeSqlSession(sqlSession, po.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer delete(List<Action> actions, Object po) {
        LambdaQueryWrapper wrapper = FuntionTools.buildQueryWrapper(actions, po);
        SqlSession sqlSession = FuntionTools.sqlSession(po.getClass());
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", wrapper);
        try {
            Integer n = sqlSession.delete(FuntionTools.sqlStatement(SqlMethod.DELETE, po.getClass()), (Object)map);
            return n;
        }
        finally {
            FuntionTools.closeSqlSession(sqlSession, po.getClass());
        }
    }

    protected static SqlSession sqlSession(Class poClass) {
        return SqlHelper.sqlSession((Class)poClass);
    }

    protected static String sqlStatement(SqlMethod sqlMethod, Class poClass) {
        return FuntionTools.sqlStatement(sqlMethod.getMethod(), poClass);
    }

    protected static String sqlStatement(String sqlMethod, Class poClass) {
        return SqlHelper.table((Class)poClass).getSqlStatement(sqlMethod);
    }

    protected static void closeSqlSession(SqlSession sqlSession, Class poClass) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory((Class)poClass));
    }

    public static SFunction getSFunction(Class<?> entityClass, String fieldName) {
        if (functionMap.containsKey(entityClass.getName() + fieldName)) {
            return functionMap.get(entityClass.getName() + fieldName);
        }
        Field field = FuntionTools.getDeclaredField(entityClass, fieldName);
        if (field == null) {
            throw ExceptionUtils.mpe((String)"This class %s is not have field %s ", (Object[])new Object[]{entityClass.getName(), fieldName});
        }
        SFunction func = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodType = MethodType.methodType(field.getType(), entityClass);
        String getFunName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            CallSite site = LambdaMetafactory.altMetafactory(lookup, "invoke", MethodType.methodType(SFunction.class), methodType, lookup.findVirtual(entityClass, getFunName, MethodType.methodType(field.getType())), methodType, 1);
            func = site.getTarget().invokeExact();
            functionMap.put(entityClass.getName() + field, func);
            return func;
        }
        catch (Throwable e) {
            throw ExceptionUtils.mpe((String)"This class %s is not have method %s ", (Object[])new Object[]{entityClass.getName(), getFunName});
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        Field field = null;
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static class Action {
        private Class<?> modelClass;
        private String property;
        private String action;
        private Object value;
        private Object min;
        private Object max;
        private String[] properties;

        public Class<?> getModelClass() {
            return this.modelClass;
        }

        public String getProperty() {
            return this.property;
        }

        public String getAction() {
            return this.action;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getMin() {
            return this.min;
        }

        public Object getMax() {
            return this.max;
        }

        public String[] getProperties() {
            return this.properties;
        }

        public void setModelClass(Class<?> modelClass) {
            this.modelClass = modelClass;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setMin(Object min) {
            this.min = min;
        }

        public void setMax(Object max) {
            this.max = max;
        }

        public void setProperties(String[] properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$modelClass = this.getModelClass();
            Class<?> other$modelClass = other.getModelClass();
            if (this$modelClass == null ? other$modelClass != null : !this$modelClass.equals(other$modelClass)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Object this$min = this.getMin();
            Object other$min = other.getMin();
            if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
                return false;
            }
            Object this$max = this.getMax();
            Object other$max = other.getMax();
            if (this$max == null ? other$max != null : !this$max.equals(other$max)) {
                return false;
            }
            return Arrays.deepEquals(this.getProperties(), other.getProperties());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $modelClass = this.getModelClass();
            result = result * 59 + ($modelClass == null ? 43 : $modelClass.hashCode());
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Object $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : $min.hashCode());
            Object $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : $max.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getProperties());
            return result;
        }

        public String toString() {
            return "FuntionTools.Action(modelClass=" + this.getModelClass() + ", property=" + this.getProperty() + ", action=" + this.getAction() + ", value=" + this.getValue() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", properties=" + Arrays.deepToString(this.getProperties()) + ")";
        }

        public Action(Class<?> modelClass, String property, String action, Object value, Object min, Object max, String[] properties) {
            this.modelClass = modelClass;
            this.property = property;
            this.action = action;
            this.value = value;
            this.min = min;
            this.max = max;
            this.properties = properties;
        }
    }
}

