/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.advance.injector;

import com.baomidou.mybatisplus.annotation.TableId;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ASTBuilder {
    private JavacElements elementUtils;
    private TreeMaker treeMaker;
    private Names names;
    private JCTree.JCClassDecl jcClassDecl;
    private Map<String, List<JCTree.JCVariableDecl>> hasMethod = new HashMap<String, List<JCTree.JCVariableDecl>>();
    private final ArrayList<JCTree.JCVariableDecl> fields = new ArrayList();
    private final Set<String> fieldNames = new HashSet<String>();

    public ASTBuilder(TreeMaker treeMaker, JavacElements elementUtils, Names names, JCTree.JCClassDecl jcClassDecl) {
        this.treeMaker = treeMaker;
        this.elementUtils = elementUtils;
        this.names = names;
        this.jcClassDecl = jcClassDecl;
        jcClassDecl.defs.stream().filter(it -> it.getKind().equals((Object)Tree.Kind.METHOD)).map(it -> (JCTree.JCMethodDecl)it).forEach(it -> this.hasMethod.put(it.name.toString(), it.params));
        jcClassDecl.defs.stream().filter(it -> it.getKind().equals((Object)Tree.Kind.VARIABLE)).map(it -> (JCTree.JCVariableDecl)it).forEach(it -> {
            if (this.isHandle((JCTree.JCVariableDecl)it, jcClassDecl)) {
                this.fields.add((JCTree.JCVariableDecl)it);
                this.fieldNames.add(it.name.toString());
            }
        });
    }

    public boolean hasMethod(String methodName) {
        return this.hasMethod.containsKey(methodName);
    }

    public boolean hasField(String fieldName) {
        return this.fieldNames.contains(fieldName);
    }

    public boolean isHandle(JCTree.JCVariableDecl jcVariableDecl, JCTree.JCClassDecl jcClassDecl) {
        if (jcVariableDecl.vartype == null || jcVariableDecl.vartype.type == null) {
            return false;
        }
        String typeName = jcVariableDecl.vartype.type.tsym.toString();
        if (!typeName.startsWith("java.")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(typeName);
            return Comparable.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass, String method, Object value) {
        if (this.jcClassDecl.mods == null || this.jcClassDecl.mods.annotations == null) {
            return false;
        }
        for (JCTree.JCAnnotation annotation : this.jcClassDecl.mods.annotations) {
            if (!annotation.type.toString().equals(annotationClass.getName())) continue;
            for (Pair<Symbol.MethodSymbol, Attribute> methodSymbolAttributePair : annotation.attribute.values) {
                if (!((Symbol.MethodSymbol)methodSymbolAttributePair.fst).toString().contains(method + "()")) continue;
                return ((Attribute)methodSymbolAttributePair.snd).toString().equals(value.toString());
            }
        }
        return false;
    }

    public JCTree.JCExpression typeRef(String typeClassName) {
        String[] componentArray = typeClassName.split("\\.");
        JCTree.JCExpression expr = this.treeMaker.Ident(this.elementUtils.getName(componentArray[0]));
        for (int i = 1; i < componentArray.length; ++i) {
            expr = this.treeMaker.Select(expr, this.elementUtils.getName(componentArray[i]));
        }
        return expr;
    }

    public JCTree.JCExpression getIdTypeRef() {
        for (JCTree.JCVariableDecl field : this.fields) {
            if (field.mods == null || field.mods.annotations == null) continue;
            for (JCTree.JCAnnotation annotation : field.mods.annotations) {
                if (!annotation.type.toString().equals(TableId.class.getName())) continue;
                return field.vartype;
            }
        }
        return null;
    }

    public JCTree.JCVariableDecl genField(String fieldName, String typeClassName, JCTree.JCExpression value) {
        JCTree.JCVariableDecl result = this.treeMaker.VarDef(this.treeMaker.Modifiers(2L), this.names.fromString(fieldName), this.typeRef(typeClassName), value);
        result.mods.annotations = result.mods.annotations.append(this.treeMaker.Annotation(this.typeRef("com.baomidou.mybatisplus.annotation.TableField"), List.of(this.treeMaker.Assign(this.treeMaker.Ident(this.names.fromString("exist")), this.treeMaker.Literal(false)))));
        result.mods.annotations = result.mods.annotations.append(this.treeMaker.Annotation(this.typeRef("com.alibaba.fastjson.annotation.JSONField"), List.of(this.treeMaker.Assign(this.treeMaker.Ident(this.names.fromString("serialize")), this.treeMaker.Literal(false)))));
        result.mods.annotations = result.mods.annotations.append(this.treeMaker.Annotation(this.typeRef("com.fasterxml.jackson.annotation.JsonIgnore"), List.nil()));
        return result;
    }

    public JCTree.JCMethodInvocation callMethod(String method, String[] types, List<JCTree.JCExpression> paramsList) {
        List<JCTree.JCExpression> paramsTypeList = List.nil();
        for (String type : types) {
            paramsTypeList = paramsTypeList.append(this.typeRef(type));
        }
        return this.treeMaker.Apply(paramsTypeList, this.typeRef(method), paramsList);
    }

    public JCTree.JCNewClass newObject(String classAllName, List<JCTree.JCExpression> constructorParams) {
        return this.treeMaker.NewClass(null, List.nil(), this.typeRef(classAllName), constructorParams, null);
    }

    public JCTree.JCMethodDecl genMethod(List<JCTree.JCExpression> execFunparamsList, List<JCTree.JCVariableDecl> genMethodParamsList, String[] execMethodParamTypes, JCTree.JCExpression returnMethodType, JCTree.JCReturn returnStatement, String execMethodAllName, Name methodName) {
        TreeMaker treeMaker = this.getTreeMaker();
        ListBuffer<JCTree.JCStatement> statments = new ListBuffer<JCTree.JCStatement>();
        if (execFunparamsList != null) {
            JCTree.JCMethodInvocation callMethod = this.callMethod(execMethodAllName, execMethodParamTypes, execFunparamsList);
            statments.append(treeMaker.Exec(callMethod));
        }
        statments.append(returnStatement);
        JCTree.JCModifiers modifiers = treeMaker.Modifiers(1L);
        JCTree.JCBlock body = treeMaker.Block(0L, statments.toList());
        List<JCTree.JCTypeParameter> methodGenericParamList = List.nil();
        List<JCTree.JCExpression> thrownCauseList = List.nil();
        return treeMaker.MethodDef(modifiers, methodName, returnMethodType, methodGenericParamList, genMethodParamsList, thrownCauseList, body, null);
    }

    public void addMethod(JCTree.JCMethodDecl method) {
        this.jcClassDecl.defs = this.jcClassDecl.defs.append(method);
        this.hasMethod.put(method.name.toString(), null);
    }

    public void addField(JCTree.JCVariableDecl variableDecl) {
        this.jcClassDecl.defs = this.jcClassDecl.defs.append(variableDecl);
        this.fieldNames.add(variableDecl.name.toString());
    }

    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    public TreeMaker getTreeMaker() {
        return this.treeMaker;
    }

    public Names getNames() {
        return this.names;
    }

    public JCTree.JCClassDecl getJcClassDecl() {
        return this.jcClassDecl;
    }

    public Map<String, List<JCTree.JCVariableDecl>> getHasMethod() {
        return this.hasMethod;
    }

    public ArrayList<JCTree.JCVariableDecl> getFields() {
        return this.fields;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setElementUtils(JavacElements elementUtils) {
        this.elementUtils = elementUtils;
    }

    public void setTreeMaker(TreeMaker treeMaker) {
        this.treeMaker = treeMaker;
    }

    public void setNames(Names names) {
        this.names = names;
    }

    public void setJcClassDecl(JCTree.JCClassDecl jcClassDecl) {
        this.jcClassDecl = jcClassDecl;
    }

    public void setHasMethod(Map<String, List<JCTree.JCVariableDecl>> hasMethod) {
        this.hasMethod = hasMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ASTBuilder)) {
            return false;
        }
        ASTBuilder other = (ASTBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavacElements this$elementUtils = this.getElementUtils();
        JavacElements other$elementUtils = other.getElementUtils();
        if (this$elementUtils == null ? other$elementUtils != null : !this$elementUtils.equals(other$elementUtils)) {
            return false;
        }
        TreeMaker this$treeMaker = this.getTreeMaker();
        TreeMaker other$treeMaker = other.getTreeMaker();
        if (this$treeMaker == null ? other$treeMaker != null : !this$treeMaker.equals(other$treeMaker)) {
            return false;
        }
        Names this$names = this.getNames();
        Names other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) {
            return false;
        }
        JCTree.JCClassDecl this$jcClassDecl = this.getJcClassDecl();
        JCTree.JCClassDecl other$jcClassDecl = other.getJcClassDecl();
        if (this$jcClassDecl == null ? other$jcClassDecl != null : !this$jcClassDecl.equals(other$jcClassDecl)) {
            return false;
        }
        Map<String, List<JCTree.JCVariableDecl>> this$hasMethod = this.getHasMethod();
        Map<String, List<JCTree.JCVariableDecl>> other$hasMethod = other.getHasMethod();
        if (this$hasMethod == null ? other$hasMethod != null : !((Object)this$hasMethod).equals(other$hasMethod)) {
            return false;
        }
        ArrayList<JCTree.JCVariableDecl> this$fields = this.getFields();
        ArrayList<JCTree.JCVariableDecl> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set<String> this$fieldNames = this.getFieldNames();
        Set<String> other$fieldNames = other.getFieldNames();
        return !(this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ASTBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavacElements $elementUtils = this.getElementUtils();
        result = result * 59 + ($elementUtils == null ? 43 : $elementUtils.hashCode());
        TreeMaker $treeMaker = this.getTreeMaker();
        result = result * 59 + ($treeMaker == null ? 43 : $treeMaker.hashCode());
        Names $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : $names.hashCode());
        JCTree.JCClassDecl $jcClassDecl = this.getJcClassDecl();
        result = result * 59 + ($jcClassDecl == null ? 43 : $jcClassDecl.hashCode());
        Map<String, List<JCTree.JCVariableDecl>> $hasMethod = this.getHasMethod();
        result = result * 59 + ($hasMethod == null ? 43 : ((Object)$hasMethod).hashCode());
        ArrayList<JCTree.JCVariableDecl> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set<String> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 43 : ((Object)$fieldNames).hashCode());
        return result;
    }

    public String toString() {
        return "ASTBuilder(elementUtils=" + this.getElementUtils() + ", treeMaker=" + this.getTreeMaker() + ", names=" + this.getNames() + ", jcClassDecl=" + this.getJcClassDecl() + ", hasMethod=" + this.getHasMethod() + ", fields=" + this.getFields() + ", fieldNames=" + this.getFieldNames() + ")";
    }
}

