/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.TextBuffer;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import com.fasterxml.jackson.dataformat.ion.IonParser;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import com.fasterxml.jackson.dataformat.ion.util.CloseSafeUTF8Writer;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.system.IonSystemBuilder;

public class IonFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_ION = "AmazonIon";
    final IonSystem _system;
    protected boolean _cfgCreateBinaryWriters = false;

    public IonFactory() {
        this(null);
    }

    public IonFactory(ObjectCodec mapper) {
        this(mapper, IonSystemBuilder.standard().build());
    }

    public IonFactory(ObjectCodec mapper, IonSystem system) {
        super(mapper);
        this._system = system;
    }

    protected IonFactory(IonFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._system = src._system;
        this._cfgCreateBinaryWriters = src._cfgCreateBinaryWriters;
    }

    public IonFactory copy() {
        this._checkInvalidCopy(IonFactory.class);
        return new IonFactory(this, null);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public String getFormatName() {
        return FORMAT_NAME_ION;
    }

    public void setCreateBinaryWriters(boolean b) {
        this._cfgCreateBinaryWriters = b;
    }

    public boolean createBinaryWriters() {
        return this._cfgCreateBinaryWriters;
    }

    public boolean canHandleBinaryNatively() {
        return this._cfgCreateBinaryWriters;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public IonParser createParser(IonReader in) {
        return new IonParser(in, this._system, this._createContext(in, false), this.getCodec());
    }

    public IonParser createParser(IonValue value) {
        IonReader in = value.getSystem().newReader(value);
        return new IonParser(in, this._system, this._createContext(in, true), this.getCodec());
    }

    public JsonGenerator createGenerator(IonWriter out) {
        return this._createGenerator(out, this._createContext(out, false), (Closeable)out);
    }

    @Deprecated
    public IonParser createJsonParser(IonReader in) {
        return new IonParser(in, this._system, this._createContext(in, false), this.getCodec());
    }

    @Deprecated
    public IonParser createJsonParser(IonValue value) {
        IonReader in = value.getSystem().newReader(value);
        return new IonParser(in, this._system, this._createContext(in, true), this.getCodec());
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(IonWriter out) {
        return this._createGenerator(out, this._createContext(out, false), (Closeable)out);
    }

    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        IonReader ion = this._system.newReader(in);
        return new IonParser(ion, this._system, ctxt, this.getCodec());
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return new IonParser(this._system.newReader(r), this._system, ctxt, this.getCodec());
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return this._createParser(new CharArrayReader(data, offset, len), ctxt);
    }

    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new IonParser(this._system.newReader(data, offset, len), this._system, ctxt, this.getCodec());
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createGenerator(out, enc, false);
    }

    public JsonGenerator createGenerator(Writer out) throws IOException {
        if (this.createBinaryWriters()) {
            throw new IOException("Can only create binary Ion writers that output to OutputStream, not Writer");
        }
        return this._createGenerator(this._system.newTextWriter((Appendable)out), this._createContext(out, false), out);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        return this._createGenerator(new FileOutputStream(f), enc, true);
    }

    @Deprecated
    protected String _readAll(Reader r, IOContext ctxt) throws IOException {
        TextBuffer tb = ctxt.constructTextBuffer();
        char[] buf = tb.emptyAndGetCurrentSegment();
        int offset = 0;
        while (true) {
            if (offset < buf.length) {
                int count = r.read(buf, offset, buf.length - offset);
                if (count < 0) break;
                offset += count;
                continue;
            }
            buf = tb.finishCurrentSegment();
            offset = 0;
        }
        tb.setCurrentLength(offset);
        String result = tb.contentsAsString();
        tb.releaseBuffers();
        return result;
    }

    protected IonGenerator _createGenerator(OutputStream out, JsonEncoding enc, boolean isManaged) throws IOException {
        Closeable dst;
        IonWriter ion;
        IOContext ctxt = this._createContext(out, isManaged);
        if (this.createBinaryWriters()) {
            ctxt.setEncoding(enc);
            ion = this._system.newBinaryWriter(out, new SymbolTable[0]);
            dst = out;
        } else {
            if (enc != JsonEncoding.UTF8) {
                throw new IOException("Ion only supports UTF-8 encoding, can not use " + enc);
            }
            ctxt.setEncoding(enc);
            CloseSafeUTF8Writer w = new CloseSafeUTF8Writer(ctxt, out);
            ion = this._system.newTextWriter((Appendable)w);
            dst = w;
        }
        return this._createGenerator(ion, ctxt, dst);
    }

    protected IonGenerator _createGenerator(IonWriter ion, IOContext ctxt, Closeable dst) {
        return new IonGenerator(this._generatorFeatures, this._objectCodec, ion, ctxt, dst);
    }
}

