/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.deeptestutils;

import com.diffblue.deeptestutils.FieldList;
import com.diffblue.deeptestutils.FieldValue;
import com.diffblue.deeptestutils.UnexpectedValueException;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;

public final class CompareWithFieldList {
    private static PrintStream debugOut;
    private static HashSet<Class> primitives;

    private CompareWithFieldList() {
    }

    private static Field getField(Class cls, String name) {
        Class currentClass = cls;
        while (cls != null) {
            try {
                return currentClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        return null;
    }

    private static void fail(Object actual, Object expected, String prefix) {
        String actualStr = actual == null ? "null" : actual.getClass().getName() + " " + actual.toString();
        String expectedStr = expected == null ? "null" : expected.getClass().getName() + " " + expected.toString();
        String fieldStr = prefix.equals("") ? "" : "Field " + prefix + ": ";
        throw new UnexpectedValueException(fieldStr + "Expected " + expectedStr + " got " + actualStr);
    }

    public static void compare(Object primitiveOrFieldList, Object real, String prefix, HashMap<Object, Object> objectStack) {
        Object previousReal;
        if (real == null) {
            if (primitiveOrFieldList == null) {
                if (debugOut != null) {
                    debugOut.printf("%s null as expected\n", prefix);
                }
                return;
            }
            CompareWithFieldList.fail(real, primitiveOrFieldList, prefix);
        }
        if (real.equals(primitiveOrFieldList)) {
            if (debugOut != null) {
                debugOut.printf("%s = %s as expected\n", prefix, real.toString());
            }
            return;
        }
        if (primitiveOrFieldList == null) {
            CompareWithFieldList.fail(real, primitiveOrFieldList, prefix);
        }
        if (primitives.contains(primitiveOrFieldList.getClass())) {
            CompareWithFieldList.fail(real, primitiveOrFieldList, prefix);
        }
        if ((previousReal = objectStack.get(primitiveOrFieldList)) != null) {
            if (previousReal != real) {
                throw new UnexpectedValueException("At field %s, cyclic data structure has incorrect shape");
            }
            if (debugOut != null) {
                debugOut.printf("%s is a cyclic back-pointer of expected shape\n", prefix);
            }
            return;
        }
        objectStack.put(primitiveOrFieldList, real);
        if (primitiveOrFieldList.getClass().isArray()) {
            Object[] rhsArray;
            Object[] lhsArray;
            if (!real.getClass().isArray()) {
                CompareWithFieldList.fail(real, primitiveOrFieldList, prefix);
            }
            if ((lhsArray = (Object[])primitiveOrFieldList).length != (rhsArray = (Object[])real).length) {
                CompareWithFieldList.fail(real, primitiveOrFieldList, prefix);
            }
            for (int i = 0; i < lhsArray.length; ++i) {
                String newPrefix = prefix + "[" + i + "]";
                CompareWithFieldList.compare(lhsArray[i], rhsArray[i], newPrefix, objectStack);
            }
            objectStack.remove(primitiveOrFieldList);
            return;
        }
        if (!(primitiveOrFieldList instanceof FieldList)) {
            throw new RuntimeException("Right-hand operand must be a primitive or a FieldList object");
        }
        FieldList rhs = (FieldList)primitiveOrFieldList;
        for (FieldValue v : rhs.getFields()) {
            Object realval;
            Field field = CompareWithFieldList.getField(real.getClass(), v.getName());
            if (field == null) {
                throw new RuntimeException("Real object of class " + real.getClass().getName() + " did not have expected field " + v.getName());
            }
            field.setAccessible(true);
            try {
                realval = field.get(real);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            String newPrefix = prefix + "." + v.getName();
            CompareWithFieldList.compare(v.getValue(), realval, newPrefix, objectStack);
        }
        objectStack.remove(primitiveOrFieldList);
    }

    public static void compare(Object primitiveOrFieldList, Object real) {
        HashMap<Object, Object> objectStack = new HashMap<Object, Object>();
        CompareWithFieldList.compare(primitiveOrFieldList, real, "", objectStack);
    }

    static {
        String outPath = System.getenv("CWFL_OUTPUT_FILE");
        if (outPath != null) {
            try {
                debugOut = new PrintStream(outPath);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            debugOut = null;
        }
        primitives = new HashSet();
        primitives.add(Boolean.class);
        primitives.add(Character.class);
        primitives.add(Byte.class);
        primitives.add(Short.class);
        primitives.add(Integer.class);
        primitives.add(Long.class);
        primitives.add(Float.class);
        primitives.add(Double.class);
    }
}

