/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.InvalidMessageException;
import com.timgroup.statsd.StatsDClientErrorHandler;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class StatsDSender
implements Runnable {
    private static final Charset MESSAGE_CHARSET = Charset.forName("UTF-8");
    private static final String MESSAGE_TOO_LONG = "Message longer than size of sendBuffer";
    private final ByteBuffer sendBuffer;
    private final Callable<SocketAddress> addressLookup;
    private final BlockingQueue<String> queue;
    private final StatsDClientErrorHandler handler;
    private final DatagramChannel clientChannel;
    private volatile boolean shutdown;

    StatsDSender(Callable<SocketAddress> addressLookup, int queueSize, StatsDClientErrorHandler handler, DatagramChannel clientChannel, int maxPacketSizeBytes) {
        this(addressLookup, new LinkedBlockingQueue<String>(queueSize), handler, clientChannel, maxPacketSizeBytes);
    }

    StatsDSender(Callable<SocketAddress> addressLookup, BlockingQueue<String> queue, StatsDClientErrorHandler handler, DatagramChannel clientChannel, int maxPacketSizeBytes) {
        this.sendBuffer = ByteBuffer.allocate(maxPacketSizeBytes);
        this.addressLookup = addressLookup;
        this.queue = queue;
        this.handler = handler;
        this.clientChannel = clientChannel;
    }

    boolean send(String message) {
        if (!this.shutdown) {
            this.queue.offer(message);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (!this.queue.isEmpty() || !this.shutdown) {
            try {
                if (Thread.interrupted()) {
                    return;
                }
                String message = this.queue.poll(1L, TimeUnit.SECONDS);
                if (null == message) continue;
                byte[] data = message.getBytes(MESSAGE_CHARSET);
                if (this.sendBuffer.capacity() < data.length) {
                    throw new InvalidMessageException(MESSAGE_TOO_LONG, message);
                }
                SocketAddress address = this.addressLookup.call();
                if (this.sendBuffer.remaining() < data.length + 1) {
                    this.blockingSend(address);
                }
                if (this.sendBuffer.position() > 0) {
                    this.sendBuffer.put((byte)10);
                }
                this.sendBuffer.put(data);
                if (null != this.queue.peek()) continue;
                this.blockingSend(address);
            }
            catch (InterruptedException e) {
                if (!this.shutdown) continue;
                return;
            }
            catch (Exception e) {
                this.handler.handle(e);
            }
        }
    }

    private void blockingSend(SocketAddress address) throws IOException {
        int sizeOfBuffer = this.sendBuffer.position();
        this.sendBuffer.flip();
        int sentBytes = this.clientChannel.send(this.sendBuffer, address);
        this.sendBuffer.limit(this.sendBuffer.capacity());
        this.sendBuffer.rewind();
        if (sizeOfBuffer != sentBytes) {
            this.handler.handle(new IOException(String.format("Could not send entirely stat %s to %s. Only sent %d bytes out of %d bytes", this.sendBuffer.toString(), address.toString(), sentBytes, sizeOfBuffer)));
        }
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    void shutdown() {
        this.shutdown = true;
    }
}

