/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.ReadTier;
import org.rocksdb.RocksObject;
import org.rocksdb.Snapshot;

public class ReadOptions
extends RocksObject {
    public ReadOptions() {
        super(ReadOptions.newReadOptions());
    }

    public boolean verifyChecksums() {
        assert (this.isOwningHandle());
        return this.verifyChecksums(this.nativeHandle_);
    }

    public ReadOptions setVerifyChecksums(boolean bl) {
        assert (this.isOwningHandle());
        this.setVerifyChecksums(this.nativeHandle_, bl);
        return this;
    }

    public boolean fillCache() {
        assert (this.isOwningHandle());
        return this.fillCache(this.nativeHandle_);
    }

    public ReadOptions setFillCache(boolean bl) {
        assert (this.isOwningHandle());
        this.setFillCache(this.nativeHandle_, bl);
        return this;
    }

    public Snapshot snapshot() {
        assert (this.isOwningHandle());
        long l = this.snapshot(this.nativeHandle_);
        if (l != 0L) {
            return new Snapshot(l);
        }
        return null;
    }

    public ReadOptions setSnapshot(Snapshot snapshot) {
        assert (this.isOwningHandle());
        if (snapshot != null) {
            this.setSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        } else {
            this.setSnapshot(this.nativeHandle_, 0L);
        }
        return this;
    }

    public ReadTier readTier() {
        assert (this.isOwningHandle());
        return ReadTier.getReadTier(this.readTier(this.nativeHandle_));
    }

    public ReadOptions setReadTier(ReadTier readTier) {
        assert (this.isOwningHandle());
        this.setReadTier(this.nativeHandle_, readTier.getValue());
        return this;
    }

    public boolean tailing() {
        assert (this.isOwningHandle());
        return this.tailing(this.nativeHandle_);
    }

    public ReadOptions setTailing(boolean bl) {
        assert (this.isOwningHandle());
        this.setTailing(this.nativeHandle_, bl);
        return this;
    }

    public boolean managed() {
        assert (this.isOwningHandle());
        return this.managed(this.nativeHandle_);
    }

    public ReadOptions setManaged(boolean bl) {
        assert (this.isOwningHandle());
        this.setManaged(this.nativeHandle_, bl);
        return this;
    }

    public boolean totalOrderSeek() {
        assert (this.isOwningHandle());
        return this.totalOrderSeek(this.nativeHandle_);
    }

    public ReadOptions setTotalOrderSeek(boolean bl) {
        assert (this.isOwningHandle());
        this.setTotalOrderSeek(this.nativeHandle_, bl);
        return this;
    }

    public boolean prefixSameAsStart() {
        assert (this.isOwningHandle());
        return this.prefixSameAsStart(this.nativeHandle_);
    }

    public ReadOptions setPrefixSameAsStart(boolean bl) {
        assert (this.isOwningHandle());
        this.setPrefixSameAsStart(this.nativeHandle_, bl);
        return this;
    }

    public boolean pinData() {
        assert (this.isOwningHandle());
        return this.pinData(this.nativeHandle_);
    }

    public ReadOptions setPinData(boolean bl) {
        assert (this.isOwningHandle());
        this.setPinData(this.nativeHandle_, bl);
        return this;
    }

    private static native long newReadOptions();

    private native boolean verifyChecksums(long var1);

    private native void setVerifyChecksums(long var1, boolean var3);

    private native boolean fillCache(long var1);

    private native void setFillCache(long var1, boolean var3);

    private native long snapshot(long var1);

    private native void setSnapshot(long var1, long var3);

    private native byte readTier(long var1);

    private native void setReadTier(long var1, byte var3);

    private native boolean tailing(long var1);

    private native void setTailing(long var1, boolean var3);

    private native boolean managed(long var1);

    private native void setManaged(long var1, boolean var3);

    private native boolean totalOrderSeek(long var1);

    private native void setTotalOrderSeek(long var1, boolean var3);

    private native boolean prefixSameAsStart(long var1);

    private native void setPrefixSameAsStart(long var1, boolean var3);

    private native boolean pinData(long var1);

    private native void setPinData(long var1, boolean var3);

    @Override
    protected final native void disposeInternal(long var1);
}

