/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.id.generator.self;

import com.dangdang.ddframe.rdb.sharding.id.generator.IdGenerator;
import com.dangdang.ddframe.rdb.sharding.id.generator.self.CommonSelfIdGenerator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostNameIdGenerator
implements IdGenerator {
    private final CommonSelfIdGenerator commonSelfIdGenerator = new CommonSelfIdGenerator();

    static void initWorkerId() {
        Long workerId;
        InetAddress address;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot get LocalHost InetAddress, please check your network!");
        }
        String hostName = address.getHostName();
        try {
            workerId = Long.valueOf(hostName.replace(hostName.replaceAll("\\d+$", ""), ""));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Wrong hostname:%s, hostname must be end with number!", hostName));
        }
        CommonSelfIdGenerator.setWorkerId(workerId);
    }

    public Number generateId() {
        return this.commonSelfIdGenerator.generateId();
    }

    static {
        HostNameIdGenerator.initWorkerId();
    }
}

