/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.id.generator.self;

import com.dangdang.ddframe.rdb.sharding.id.generator.IdGenerator;
import com.dangdang.ddframe.rdb.sharding.id.generator.self.time.AbstractClock;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSelfIdGenerator
implements IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(CommonSelfIdGenerator.class);
    public static final long SJDBC_EPOCH;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final long WORKER_ID_MAX_VALUE = 1024L;
    private static AbstractClock clock;
    private static long workerId;
    private long sequence;
    private long lastTime;

    static void initWorkerId() {
        String workerId = System.getProperty("sjdbc.self.id.generator.worker.id");
        if (!Strings.isNullOrEmpty((String)workerId)) {
            CommonSelfIdGenerator.setWorkerId(Long.valueOf(workerId));
            return;
        }
        workerId = System.getenv("SJDBC_SELF_ID_GENERATOR_WORKER_ID");
        if (Strings.isNullOrEmpty((String)workerId)) {
            return;
        }
        CommonSelfIdGenerator.setWorkerId(Long.valueOf(workerId));
    }

    public static void setWorkerId(Long workerId) {
        Preconditions.checkArgument((workerId >= 0L && workerId < 1024L ? 1 : 0) != 0);
        CommonSelfIdGenerator.workerId = workerId;
    }

    public synchronized Number generateId() {
        long time = clock.millis();
        Preconditions.checkState((this.lastTime <= time ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds", (Object[])new Object[]{this.lastTime, time});
        if (this.lastTime == time) {
            ++this.sequence;
            if (0L == (this.sequence &= 0xFFFL)) {
                time = this.waitUntilNextTime(time);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = time;
        if (log.isDebugEnabled()) {
            log.debug("{}-{}-{}", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.lastTime)), workerId, this.sequence});
        }
        return time - SJDBC_EPOCH << 22 | workerId << 12 | this.sequence;
    }

    private long waitUntilNextTime(long lastTime) {
        long time = clock.millis();
        while (time <= lastTime) {
            time = clock.millis();
        }
        return time;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public static void setClock(AbstractClock clock) {
        CommonSelfIdGenerator.clock = clock;
    }

    public static long getWorkerId() {
        return workerId;
    }

    static {
        clock = AbstractClock.systemClock();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 10, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        SJDBC_EPOCH = calendar.getTimeInMillis();
        CommonSelfIdGenerator.initWorkerId();
    }
}

